/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.wizardinfo;

import com.vmware.opsmgmt.client.alarms.AlarmDefInfoSpec;
import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.alarms.EventAlarmDetails;
import com.vmware.opsmgmt.client.alarms.ServerCollection;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.configuration.AlarmConfiguration;
import com.vmware.opsmgmt.client.extension.alarms.configuration.AlarmConfigurator;
import com.vmware.opsmgmt.client.extension.alarms.configuration.MetricTrigger;
import com.vmware.opsmgmt.client.extension.alarms.configuration.StateCollection;
import com.vmware.opsmgmt.client.extension.alarms.configuration.StateTrigger;
import com.vmware.opsmgmt.client.extension.alarms.configuration.Trigger;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmDefWizardInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmDefWizardSpec;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmEventTriggerInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmMetricTriggerInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmStateTriggerInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmTriggerCategoryInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmTriggerInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.triggercategories.AlarmTriggerCategoryConfig;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.triggercategories.AlarmTriggerCategoryUtil;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryOption;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmWizardInfoCreator {
    private static final Log _logger = LogFactory.getLog(AlarmWizardInfoCreator.class);
    private static final String ALARM_WIZARD_INFO = "alarmWizardInfo";
    private static final int QUERY_TIMEOUT_MILLI_SECONDS = 60000;
    private static final String ALARM_OTHER_TRIGGER_CATEGORY_KEY = "AnyType.triggerCategory.Others";
    private AlarmConfiguration alarmConfiguration = new AlarmConfigurator().parseConfig();
    private QuerySpecBuilder querySpecBuilder;
    private QueryExecutor queryExecutor;
    private DataService dataService;

    public AlarmWizardInfoCreator(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this.queryExecutor = queryExecutor;
        this.querySpecBuilder = querySpecBuilder;
    }

    public AlarmDefWizardInfo createAlarmWizardinfo(ManagedObjectReference managedObjectReference, AlarmDefWizardSpec alarmDefWizardSpec) throws Exception {
        Object object;
        Object object2;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"Requested h5AlarmWizardInfo for monitor object type : ", alarmDefWizardSpec.monitorType, " and alarm: ", alarmDefWizardSpec.alarm}));
        }
        List<StateTrigger> list = this.alarmConfiguration.getStateTriggersByMoType(alarmDefWizardSpec.monitorType);
        List<MetricTrigger> list2 = this.alarmConfiguration.getMetricTriggersByMoType(alarmDefWizardSpec.monitorType);
        Map<String, StateTrigger> map = this.mapSCToStateTriggerConfig(list);
        Map<String, MetricTrigger> map2 = this.mapIdToMetricTriggerConfig(list2);
        AlarmDefinitionInfo alarmDefinitionInfo = this.getAlarmDefinitionInfo(managedObjectReference, alarmDefWizardSpec.monitorType, alarmDefWizardSpec.alarm, map2.keySet(), map.keySet());
        AlarmDefWizardInfo alarmDefWizardInfo = new AlarmDefWizardInfo();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (alarmDefinitionInfo.states != null) {
            for (ServerCollection object4 : alarmDefinitionInfo.states) {
                object2 = map.get(object4.name);
                AlarmStateTriggerInfo alarmStateTriggerInfo = new AlarmStateTriggerInfo();
                alarmStateTriggerInfo.displayText = Localization.getTriggerName((Trigger)object2);
                alarmStateTriggerInfo.stateTriggerConfig = object2;
                alarmStateTriggerInfo.serverCollection = object4;
                hashMap.put(((StateTrigger)object2).nameResourceId.toLowerCase(), (Object)alarmStateTriggerInfo);
            }
        }
        if (alarmDefinitionInfo.counters != null) {
            for (PerformanceManager.CounterInfo counterInfo : alarmDefinitionInfo.counters) {
                object2 = this.getCounterId(counterInfo);
                MetricTrigger metricTrigger = map2.get(object2);
                object = new AlarmMetricTriggerInfo();
                ((AlarmMetricTriggerInfo)((Object)object)).counterInfo = counterInfo;
                ((AlarmMetricTriggerInfo)((Object)object)).metricTriggerConfig = metricTrigger;
                ((AlarmMetricTriggerInfo)((Object)object)).displayText = Localization.getTriggerName(metricTrigger);
                hashMap.put(((String)object2).toLowerCase(), object);
            }
        }
        if (alarmDefinitionInfo.events != null) {
            for (EventAlarmDetails eventAlarmDetails : alarmDefinitionInfo.events) {
                object2 = new AlarmEventTriggerInfo();
                ((AlarmEventTriggerInfo)((Object)object2)).eventDetails = eventAlarmDetails;
                ((AlarmEventTriggerInfo)((Object)object2)).displayText = eventAlarmDetails.description != null ? eventAlarmDetails.description : eventAlarmDetails.eventTypeId;
                hashMap.put(eventAlarmDetails.eventTypeId.toLowerCase(), object2);
            }
        }
        for (StateTrigger stateTrigger : list) {
            StateCollection stateCollection = stateTrigger.states;
            if (stateCollection == null || stateCollection.serverCollection != null) continue;
            AlarmStateTriggerInfo alarmStateTriggerInfo = new AlarmStateTriggerInfo();
            alarmStateTriggerInfo.displayText = Localization.getTriggerName(stateTrigger);
            alarmStateTriggerInfo.stateTriggerConfig = stateTrigger;
            hashMap.put(stateTrigger.nameResourceId.toLowerCase(), (Object)alarmStateTriggerInfo);
        }
        AlarmTriggerCategoryConfig[] alarmTriggerCategoryConfigArray = AlarmTriggerCategoryUtil.getTriggerCategories(alarmDefWizardSpec.monitorType);
        ArrayList<AlarmTriggerCategoryInfo> arrayList = new ArrayList<AlarmTriggerCategoryInfo>();
        if (!ArrayUtil.isNullOrEmpty((Object[])alarmTriggerCategoryConfigArray)) {
            for (Object object3 : alarmTriggerCategoryConfigArray) {
                AlarmTriggerInfo alarmTriggerInfo;
                object = new ArrayList();
                if (((AlarmTriggerCategoryConfig)object3).states != null) {
                    for (String string : ((AlarmTriggerCategoryConfig)object3).states) {
                        alarmTriggerInfo = (AlarmTriggerInfo)((Object)hashMap.remove(string = string.toLowerCase()));
                        if (alarmTriggerInfo == null) continue;
                        object.add(alarmTriggerInfo);
                    }
                }
                if (((AlarmTriggerCategoryConfig)object3).counters != null) {
                    for (String string : ((AlarmTriggerCategoryConfig)object3).counters) {
                        alarmTriggerInfo = (AlarmTriggerInfo)((Object)hashMap.remove(string = string.toLowerCase()));
                        if (alarmTriggerInfo == null) continue;
                        object.add(alarmTriggerInfo);
                    }
                }
                if (((AlarmTriggerCategoryConfig)object3).events != null) {
                    for (String string : ((AlarmTriggerCategoryConfig)object3).events) {
                        alarmTriggerInfo = (AlarmTriggerInfo)((Object)hashMap.remove(string = string.toLowerCase()));
                        if (alarmTriggerInfo == null) continue;
                        object.add(alarmTriggerInfo);
                    }
                }
                if (object.size() <= 0) continue;
                AlarmTriggerCategoryInfo alarmTriggerCategoryInfo = new AlarmTriggerCategoryInfo();
                alarmTriggerCategoryInfo.categoryName = Localization.getTriggerCategoryName(alarmDefWizardSpec.monitorType, ((AlarmTriggerCategoryConfig)object3).categoryKey);
                alarmTriggerCategoryInfo.triggers = this.sortTheTriggerInfos((Collection<AlarmTriggerInfo>)object).toArray(new AlarmTriggerInfo[0]);
                arrayList.add(alarmTriggerCategoryInfo);
            }
        }
        if (hashMap.size() > 0) {
            AlarmTriggerCategoryInfo alarmTriggerCategoryInfo = new AlarmTriggerCategoryInfo();
            alarmTriggerCategoryInfo.categoryName = Localization.getString(ALARM_OTHER_TRIGGER_CATEGORY_KEY);
            alarmTriggerCategoryInfo.triggers = this.sortTheTriggerInfos(hashMap.values()).toArray(new AlarmTriggerInfo[0]);
            arrayList.add(alarmTriggerCategoryInfo);
        }
        alarmDefWizardInfo.triggerCategories = this.sortTheTriggerCategoryInfos(arrayList).toArray(new AlarmTriggerCategoryInfo[0]);
        alarmDefWizardInfo.migrateActionArgs = alarmDefinitionInfo.migrateActionArgs;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"Returning h5AlarmWizardInfo for monitor object type : ", alarmDefWizardSpec.monitorType, " and alarm: ", alarmDefWizardSpec.alarm, " with trigger category count ", alarmDefWizardInfo.triggerCategories.length}));
        }
        return alarmDefWizardInfo;
    }

    private Map<String, StateTrigger> mapSCToStateTriggerConfig(List<StateTrigger> list) {
        HashMap<String, StateTrigger> hashMap = new HashMap<String, StateTrigger>();
        for (StateTrigger stateTrigger : list) {
            String string = stateTrigger.states.serverCollection;
            if (string == null) continue;
            hashMap.put(string, stateTrigger);
        }
        return hashMap;
    }

    private Map<String, MetricTrigger> mapIdToMetricTriggerConfig(List<MetricTrigger> list) {
        HashMap<String, MetricTrigger> hashMap = new HashMap<String, MetricTrigger>();
        for (MetricTrigger metricTrigger : list) {
            hashMap.put(metricTrigger.counter, metricTrigger);
        }
        return hashMap;
    }

    private AlarmDefinitionInfo getAlarmDefinitionInfo(ManagedObjectReference managedObjectReference, String string, ManagedObjectReference managedObjectReference2, Collection<String> collection, Collection<String> collection2) throws Exception {
        AlarmDefInfoSpec alarmDefInfoSpec = this.createAlarmDefInfoSpec(string, managedObjectReference2, collection, collection2);
        QuerySpec querySpec = this.querySpecBuilder.buildQuerySpec((Object)managedObjectReference, new String[]{ALARM_WIZARD_INFO});
        querySpec.options = new HashMap();
        querySpec.options.put(QueryOption.DS_CORE_QUERY_TIMEOUT_MS.name(), 60000);
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.parameter = alarmDefInfoSpec;
        parameterSpec.propertyName = ALARM_WIZARD_INFO;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{ALARM_WIZARD_INFO};
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        querySpec.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{parameterSpec};
        ResultSet resultSet = this.queryExecutor.getData(querySpec);
        return this.extractAlarmDefinitionInfoFromResultSet(resultSet);
    }

    private AlarmDefInfoSpec createAlarmDefInfoSpec(String string, ManagedObjectReference managedObjectReference, Collection<String> collection, Collection<String> collection2) {
        AlarmDefInfoSpec alarmDefInfoSpec = new AlarmDefInfoSpec();
        alarmDefInfoSpec.moType = string;
        alarmDefInfoSpec.getEvents = true;
        alarmDefInfoSpec.alarm = managedObjectReference;
        alarmDefInfoSpec.counters = collection.toArray(new String[0]);
        alarmDefInfoSpec.serverCollections = collection2.toArray(new String[0]);
        return alarmDefInfoSpec;
    }

    private AlarmDefinitionInfo extractAlarmDefinitionInfoFromResultSet(ResultSet resultSet) {
        if (resultSet == null || resultSet.items == null) {
            return new AlarmDefinitionInfo();
        }
        for (ResultItem resultItem : resultSet.items) {
            if (resultItem == null || resultItem.properties == null) continue;
            for (PropertyValue propertyValue : resultItem.properties) {
                if (propertyValue == null || !ALARM_WIZARD_INFO.equals(propertyValue.propertyName)) continue;
                return (AlarmDefinitionInfo)propertyValue.value;
            }
        }
        return new AlarmDefinitionInfo();
    }

    private String getCounterId(PerformanceManager.CounterInfo counterInfo) {
        return String.format("%s.%s.%s", counterInfo.groupInfo.key, counterInfo.nameInfo.key, counterInfo.rollupType).toLowerCase();
    }

    private List<AlarmTriggerInfo> sortTheTriggerInfos(Collection<AlarmTriggerInfo> collection) {
        ArrayList<AlarmTriggerInfo> arrayList = new ArrayList<AlarmTriggerInfo>(collection);
        Collections.sort(arrayList, new Comparator<AlarmTriggerInfo>(){

            @Override
            public int compare(AlarmTriggerInfo alarmTriggerInfo, AlarmTriggerInfo alarmTriggerInfo2) {
                if (alarmTriggerInfo == null || alarmTriggerInfo.displayText == null) {
                    return -1;
                }
                return alarmTriggerInfo.displayText.compareToIgnoreCase(alarmTriggerInfo2.displayText);
            }
        });
        return arrayList;
    }

    private List<AlarmTriggerCategoryInfo> sortTheTriggerCategoryInfos(Collection<AlarmTriggerCategoryInfo> collection) {
        ArrayList<AlarmTriggerCategoryInfo> arrayList = new ArrayList<AlarmTriggerCategoryInfo>(collection);
        Collections.sort(arrayList, new Comparator<AlarmTriggerCategoryInfo>(){

            @Override
            public int compare(AlarmTriggerCategoryInfo alarmTriggerCategoryInfo, AlarmTriggerCategoryInfo alarmTriggerCategoryInfo2) {
                if (alarmTriggerCategoryInfo == null || alarmTriggerCategoryInfo.categoryName == null) {
                    return -1;
                }
                return alarmTriggerCategoryInfo.categoryName.compareToIgnoreCase(alarmTriggerCategoryInfo2.categoryName);
            }
        });
        return arrayList;
    }
}

