/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.AlarmDefInfoSpec;
import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.alarms.AlarmEventArgsSpec;
import com.vmware.opsmgmt.client.alarms.EventAlarmDetails;
import com.vmware.opsmgmt.client.alarms.ServerCollection;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.ElementDescription;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.action.Action;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.action.MethodActionArgument;
import com.vmware.vim.binding.vim.alarm.AlarmAction;
import com.vmware.vim.binding.vim.alarm.AlarmDescription;
import com.vmware.vim.binding.vim.alarm.AlarmExpression;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmManager;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vim.binding.vim.alarm.AndAlarmExpression;
import com.vmware.vim.binding.vim.alarm.EventAlarmExpression;
import com.vmware.vim.binding.vim.alarm.GroupAlarmAction;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import com.vmware.vim.binding.vim.alarm.OrAlarmExpression;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmDefinitionInfoProvider
implements PropertyProviderBean {
    private static final String BINDING_PACKAGE = "com.vmware.vim.binding.";
    private static final String[] INOPERATIVE_TRIGGERS = new String[]{"vim.event.DatastoreRemovedOnHostEvent", "vim.event.VmRemovedEvent", "VmRemovedEvent"};
    private static final String MIGRATE_ACTION_NAME = "MigrateVM_Task";
    private static final Log _logger = LogFactory.getLog(AlarmDefinitionInfoProvider.class);
    private DataService _dataService;

    public AlarmDefinitionInfoProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="Alarm")
    public AlarmDefinitionInfo getAlarmDefinitionInfo(ManagedObjectReference managedObjectReference, Object[] objectArray) throws Exception {
        return this.getAlarmDefinitionInfoForAlarm(managedObjectReference, objectArray);
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Folder,DatacenterFolder,DatastoreFolder,HostFolder,NetworkFolder,VirtualMachineFolder,Datacenter,ComputeResource,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Network,DistributedVirtualPortgroup,Datastore,StoragePod")
    public AlarmDefinitionInfo getAlarmWizardInfo(ManagedObjectReference managedObjectReference, AlarmDefInfoSpec alarmDefInfoSpec) throws Exception {
        AlarmDefinitionInfo alarmDefinitionInfo = new AlarmDefinitionInfo();
        String string = managedObjectReference.getServerGuid();
        if (alarmDefInfoSpec.serverCollections != null && alarmDefInfoSpec.serverCollections.length != 0) {
            alarmDefinitionInfo.states = this.processServerCollections(string, alarmDefInfoSpec.serverCollections);
        }
        LinkedList<EventAlarmExpression> linkedList = new LinkedList<EventAlarmExpression>();
        LinkedList<MetricAlarmExpression> linkedList2 = new LinkedList<MetricAlarmExpression>();
        if (alarmDefInfoSpec.alarm != null) {
            AlarmInfo alarmInfo = this.getAlarmInfo(alarmDefInfoSpec.alarm);
            AlarmExpression alarmExpression = alarmInfo.expression;
            this.extractAlarmExpressions(alarmExpression, linkedList, linkedList2);
        }
        if (alarmDefInfoSpec.getEvents) {
            alarmDefinitionInfo.events = this.getEventsInfo(alarmDefInfoSpec.moType, managedObjectReference, linkedList, alarmDefInfoSpec.includeAllEventArgs);
        }
        alarmDefinitionInfo.counters = this.getCounterInfo(linkedList2, string, alarmDefInfoSpec.counters);
        return alarmDefinitionInfo;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Folder,DatacenterFolder,DatastoreFolder,HostFolder,NetworkFolder,VirtualMachineFolder,Datacenter,ComputeResource,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Network,DistributedVirtualPortgroup,Datastore,StoragePod")
    public EventDescription.EventArgDesc[] getAlarmEventArgs(ManagedObjectReference managedObjectReference, AlarmEventArgsSpec alarmEventArgsSpec) throws Exception {
        Validate.notNull((Object)alarmEventArgsSpec);
        Validate.notEmpty((String)alarmEventArgsSpec.eventTypeId, (String)"eventTypeId is required");
        EventManager eventManager = this.getEventManager(managedObjectReference.getServerGuid());
        EventDescription.EventArgDesc[] eventArgDescArray = eventManager.retrieveArgumentDescription(alarmEventArgsSpec.eventTypeId);
        if (eventArgDescArray == null) {
            eventArgDescArray = new EventDescription.EventArgDesc[]{};
        }
        return eventArgDescArray;
    }

    private EventAlarmDetails[] getEventsInfo(String string, ManagedObjectReference managedObjectReference, List<EventAlarmExpression> list, boolean bl) throws Exception {
        EventManager eventManager = this.getEventManager(managedObjectReference.getServerGuid());
        Map<String, EventDescription.EventDetail> map = this.getEventDescriptions(eventManager);
        Set<String> set = this.getSupportedEvents(string, managedObjectReference);
        HashSet<String> hashSet = new HashSet<String>();
        for (EventAlarmExpression object : list) {
            String string2 = this.getEventTypeId(object);
            if (StringUtil.isNullOrEmpty((String)string2)) continue;
            set.add(string2);
            hashSet.add(string2);
        }
        ArrayList arrayList = new ArrayList();
        for (String string2 : set) {
            if (!this.isOperativeTrigger(string2)) continue;
            EventDescription.EventDetail eventDetail = map.get(string2);
            String string3 = null;
            if (eventDetail != null) {
                string3 = eventDetail.description;
            }
            EventAlarmDetails eventAlarmDetails = new EventAlarmDetails();
            eventAlarmDetails.eventTypeId = string2;
            eventAlarmDetails.description = string3;
            eventAlarmDetails.isCustomEvent = this.isCustomEvent(eventDetail);
            if (bl || hashSet.contains(string2)) {
                eventAlarmDetails.eventArguments = eventManager.retrieveArgumentDescription(string2);
            }
            arrayList.add(eventAlarmDetails);
        }
        return arrayList.toArray(new EventAlarmDetails[arrayList.size()]);
    }

    private PerformanceManager.CounterInfo[] getCounterInfo(List<MetricAlarmExpression> list, String string, String[] stringArray) throws Exception {
        PerformanceManager.CounterInfo[] counterInfoArray;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (MetricAlarmExpression object2 : list) {
            hashSet.add(object2.getMetric().getCounterId());
        }
        HashSet hashSet2 = new HashSet();
        if (stringArray != null) {
            hashSet2.addAll(Arrays.asList(stringArray));
        }
        HashSet<PerformanceManager.CounterInfo> hashSet3 = new HashSet<PerformanceManager.CounterInfo>();
        PerformanceManager performanceManager = this.getPerformanceManager(string);
        for (PerformanceManager.CounterInfo counterInfo : counterInfoArray = performanceManager.getPerfCounter()) {
            if (hashSet.contains(counterInfo.key)) {
                hashSet3.add(counterInfo);
                continue;
            }
            String string2 = counterInfo.groupInfo.key + "." + counterInfo.nameInfo.key + "." + counterInfo.rollupType.toString();
            if (!hashSet2.contains(string2 = string2.toLowerCase())) continue;
            hashSet3.add(counterInfo);
        }
        return hashSet3.toArray(new PerformanceManager.CounterInfo[hashSet3.size()]);
    }

    private AlarmDefinitionInfo getAlarmDefinitionInfoForAlarm(ManagedObjectReference managedObjectReference, Object[] objectArray) throws Exception {
        AlarmDefinitionInfo alarmDefinitionInfo = null;
        LinkedList<EventAlarmExpression> linkedList = new LinkedList<EventAlarmExpression>();
        LinkedList<MetricAlarmExpression> linkedList2 = new LinkedList<MetricAlarmExpression>();
        AlarmInfo alarmInfo = this.getAlarmInfo(managedObjectReference);
        AlarmExpression alarmExpression = alarmInfo.expression;
        this.extractAlarmExpressions(alarmExpression, linkedList, linkedList2);
        String string = managedObjectReference.getServerGuid();
        alarmDefinitionInfo = new AlarmDefinitionInfo();
        alarmDefinitionInfo.events = this.processEventAlarmExpressions(string, linkedList);
        alarmDefinitionInfo.counters = this.processMetricAlarmExpressions(string, linkedList2);
        alarmDefinitionInfo.states = this.processServerCollections(string, objectArray);
        alarmDefinitionInfo.migrateActionArgs = this.getMigrateActionMoRefsNames(alarmInfo.action);
        return alarmDefinitionInfo;
    }

    private void extractAlarmExpressions(AlarmExpression alarmExpression, List<EventAlarmExpression> list, List<MetricAlarmExpression> list2) {
        if (alarmExpression instanceof AndAlarmExpression) {
            AndAlarmExpression andAlarmExpression = (AndAlarmExpression)alarmExpression;
            for (AlarmExpression alarmExpression2 : andAlarmExpression.expression) {
                this.extractAlarmExpressions(alarmExpression2, list, list2);
            }
        } else if (alarmExpression instanceof OrAlarmExpression) {
            OrAlarmExpression orAlarmExpression = (OrAlarmExpression)alarmExpression;
            for (AlarmExpression alarmExpression3 : orAlarmExpression.expression) {
                this.extractAlarmExpressions(alarmExpression3, list, list2);
            }
        } else if (alarmExpression instanceof EventAlarmExpression) {
            list.add((EventAlarmExpression)alarmExpression);
        } else if (alarmExpression instanceof MetricAlarmExpression) {
            list2.add((MetricAlarmExpression)alarmExpression);
        }
    }

    private EventAlarmDetails[] processEventAlarmExpressions(String string, List<EventAlarmExpression> list) throws Exception {
        if (list == null || list.isEmpty()) {
            return null;
        }
        EventManager eventManager = this.getEventManager(string);
        Map<String, EventDescription.EventDetail> map = this.getEventDescriptions(eventManager);
        HashMap<String, EventAlarmDetails> hashMap = new HashMap<String, EventAlarmDetails>();
        HashMap<String, Set<String>> hashMap2 = new HashMap<String, Set<String>>();
        for (EventAlarmExpression eventAlarmExpression : list) {
            String string2 = this.getEventTypeId(eventAlarmExpression);
            if (StringUtil.isNullOrEmpty((String)string2)) continue;
            this.cacheEventArguments(hashMap2, string2, eventAlarmExpression);
            if (hashMap.containsKey(string2)) continue;
            String string3 = null;
            EventDescription.EventDetail eventDetail = map.get(string2);
            if (eventDetail != null) {
                string3 = eventDetail.description;
            }
            EventAlarmDetails eventAlarmDetails = new EventAlarmDetails();
            eventAlarmDetails.eventTypeId = string2;
            eventAlarmDetails.description = string3;
            eventAlarmDetails.eventArguments = eventManager.retrieveArgumentDescription(string2);
            hashMap.put(string2, eventAlarmDetails);
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        this.filterEventArguments(hashMap, hashMap2);
        return hashMap.values().toArray(new EventAlarmDetails[hashMap.size()]);
    }

    private PerformanceManager.CounterInfo[] processMetricAlarmExpressions(String string, List<MetricAlarmExpression> list) throws Exception {
        if (list == null || list.isEmpty()) {
            return null;
        }
        PerformanceManager performanceManager = this.getPerformanceManager(string);
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = list.get(i).getMetric().getCounterId();
        }
        PerformanceManager.CounterInfo[] counterInfoArray = performanceManager.queryCounter(nArray);
        return counterInfoArray;
    }

    private ServerCollection[] processServerCollections(String string, Object[] objectArray) throws Exception {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        AlarmManager alarmManager = this.getAlarmManager(string);
        AlarmDescription alarmDescription = alarmManager.getDescription();
        ArrayList<ServerCollection> arrayList = new ArrayList<ServerCollection>();
        for (Object object : objectArray) {
            try {
                String string2 = (String)object;
                Field field = alarmDescription.getClass().getDeclaredField(string2);
                ServerCollection serverCollection = new ServerCollection();
                serverCollection.name = string2;
                serverCollection.states = (ElementDescription[])field.get(alarmDescription);
                arrayList.add(serverCollection);
            }
            catch (Exception exception) {
                _logger.error((Object)"Unable to retrieve AlarmDescription.", (Throwable)exception);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new ServerCollection[arrayList.size()]);
    }

    private PropertyValue[] getMigrateActionMoRefsNames(AlarmAction alarmAction) throws Exception {
        LinkedList<ManagedObjectReference> linkedList = new LinkedList<ManagedObjectReference>();
        this.retrieveMigrateActionMoArguments(alarmAction, linkedList);
        if (linkedList.size() > 0) {
            Object[] objectArray = linkedList.toArray(new ManagedObjectReference[linkedList.size()]);
            PropertyValue[] propertyValueArray = QueryUtil.getProperties((DataService)this._dataService, (Object[])objectArray, (String[])new String[]{"name"});
            return propertyValueArray;
        }
        return new PropertyValue[0];
    }

    private void retrieveMigrateActionMoArguments(AlarmAction alarmAction, List<ManagedObjectReference> list) throws Exception {
        block4: {
            Action action;
            block3: {
                if (!(alarmAction instanceof GroupAlarmAction)) break block3;
                for (AlarmAction alarmAction2 : ((GroupAlarmAction)alarmAction).action) {
                    this.retrieveMigrateActionMoArguments(alarmAction2, list);
                }
                break block4;
            }
            if (!(alarmAction instanceof AlarmTriggeringAction) || !((action = ((AlarmTriggeringAction)alarmAction).action) instanceof MethodAction)) break block4;
            MethodAction methodAction = (MethodAction)action;
            if (MIGRATE_ACTION_NAME.equals(methodAction.name.toString())) {
                for (MethodActionArgument methodActionArgument : methodAction.argument) {
                    if (!(methodActionArgument.value instanceof ManagedObjectReference)) continue;
                    ManagedObjectReference managedObjectReference = (ManagedObjectReference)methodActionArgument.value;
                    list.add(managedObjectReference);
                }
            }
        }
    }

    private EventManager getEventManager(String string) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)string);
        ManagedObjectReference managedObjectReference = vcService.getServiceInstance().getContent().eventManager;
        return (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
    }

    private PerformanceManager getPerformanceManager(String string) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)string);
        ManagedObjectReference managedObjectReference = vcService.getServiceInstance().getContent().perfManager;
        return (PerformanceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
    }

    private AlarmManager getAlarmManager(String string) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)string);
        ManagedObjectReference managedObjectReference = vcService.getServiceInstance().getContent().alarmManager;
        return (AlarmManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
    }

    private String getEventTypeId(EventDescription.EventDetail eventDetail) {
        String string = null;
        String string2 = this.extractName(eventDetail.getKey());
        if (ExtendedEvent.class.getName().equals(string2) || EventEx.class.getName().equals(string2)) {
            if (!StringUtil.isNullOrEmpty((String)eventDetail.fullFormat)) {
                int n = eventDetail.fullFormat.indexOf("|");
                string = n != -1 ? eventDetail.fullFormat.substring(0, n) : eventDetail.fullFormat;
            }
        } else {
            string = string2.replace(BINDING_PACKAGE, "");
        }
        return string;
    }

    private boolean isCustomEvent(EventDescription.EventDetail eventDetail) {
        if (eventDetail == null) {
            return true;
        }
        String string = this.extractName(eventDetail.getKey());
        return EventEx.class.getName().equals(string);
    }

    private String getEventTypeId(EventAlarmExpression eventAlarmExpression) {
        String string = eventAlarmExpression.getEventTypeId();
        if (string == null || string.isEmpty()) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)"Returned eventTypeId is null, try determine elementDescription from deprecated eventType property");
            }
            String string2 = this.extractName(eventAlarmExpression.eventType);
            string = string2.replace(BINDING_PACKAGE, "");
        }
        return string;
    }

    private String extractName(TypeName typeName) {
        if (typeName == null) {
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)"Null TypeName");
            }
            return "";
        }
        String string = typeName.getName();
        if (!StringUtil.isNullOrEmpty((String)string)) {
            return string;
        }
        if (_logger.isWarnEnabled()) {
            _logger.warn((Object)("TypeName#getName() returned null for type " + typeName));
        }
        if (typeName instanceof TypeNameImpl) {
            string = ((TypeNameImpl)typeName).getWsdlName();
        }
        return StringUtil.isNullOrEmpty((String)string) ? "" : string;
    }

    private Map<String, EventDescription.EventDetail> getEventDescriptions(EventManager eventManager) {
        EventDescription.EventDetail[] eventDetailArray = eventManager.getDescription().eventInfo;
        HashMap<String, EventDescription.EventDetail> hashMap = new HashMap<String, EventDescription.EventDetail>();
        for (EventDescription.EventDetail eventDetail : eventDetailArray) {
            String string = this.getEventTypeId(eventDetail);
            if (StringUtil.isNullOrEmpty((String)string) || !this.isOperativeTrigger(string)) continue;
            hashMap.put(string, eventDetail);
        }
        return hashMap;
    }

    private Set<String> getSupportedEvents(String string, ManagedObjectReference managedObjectReference) {
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = "EventClassification";
        propertyConstraint.propertyName = "objectType";
        propertyConstraint.comparator = Comparator.EQUALS;
        propertyConstraint.comparableValue = string;
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.parameter = managedObjectReference;
        parameterSpec.propertyName = "eventsByObjectType";
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{"eventsByObjectType"};
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = propertyConstraint;
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        Set<String> set = this.processEventClassificationResults(response.resultSet);
        return set;
    }

    private Set<String> processEventClassificationResults(ResultSet[] resultSetArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])resultSetArray)) {
            _logger.error((Object)"Empty result for EventClassification.eventsByObjectType");
            return new HashSet<String>();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ResultSet resultSet : resultSetArray) {
            if (ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
                _logger.warn((Object)"Empty ResultSet.items");
                continue;
            }
            for (ResultItem resultItem : resultSet.items) {
                Object[] objectArray = resultItem.properties;
                if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) continue;
                for (Object object : objectArray) {
                    Set set = (Set)((PropertyValue)object).value;
                    if (set == null) continue;
                    for (String string : set) {
                        string = string.replace(BINDING_PACKAGE, "");
                        hashSet.add(string);
                    }
                }
            }
        }
        return hashSet;
    }

    private void cacheEventArguments(Map<String, Set<String>> map, String string, EventAlarmExpression eventAlarmExpression) {
        if (!map.containsKey(string)) {
            map.put(string, new HashSet());
        }
        if (eventAlarmExpression.comparisons == null || eventAlarmExpression.comparisons.length == 0) {
            return;
        }
        Set<String> set = map.get(string);
        for (EventAlarmExpression.Comparison comparison : eventAlarmExpression.comparisons) {
            set.add(comparison.attributeName);
        }
    }

    private void filterEventArguments(Map<String, EventAlarmDetails> map, Map<String, Set<String>> map2) {
        for (Map.Entry<String, EventAlarmDetails> entry : map.entrySet()) {
            String string = entry.getKey();
            Set<String> set = map2.get(string);
            if (set.isEmpty()) {
                entry.getValue().eventArguments = null;
                continue;
            }
            ArrayList<EventDescription.EventArgDesc> arrayList = new ArrayList<EventDescription.EventArgDesc>();
            EventDescription.EventArgDesc[] eventArgDescArray = entry.getValue().eventArguments;
            if (eventArgDescArray != null) {
                for (EventDescription.EventArgDesc eventArgDesc : eventArgDescArray) {
                    if (!set.contains(eventArgDesc.name)) continue;
                    arrayList.add(eventArgDesc);
                }
            }
            entry.getValue().eventArguments = arrayList.toArray(new EventDescription.EventArgDesc[arrayList.size()]);
        }
    }

    private AlarmInfo getAlarmInfo(ManagedObjectReference managedObjectReference) throws Exception {
        Object object = QueryUtil.getProperty((DataService)this._dataService, (Object)managedObjectReference, (String)"info");
        if (object == null) {
            return null;
        }
        if (object instanceof AlarmInfo) {
            AlarmInfo alarmInfo = (AlarmInfo)object;
            return alarmInfo;
        }
        throw MixedUtil.getInvalidEntityFault();
    }

    private boolean isOperativeTrigger(String string) {
        for (String string2 : INOPERATIVE_TRIGGERS) {
            if (!string2.equals(string)) continue;
            return false;
        }
        return true;
    }
}

