/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.TriggeredAlarmDetails;
import com.vmware.opsmgmt.client.alarms.util.AlarmUtil;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AlarmIssueAbsoluteDataValueProviderBase {
    private static final AtomicLong ISSUES_QUERY_COUNTER = new AtomicLong(0L);
    private static final String ISSUES_QUERY_NAME_PREFIX = "issue-query-";
    private static final String _TOTAL_COUNT_PREFIX_METADATA_KEY = "totalCount_";
    private static final List<QuerySpec> _NO_QUERY_SPECS = new ArrayList<QuerySpec>(0);
    private static final PartialUpdate<AlarmState> _NO_UPDATES = PartialUpdate.empty();
    private final DataService _dataService;
    private final QuerySpecBuilder _querySpecBuilder;

    protected AlarmIssueAbsoluteDataValueProviderBase(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        this._dataService = dataService;
        this._querySpecBuilder = querySpecBuilder;
    }

    protected PartialUpdate<AlarmState> getValues() {
        List<QuerySpec> list = this.getAlarmIssuesQuerySpecs();
        if (list.isEmpty()) {
            return _NO_UPDATES;
        }
        Object[] objectArray = this.executeQuery(list);
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return _NO_UPDATES;
        }
        PartialUpdate<AlarmState> partialUpdate = this.processQueryResults(list, (ResultSet[])objectArray);
        partialUpdate.setDestination("/topic/alarms");
        return partialUpdate;
    }

    private List<QuerySpec> getAlarmIssuesQuerySpecs() {
        List<ManagedObjectReference> list = this.getQueryObjects();
        if (list.isEmpty()) {
            return _NO_QUERY_SPECS;
        }
        ArrayList<QuerySpec> arrayList = new ArrayList<QuerySpec>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ManagedObjectReference managedObjectReference = list.get(i);
            PropertyConstraint propertyConstraint = new PropertyConstraint();
            propertyConstraint.targetType = "AlarmIssue";
            propertyConstraint.propertyName = "info.entity";
            propertyConstraint.comparator = Comparator.EQUALS;
            propertyConstraint.comparableValue = managedObjectReference;
            QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec((Constraint)propertyConstraint, new String[]{"info"});
            querySpec.resultSpec = new ResultSpec();
            querySpec.resultSpec.maxResultCount = 150;
            querySpec.name = String.format("%s:%s:%s%s", managedObjectReference.getValue(), managedObjectReference.getServerGuid(), ISSUES_QUERY_NAME_PREFIX, ISSUES_QUERY_COUNTER.incrementAndGet());
            arrayList.add(querySpec);
        }
        return arrayList;
    }

    protected abstract List<ManagedObjectReference> getQueryObjects();

    private ResultSet[] executeQuery(List<QuerySpec> list) {
        ResultSet[] resultSetArray = null;
        try {
            RequestSpec requestSpec = new RequestSpec();
            requestSpec.querySpec = (QuerySpec[])ArrayUtil.toArray(list, QuerySpec.class);
            Response response = this._dataService.getData(requestSpec);
            resultSetArray = response.resultSet;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return resultSetArray;
    }

    private PartialUpdate<AlarmState> processQueryResults(List<QuerySpec> list, ResultSet[] resultSetArray) {
        PartialUpdate partialUpdate = PartialUpdate.empty();
        for (int i = 0; i < resultSetArray.length; ++i) {
            PartialUpdate<AlarmState> partialUpdate2 = this.processResultSet(list.get(i), resultSetArray[i]);
            partialUpdate.updates.addAll(partialUpdate2.updates);
            partialUpdate.deleted.addAll(partialUpdate2.deleted);
            partialUpdate.metadata.putAll(partialUpdate2.metadata);
        }
        partialUpdate.isDelta = false;
        return partialUpdate;
    }

    private PartialUpdate<AlarmState> processResultSet(QuerySpec querySpec, ResultSet resultSet) {
        PartialUpdate partialUpdate = PartialUpdate.empty();
        ManagedObjectReference managedObjectReference = AlarmIssueAbsoluteDataValueProviderBase.findQueryObject(querySpec);
        for (ResultItem resultItem : resultSet.items) {
            for (PropertyValue propertyValue : resultItem.properties) {
                IssueInfo issueInfo = (IssueInfo)propertyValue.value;
                if (!(issueInfo.details instanceof TriggeredAlarmDetails)) continue;
                TriggeredAlarmDetails triggeredAlarmDetails = (TriggeredAlarmDetails)issueInfo.details;
                ManagedObjectReference managedObjectReference2 = triggeredAlarmDetails.alarmState.entity;
                PartialUpdateItem partialUpdateItem = PartialUpdateItem.of((Object)triggeredAlarmDetails.alarmState, (Object)managedObjectReference2);
                AlarmUtil.assignMetadata(partialUpdateItem, triggeredAlarmDetails.alarmState.key, triggeredAlarmDetails.alarmInfo);
                AlarmUtil.assignMetadata(partialUpdateItem, "alarmInfoName", issueInfo.entityName);
                AlarmUtil.assignMetadata(partialUpdateItem, "showVAMILink", triggeredAlarmDetails.showVAMILink);
                AlarmUtil.assignMetadata(partialUpdateItem, "issueUri", DefaultUriSchemeUtil.createUri((String)"AlarmIssue", (String)triggeredAlarmDetails.alarmState.key));
                AlarmUtil.assignMetadata(partialUpdateItem, "issueInfo", issueInfo);
                partialUpdate.updates.add(partialUpdateItem);
            }
        }
        partialUpdate.deleted.add(ManagedObjectUtil.getRootFolder((String)managedObjectReference.getServerGuid()));
        partialUpdate.metadata.put(_TOTAL_COUNT_PREFIX_METADATA_KEY + managedObjectReference.getServerGuid(), resultSet.totalMatchedObjectCount);
        return partialUpdate;
    }

    protected static LinkedVcGroup[] getStartupLinkedVcGroup() {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup[] linkedVcGroupArray = linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups();
        return linkedVcGroupArray;
    }

    private static ManagedObjectReference findQueryObject(QuerySpec querySpec) {
        PropertyConstraint propertyConstraint = (PropertyConstraint)querySpec.resourceSpec.constraint;
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)propertyConstraint.comparableValue;
        return managedObjectReference;
    }
}

