/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class AlarmStateComparator
implements Comparator<AlarmState> {
    private static final int NOT_NULL = -2;
    private static final Map<ManagedEntity.Status, Integer> _statusMap = new HashMap<ManagedEntity.Status, Integer>();

    @Override
    public int compare(AlarmState alarmState, AlarmState alarmState2) {
        int n = this.compareNulls(alarmState, alarmState2);
        if (n != -2) {
            return n;
        }
        n = this.compareAcknowledged(alarmState, alarmState2);
        if (n != 0) {
            return n;
        }
        n = this.compareStatus(alarmState, alarmState2);
        if (n != 0) {
            return n;
        }
        n = this.compareTime(alarmState, alarmState2);
        return n;
    }

    private int compareNulls(Object object, Object object2) {
        if (object == null) {
            if (object2 == null) {
                return 0;
            }
            return 1;
        }
        if (object2 == null) {
            return -1;
        }
        return -2;
    }

    private int compareAcknowledged(AlarmState alarmState, AlarmState alarmState2) {
        Boolean bl = alarmState.acknowledged != null ? alarmState.acknowledged : false;
        Boolean bl2 = alarmState2.acknowledged != null ? alarmState2.acknowledged : false;
        return bl.compareTo(bl2);
    }

    private int compareStatus(AlarmState alarmState, AlarmState alarmState2) {
        ManagedEntity.Status status = alarmState.overallStatus != null ? alarmState.overallStatus : ManagedEntity.Status.gray;
        ManagedEntity.Status status2 = alarmState2.overallStatus != null ? alarmState2.overallStatus : ManagedEntity.Status.gray;
        Integer n = _statusMap.get(status);
        Integer n2 = _statusMap.get(status2);
        return n.compareTo(n2);
    }

    private int compareTime(AlarmState alarmState, AlarmState alarmState2) {
        Calendar calendar;
        Calendar calendar2;
        if (alarmState.time != null) {
            calendar2 = alarmState.time;
        } else {
            calendar2 = Calendar.getInstance();
            calendar2.clear();
        }
        if (alarmState2.time != null) {
            calendar = alarmState2.time;
        } else {
            calendar = Calendar.getInstance();
            calendar.clear();
        }
        return calendar2.compareTo(calendar) * -1;
    }

    static {
        _statusMap.put(ManagedEntity.Status.gray, 3);
        _statusMap.put(ManagedEntity.Status.green, 2);
        _statusMap.put(ManagedEntity.Status.yellow, 1);
        _statusMap.put(ManagedEntity.Status.red, 0);
    }
}

