/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.opsmgmt.client.alarms.util.AlarmStateComparator;
import com.vmware.opsmgmt.client.alarms.util.AlarmStateFilter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmStateRetriever {
    private static final Log _logger = LogFactory.getLog(AlarmStateRetriever.class);
    private static final String _TRIGGERED_ALARMS_PROPERTY = "triggeredAlarmState";
    private static final String _TRIGGERED_ALARMS_LENGTH_PROPERTY = "triggeredAlarmState._length";
    private static final String _TOP_TRIGGERED_UNACKNOWLEDGED_ALARMS_PROPERTY = "topTriggeredAndUnacknowledgedAlarmState";
    private static final String _TOP_TRIGGERED_ACKNOWLEDGED_ALARMS_PROPERTY = "topTriggeredAndAcknowledgedAlarmState";
    private final AlarmStateComparator _alarmStateComparator;
    private final AlarmStateFilter _alarmStateFilter;
    private final DataService _dataService;
    private final QuerySpecBuilder _querySpecBuilder;

    public AlarmStateRetriever(DataService dataService, QuerySpecBuilder querySpecBuilder) {
        this._dataService = dataService;
        this._querySpecBuilder = querySpecBuilder;
        this._alarmStateComparator = new AlarmStateComparator();
        this._alarmStateFilter = new AlarmStateFilter();
    }

    public Result retrieve(boolean bl, List<Object> list, String string, Integer n, Integer n2) {
        Response response = this.queryData(list, n);
        if (response == null) {
            _logger.error((Object)"Error retrieving triggered alarms: null response");
            return new Result(null, 0);
        }
        if (ArrayUtil.isNullOrEmpty((Object[])response.resultSet)) {
            return new Result(null, 0);
        }
        ExtractVcAlarmsResult extractVcAlarmsResult = AlarmStateRetriever.extractVcAlarms(response.resultSet);
        int n3 = 0;
        int n4 = n != null ? n : -1;
        n2 = n2 != null ? n2 : -1;
        for (int i = 0; i < extractVcAlarmsResult.alarmsPerVc.size(); ++i) {
            int n5;
            List<AlarmState> list2 = extractVcAlarmsResult.alarmsPerVc.get(i);
            int n6 = list2.size();
            boolean bl2 = n6 == (n5 = extractVcAlarmsResult.totalCountPerVc.get(i).intValue());
            n3 = (list2 = this.filterAlarms(list2, string)) != null && bl2 ? (n3 += list2.size()) : (n3 += n5);
            list2 = this.sortAndLimitAlarms(list2, bl, n4, n2);
            extractVcAlarmsResult.alarmsPerVc.set(i, list2);
        }
        List<AlarmState> list3 = this.mergeAlarms(extractVcAlarmsResult.alarmsPerVc);
        list3 = this.sortAndLimitAlarms(list3, bl, n4, n2);
        return new Result(list3.toArray(new AlarmState[list3.size()]), n3);
    }

    public Response queryData(List<Object> list, Integer n) {
        List<QuerySpec> list2 = null;
        list2 = AlarmStateRetriever.isMaxResultCountOptimizable(n) ? this.getOptimizedQuerySpec(list, n) : this.getUnoptimizedQuerySpec(list, n);
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = (QuerySpec[])ArrayUtil.toArray(list2, QuerySpec.class);
        Response response = this._dataService.getData(requestSpec);
        return response;
    }

    private static ExtractVcAlarmsResult extractVcAlarms(ResultSet[] resultSetArray) {
        ArrayList<List<AlarmState>> arrayList = new ArrayList<List<AlarmState>>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (ResultSet resultSet : resultSetArray) {
            if (resultSet == null) continue;
            ResultItem[] resultItemArray = resultSet.items;
            if (ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) continue;
            for (ResultItem resultItem : resultItemArray) {
                Object[] objectArray = resultItem.properties;
                if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) continue;
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                int n = -1;
                for (Object object : objectArray) {
                    int n2;
                    Object[] objectArray2;
                    if (object == null) continue;
                    if ((_TRIGGERED_ALARMS_PROPERTY.equals(((PropertyValue)object).propertyName) || _TOP_TRIGGERED_UNACKNOWLEDGED_ALARMS_PROPERTY.equals(((PropertyValue)object).propertyName) || _TOP_TRIGGERED_ACKNOWLEDGED_ALARMS_PROPERTY.equals(((PropertyValue)object).propertyName)) && !ArrayUtil.isNullOrEmpty((Object[])(objectArray2 = (AlarmState[])((PropertyValue)object).value))) {
                        arrayList3.addAll(Arrays.asList(objectArray2));
                    }
                    if (!_TRIGGERED_ALARMS_LENGTH_PROPERTY.equals(((PropertyValue)object).propertyName)) continue;
                    n = n2 = ((Integer)((PropertyValue)object).value).intValue();
                }
                arrayList.add(arrayList3);
                arrayList2.add(n < 0 ? arrayList3.size() : n);
            }
        }
        return new ExtractVcAlarmsResult(arrayList, arrayList2);
    }

    private List<AlarmState> filterAlarms(List<AlarmState> list, String string) {
        return this._alarmStateFilter.filterByIssueType(list, string);
    }

    private List<AlarmState> sortAndLimitAlarms(List<AlarmState> list, boolean bl, int n, int n2) {
        if (bl) {
            Collections.sort(list, this._alarmStateComparator);
        }
        if (n > 0 && n < list.size()) {
            if (n2 > 0) {
                if (n + n2 > list.size()) {
                    return list.subList(n2, list.size());
                }
                return list.subList(n2, n + n2);
            }
            return list.subList(0, n);
        }
        return list;
    }

    private List<AlarmState> mergeAlarms(List<List<AlarmState>> list) {
        if (list.isEmpty()) {
            return new ArrayList<AlarmState>();
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        int n = 0;
        for (List<AlarmState> object : list) {
            n += object.size();
        }
        ArrayList arrayList = new ArrayList(n);
        for (List<AlarmState> list2 : list) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private static boolean isMaxResultCountOptimizable(Integer n) {
        return n != null && n >= 0 && n <= 150;
    }

    private List<QuerySpec> getUnoptimizedQuerySpec(List<Object> list, Integer n) {
        Object object;
        Object object2;
        Constraint[] constraintArray = new Constraint[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object2 = list.get(i);
            object = new ObjectIdentityConstraint();
            ((ObjectIdentityConstraint)object).target = object2;
            constraintArray[i] = object;
        }
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.nestedConstraints = constraintArray;
        compositeConstraint.conjoiner = Conjoiner.OR;
        object2 = this._querySpecBuilder.buildQuerySpec((Constraint)compositeConstraint, new String[]{_TRIGGERED_ALARMS_PROPERTY});
        ((QuerySpec)object2).resultSpec = new ResultSpec();
        ((QuerySpec)object2).resultSpec.maxResultCount = n;
        object = new ArrayList(1);
        object.add(object2);
        return object;
    }

    private List<QuerySpec> getOptimizedQuerySpec(List<Object> list, Integer n) {
        ObjectIdentityConstraint objectIdentityConstraint;
        Object object;
        ArrayList<ObjectIdentityConstraint> arrayList = new ArrayList<ObjectIdentityConstraint>();
        ArrayList<ObjectIdentityConstraint> arrayList2 = new ArrayList<ObjectIdentityConstraint>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = object;
            if (object instanceof ManagedObjectReference) {
                ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
                if (VcServiceUtil.is65VcOrLaterByServerGuid((String)managedObjectReference.getServerGuid(), (boolean)true) && ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, Folder.class)) {
                    arrayList.add(objectIdentityConstraint);
                    continue;
                }
                arrayList2.add(objectIdentityConstraint);
                continue;
            }
            arrayList2.add(objectIdentityConstraint);
        }
        ArrayList<QuerySpec> arrayList3 = new ArrayList<QuerySpec>(2);
        if (!arrayList2.isEmpty()) {
            object = new CompositeConstraint();
            ((CompositeConstraint)object).nestedConstraints = (Constraint[])ArrayUtil.toArray(arrayList2, Constraint.class);
            ((CompositeConstraint)object).conjoiner = Conjoiner.OR;
            objectIdentityConstraint = this._querySpecBuilder.buildQuerySpec((Constraint)object, new String[]{_TRIGGERED_ALARMS_PROPERTY});
            objectIdentityConstraint.resultSpec = new ResultSpec();
            objectIdentityConstraint.resultSpec.maxResultCount = n;
            arrayList3.add((QuerySpec)objectIdentityConstraint);
        }
        if (!arrayList.isEmpty()) {
            object = new CompositeConstraint();
            ((CompositeConstraint)object).nestedConstraints = (Constraint[])ArrayUtil.toArray(arrayList, Constraint.class);
            ((CompositeConstraint)object).conjoiner = Conjoiner.OR;
            objectIdentityConstraint = this._querySpecBuilder.buildQuerySpec((Constraint)object, new String[]{_TOP_TRIGGERED_UNACKNOWLEDGED_ALARMS_PROPERTY, _TOP_TRIGGERED_ACKNOWLEDGED_ALARMS_PROPERTY, _TRIGGERED_ALARMS_LENGTH_PROPERTY});
            objectIdentityConstraint.resultSpec = new ResultSpec();
            objectIdentityConstraint.resultSpec.maxResultCount = n;
            arrayList3.add((QuerySpec)objectIdentityConstraint);
        }
        return arrayList3;
    }

    public static class Result {
        public AlarmState[] alarms;
        public int totalAlarms;

        public Result() {
        }

        public Result(AlarmState[] alarmStateArray, int n) {
            this.alarms = alarmStateArray;
            this.totalAlarms = n;
        }
    }

    private static class ExtractVcAlarmsResult {
        public List<List<AlarmState>> alarmsPerVc;
        public List<Integer> totalCountPerVc;

        public ExtractVcAlarmsResult(List<List<AlarmState>> list, List<Integer> list2) {
            this.alarmsPerVc = list;
            this.totalCountPerVc = list2;
        }
    }
}

