/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityNameRetriever {
    private static final String NAME_PROPERTY = "name";
    private static final String VC_NAME_PROPERTY = "vCenterName";
    private static final int MAX_QUERY_SIZE = 64;
    private static final Log _logger = LogFactory.getLog(EntityNameRetriever.class);
    private DataService _dataService;

    public EntityNameRetriever(DataService dataService) {
        this._dataService = dataService;
    }

    public Map<ManagedObjectReference, String> retrieve(AlarmState[] alarmStateArray, Map<ManagedObjectReference, AlarmInfo> map) {
        HashSet<ManagedObjectReference> hashSet = new HashSet<ManagedObjectReference>();
        HashSet<ManagedObjectReference> hashSet2 = new HashSet<ManagedObjectReference>();
        this.getAlarmEntities(alarmStateArray, map, hashSet, hashSet2);
        HashMap<ManagedObjectReference, String> hashMap = new HashMap<ManagedObjectReference, String>();
        this.fillEntityNames(hashSet, NAME_PROPERTY, hashMap);
        this.fillEntityNames(hashSet2, VC_NAME_PROPERTY, hashMap);
        return hashMap;
    }

    private void getAlarmEntities(AlarmState[] alarmStateArray, Map<ManagedObjectReference, AlarmInfo> map, Set<ManagedObjectReference> set, Set<ManagedObjectReference> set2) {
        for (AlarmState alarmState : alarmStateArray) {
            this.addEntityToSet(alarmState.entity, set, set2);
        }
        for (AlarmInfo alarmInfo : map.values()) {
            this.addEntityToSet(alarmInfo.entity, set, set2);
        }
    }

    private void addEntityToSet(ManagedObjectReference managedObjectReference, Set<ManagedObjectReference> set, Set<ManagedObjectReference> set2) {
        if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)managedObjectReference)) {
            set2.add(managedObjectReference);
        } else {
            set.add(managedObjectReference);
        }
    }

    private void fillEntityNames(Set<ManagedObjectReference> set, String string, Map<ManagedObjectReference, String> map) {
        if (set.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = Math.min(64, set.size());
        ManagedObjectReference[] managedObjectReferenceArray = new ManagedObjectReference[n3];
        Iterator<ManagedObjectReference> iterator = set.iterator();
        while (iterator.hasNext()) {
            managedObjectReferenceArray[n] = iterator.next();
            ++n2;
            if (++n != n3) continue;
            this.getEntityNames(string, managedObjectReferenceArray, map);
            n = 0;
            n3 = Math.min(64, set.size() - n2);
            if (n3 == 0 || n3 >= 64) continue;
            managedObjectReferenceArray = new ManagedObjectReference[n3];
        }
    }

    private void getEntityNames(String string, ManagedObjectReference[] managedObjectReferenceArray, Map<ManagedObjectReference, String> map) {
        try {
            PropertyValue[] propertyValueArray;
            for (PropertyValue propertyValue : propertyValueArray = QueryUtil.getProperty((DataService)this._dataService, (Object[])managedObjectReferenceArray, (String)string)) {
                map.put((ManagedObjectReference)propertyValue.resourceObject, (String)propertyValue.value);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error retrieving entity names", (Throwable)exception);
        }
    }
}

