/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.opsmgmt.client.alarms.ServiceAlarmInfo;
import com.vmware.opsmgmt.client.alarms.TriggeredAlarmDetails;
import com.vmware.opsmgmt.client.alarms.util.Util;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.core.model.monitor.IssueStatus;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IssueInfoBuilder {
    private static final Log _logger = LogFactory.getLog(IssueInfoBuilder.class);
    private static final String ISSUE_INFO_BUILDER_SYNC_OBJECT_KEY = "com.vmware.opsmgmt.client.alarms.util.IssueInfoBuilder";
    private static final String DB_HEALTH_ALARM_SYSTEM_NAME = "alarm.DBHealthAlarm";
    private static final String SERVER_GUID_TO_OS_TYPE_MAP = "serverGuidToOsTypeMap";
    private static final String OS_TYPE_LINUX = "linux";

    public IssueInfo build(AlarmState alarmState, Map<ManagedObjectReference, AlarmInfo> map, Map<ManagedObjectReference, String> map2, Map<ManagedObjectReference, String> map3, Map<ManagedObjectReference, String> map4) {
        boolean bl;
        boolean bl2;
        boolean bl3 = map3 != null ? !map3.isEmpty() : (bl2 = false);
        boolean bl4 = map4 != null ? !map4.isEmpty() : (bl = false);
        if (!map.containsKey(alarmState.alarm)) {
            _logger.warn((Object)("AlarmInfo is not available for the following alarm: " + alarmState.key));
            return null;
        }
        IssueInfo issueInfo = new IssueInfo();
        issueInfo.typeDisplayName = Util.getLocalizedString("alarmIssue.displayName");
        issueInfo.timestamp = alarmState.time.getTime();
        issueInfo.entity = alarmState.entity;
        issueInfo.entityName = map2.get(alarmState.entity);
        issueInfo.description = this.getAlarmDescription(alarmState.alarm, map);
        issueInfo.status = this.convertAlarmStatus(alarmState.overallStatus);
        TriggeredAlarmDetails triggeredAlarmDetails = new TriggeredAlarmDetails();
        triggeredAlarmDetails.alarmState = alarmState;
        triggeredAlarmDetails.alarmInfo = map.get(alarmState.alarm);
        triggeredAlarmDetails.definedInEntityName = map2.get(triggeredAlarmDetails.alarmInfo.entity);
        if (bl2) {
            triggeredAlarmDetails.entityIconId = map3.get(alarmState.entity);
        }
        if (bl) {
            triggeredAlarmDetails.entityLablesIds = map4.get(alarmState.entity);
        }
        triggeredAlarmDetails.showVAMILink = this.isDBHealthAlarm(triggeredAlarmDetails.alarmInfo) && this.vcIsVCSA(alarmState.entity.getServerGuid());
        issueInfo.details = triggeredAlarmDetails;
        return issueInfo;
    }

    public IssueInfo build(AlarmState alarmState, Map<ManagedObjectReference, AlarmInfo> map, Map<ManagedObjectReference, String> map2, Map<ManagedObjectReference, String> map3, Map<ManagedObjectReference, String> map4, ServiceAlarmInfo serviceAlarmInfo) {
        IssueInfo issueInfo = this.build(alarmState, map, map2, map3, map4);
        if (issueInfo != null) {
            issueInfo.service = serviceAlarmInfo;
        }
        return issueInfo;
    }

    private IssueStatus convertAlarmStatus(ManagedEntity.Status status) {
        switch (status) {
            case yellow: {
                return IssueStatus.WARNING;
            }
            case red: {
                return IssueStatus.ERROR;
            }
            case green: {
                return IssueStatus.INFO;
            }
            case gray: {
                return IssueStatus.INFO;
            }
        }
        return IssueStatus.INFO;
    }

    private String getAlarmDescription(ManagedObjectReference managedObjectReference, Map<ManagedObjectReference, AlarmInfo> map) {
        AlarmInfo alarmInfo = map.get(managedObjectReference);
        if (alarmInfo != null) {
            return alarmInfo.name;
        }
        _logger.warn((Object)String.format("Could not retrieve alarm definition for a triggered alarm - %s", managedObjectReference.toString()));
        return "";
    }

    private boolean isDBHealthAlarm(AlarmInfo alarmInfo) {
        return !StringUtil.isNullOrEmpty((String)alarmInfo.systemName) && alarmInfo.systemName.equals(DB_HEALTH_ALARM_SYSTEM_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean vcIsVCSA(String string) {
        boolean bl = false;
        VcService vcService = VimSessionUtil.getService((String)string);
        if (vcService == null) {
            return bl;
        }
        HttpSession httpSession = SessionUtil.getHttpSession();
        if (httpSession == null) {
            return bl;
        }
        Object object = SessionUtil.getSyncObject((String)ISSUE_INFO_BUILDER_SYNC_OBJECT_KEY, (HttpSession)httpSession);
        HashMap<String, Boolean> hashMap = null;
        Object object2 = object;
        synchronized (object2) {
            hashMap = (HashMap<String, Boolean>)SessionUtil.getData((String)SERVER_GUID_TO_OS_TYPE_MAP);
            if (hashMap == null) {
                hashMap = new HashMap<String, Boolean>();
                SessionUtil.setData((String)SERVER_GUID_TO_OS_TYPE_MAP, hashMap);
            }
            if (hashMap.containsKey(string)) {
                return (Boolean)hashMap.get(string);
            }
            if (VcServiceUtil.isVc61OrLater((String)string)) {
                try {
                    AboutInfo aboutInfo = vcService.getServiceInstanceContent().about;
                    bl = !StringUtil.isNullOrEmpty((String)aboutInfo.osType) && aboutInfo.osType.contains(OS_TYPE_LINUX);
                }
                catch (Exception exception) {
                    _logger.error((Object)"Failed to retrieve service about info.", (Throwable)exception);
                }
            }
            hashMap.put(string, bl);
        }
        return bl;
    }
}

