/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authorization.impl;

import com.google.common.collect.Sets;
import com.vmware.cis.authorization.PrincipalLifecycleManager;
import com.vmware.cis.authorization.VcAuthorizationManager;
import com.vmware.cis.authorization.client.DocHierarchyPlugin;
import com.vmware.cis.authorization.impl.DataProvider;
import com.vmware.cis.authorization.impl.InvalidationCallbackImpl;
import com.vmware.cis.authorization.impl.UserData;
import com.vmware.cis.core.AuthFilterInfo;
import com.vmware.cis.core.Permission;
import com.vmware.cis.core.Principal;
import com.vmware.cis.core.RoleData;
import com.vmware.cis.core.exception.AuthorizationException;
import com.vmware.cis.core.util.AclConstants;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationManagerImpl
implements VcAuthorizationManager,
PrincipalLifecycleManager {
    private static final Log _log = LogFactory.getLog(AuthorizationManagerImpl.class);
    private static final int DEFAULT_MAX_USAGE = 60;
    private ConcurrentHashMap<Principal, UserData> _users;
    private DataProvider _prov;
    private boolean _usedByClient = false;
    private String _globalDocId = AclConstants.GLOBAL_PERMISSIONS_DOC_ENCODED;
    private int _maxUsagePerPrincipal = 60;
    private DocHierarchyPlugin _hierarchyPlugin = null;

    public AuthorizationManagerImpl() throws AuthorizationException {
        this._users = new ConcurrentHashMap();
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Created new AuthorizeMgr instance");
        }
    }

    public void setDataProvider(DataProvider provider) {
        this._prov = provider;
        this._prov.setInvalidationCallback(new InvalidationCallbackImpl(this));
    }

    public void setUsedByClient(boolean usedByClient) {
        this._usedByClient = usedByClient;
        this._globalDocId = this._usedByClient ? "urn:acl:global:permissions" : AclConstants.GLOBAL_PERMISSIONS_DOC_ENCODED;
    }

    public void setMaxUsagePerPrincipal(int count) {
        this._maxUsagePerPrincipal = count;
    }

    public void init() throws AuthorizationException {
    }

    public void invalidateAll() {
        for (Principal p : this._users.keySet()) {
            UserData data = this._users.get(p);
            if (data == null || data.isInvalid()) continue;
            data.setInvalid(true);
            if (!_log.isTraceEnabled()) continue;
            _log.trace((Object)("Invalidating permission cache for principal:" + p.getName()));
        }
    }

    public void invalidate(String objectId) {
    }

    @Override
    public boolean isAllowed(Principal principal, String objectId, String priv) throws AuthorizationException {
        return this.isAllowed(principal, objectId, Collections.singletonList(priv));
    }

    @Override
    public boolean isAllowed(Principal principal, String objectId, Collection<String> privs) throws AuthorizationException {
        return this.isAllowed(principal, objectId, privs, false);
    }

    @Override
    public boolean isAllowed(Principal principal, String objectId, Collection<String> privs, boolean propagationOnly) throws AuthorizationException {
        UserData data = this._users.get(principal);
        if (data == null) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)"No user data: authorization denied. Did you invoke notifyAdd to trigger UserData creation?");
            }
            return false;
        }
        if (data.isFullAccess()) {
            return true;
        }
        if (data.isInvalid()) {
            data = this.resetUserData(principal, data.isFullAccess());
        }
        final HashSet<String> privilegeSet = new HashSet<String>(privs);
        privilegeSet.remove("System.Anonymous");
        this.processPermissions(data.getPrincipal(), objectId, new ProcessPrivilegesFunctions(){

            @Override
            public boolean isDone() {
                return privilegeSet.isEmpty();
            }

            @Override
            public void processPrivileges(Set<String> privileges) {
                privilegeSet.removeAll(privileges);
            }
        }, propagationOnly);
        return privilegeSet.isEmpty();
    }

    @Override
    public Set<String> getUserPrivileges(Principal principal, String objectId) throws AuthorizationException {
        return this.getUserPrivileges(principal, objectId, false);
    }

    @Override
    public Set<String> getUserPrivileges(Principal principal, String objectId, boolean propagationOnly) throws AuthorizationException {
        final HashSet<String> result = new HashSet<String>();
        this.processPermissions(principal, objectId, new ProcessPrivilegesFunctions(){

            @Override
            public void processPrivileges(Set<String> privileges) {
                result.addAll(privileges);
            }

            @Override
            public boolean isDone() {
                return false;
            }
        }, propagationOnly);
        return result;
    }

    public String getPrivFromSysViewCache(Principal principal, String objectId) {
        return null;
    }

    @Override
    public boolean isAllowedOnVcRoot(Principal principal, String privilege) throws AuthorizationException {
        return this.isAllowedOnVcRoot(principal, Collections.singletonList(privilege));
    }

    @Override
    public boolean isAllowedOnVcRoot(Principal principal, Collection<String> privileges) throws AuthorizationException {
        String vcRoot = this.getVcRoot();
        if (vcRoot == null) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)"VC Root object not found - unable to check privilege on root");
            }
            return false;
        }
        return this.isAllowedOnAny(principal, privileges, Collections.singleton(vcRoot));
    }

    private boolean isAllowedOnAny(Principal principal, Collection<String> privileges, Collection<String> objects) throws AuthorizationException {
        for (String objId : objects) {
            if (objId == null || !this.isAllowed(principal, objId, privileges)) continue;
            return true;
        }
        return false;
    }

    private <T> void processPermissions(Principal principal, String objectId, ProcessPrivilegesFunctions functions, boolean propagationOnly) throws AuthorizationException {
        String owningObjectId = this.getOwningObjectId(objectId);
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("process permission for object: " + objectId + " and principal: " + principal.getName()));
        }
        AuthFilterInfo authInfo = this._prov.getAuthInfo(owningObjectId);
        if (this.processDirectAssignment(principal, owningObjectId, propagationOnly, functions)) {
            return;
        }
        this.processParentChain(owningObjectId, authInfo, principal, false, functions);
        if (functions.isDone()) {
            return;
        }
        this.processParentChain(owningObjectId, authInfo, principal, true, functions);
        if (functions.isDone()) {
            return;
        }
        this.processImpliedSystemViewPrivilege(owningObjectId, principal, functions);
    }

    @Override
    public boolean isLoginAllowed(Principal principal) throws AuthorizationException {
        return this.isAllowedOnAny(principal, Collections.singleton("System.View"), this.getAllRootObjectIds());
    }

    private <T> void processImpliedSystemViewPrivilege(String objectId, Principal principal, ProcessPrivilegesFunctions functions) throws AuthorizationException {
        HashSet<String> sysviewPrivs = new HashSet<String>();
        if (this._prov.hasImpliedSysViewPrivilege(objectId, principal)) {
            sysviewPrivs.add("System.View");
            functions.processPrivileges(sysviewPrivs);
        }
    }

    private <T> void processParentChain(String objectId, AuthFilterInfo authInfo, Principal principal, boolean altParent, ProcessPrivilegesFunctions functions) throws AuthorizationException {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("Process parent chain for object " + objectId));
        }
        boolean delayProcessGlobalPermission = authInfo != null ? !altParent && authInfo.getAltParentId() != null : false;
        HashSet<String> visited = new HashSet<String>();
        visited.add(objectId);
        while (objectId != null) {
            String parent;
            String string = authInfo != null ? (altParent ? authInfo.getAltParentId() : authInfo.getParentId()) : (parent = null);
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("Object " + objectId + " has parent " + parent));
            }
            if (parent == null && this._hierarchyPlugin != null) {
                parent = this.getParentFromPlugin(objectId, altParent);
            }
            if (parent != null) {
                if (parent.equals(this._globalDocId) && delayProcessGlobalPermission) {
                    return;
                }
                parent = this.getOwningObjectId(parent);
            } else if (!altParent && !objectId.equals(this._globalDocId)) {
                parent = this._globalDocId;
            } else {
                return;
            }
            if (visited.contains(parent)) {
                if (_log.isTraceEnabled()) {
                    _log.trace((Object)("Object " + objectId + " parent chain is cyclic " + visited));
                }
                return;
            }
            if (this.processDirectAssignment(principal, parent, true, functions)) {
                return;
            }
            visited.add(parent);
            authInfo = this._prov.getAuthInfo(parent);
            objectId = parent;
            altParent = false;
        }
    }

    private String getOwningObjectId(String objectId) {
        try {
            String owningObjectId = this._prov.getAuthObject(objectId);
            if (owningObjectId == null) {
                URI owningObject;
                if (this._hierarchyPlugin != null && (owningObject = this._hierarchyPlugin.getOwningDoc(new URI(objectId))) != null) {
                    owningObjectId = owningObject.toString();
                }
                if (owningObjectId == null) {
                    owningObjectId = objectId;
                }
            }
            return owningObjectId;
        }
        catch (Exception e) {
            return objectId;
        }
    }

    private String getParentFromPlugin(String objectId, boolean altParent) {
        if (this._hierarchyPlugin == null || objectId == null) {
            return null;
        }
        URI parent = null;
        try {
            URI objectIdUri = new URI(objectId);
            parent = altParent ? this._hierarchyPlugin.getAlternativeParentDoc(objectIdUri) : this._hierarchyPlugin.getParentDoc(objectIdUri);
        }
        catch (Exception e) {
            parent = null;
        }
        if (parent != null) {
            return parent.toString();
        }
        return null;
    }

    private <T> boolean processDirectAssignment(Principal userPrincipal, String objectId, boolean onlyCheckPropogating, ProcessPrivilegesFunctions functions) throws AuthorizationException {
        Set<Long> roles;
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("processDirectAsssignment for user " + userPrincipal.getName() + " on object id " + objectId));
        }
        if ((roles = this.getMatchingRoles(objectId, userPrincipal, onlyCheckPropogating)).isEmpty()) {
            _log.trace((Object)"processDirectAsssignment: returns false because roles empty");
            return false;
        }
        ArrayList<RoleData> roleDataList = new ArrayList<RoleData>();
        for (Long roleId : roles) {
            RoleData roleData = this._prov.getRoles().get(roleId);
            if (roleData == null) {
                if (!_log.isTraceEnabled()) continue;
                _log.trace((Object)("Role with ID " + roleId + " does not exist"));
                continue;
            }
            roleDataList.add(roleData);
        }
        if (roleDataList.isEmpty()) {
            _log.trace((Object)"processDirectAsssignment: returns false because roleDataLIst is empty");
            return false;
        }
        for (RoleData roleData : roleDataList) {
            Set rolePrivileges = roleData.getPrivilegeIds();
            if (rolePrivileges.isEmpty()) continue;
            functions.processPrivileges(rolePrivileges);
            if (!functions.isDone()) continue;
            break;
        }
        _log.trace((Object)"processDirectAsssignment returns true.");
        return true;
    }

    @Override
    public boolean isSuperuser(Principal principal) {
        if (principal == null) {
            _log.trace((Object)"Principal null. Returning false.");
            return false;
        }
        UserData data = this._users.get(principal);
        boolean result = true;
        if (data == null || !data.isFullAccess()) {
            result = false;
        }
        return result;
    }

    @Override
    public synchronized void notifyAdd(Principal principal, boolean hasFullAccess) throws AuthorizationException {
        UserData data;
        String name = principal.getName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Got notifyAdd call for user: " + name));
        }
        if ((data = this.getUserData(principal, hasFullAccess)).getRef() >= this._maxUsagePerPrincipal) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Session limit reached for user: " + name + " with " + data.getRef() + " sessions."));
            }
            throw new AuthorizationException("Too many sessions for user: " + name + " with " + data.getRef() + " sessions.");
        }
        data = this.getUserDataAndIncrementUsage(principal, hasFullAccess);
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Session count for user [after add]: %1$s is %2$s", name, data.getRef()));
        }
    }

    @Override
    public synchronized void notifyRemove(Principal principal) {
        UserData data = this._users.get(principal);
        String name = principal.getName();
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("Got notifyRemove call for user: " + name));
        }
        if (data == null) {
            _log.warn((Object)("Unable to find user data for user: " + name));
            return;
        }
        if (data.decRef()) {
            this._users.remove(principal);
            data.getPrincipal().close();
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("Removed user data for: " + name));
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Session count for user [after remove]: %1$s is %2$s", name, data.getRef()));
        }
    }

    private synchronized UserData getUserDataAndIncrementUsage(Principal principal, boolean fullAccess) throws AuthorizationException {
        UserData data = this.getUserData(principal, fullAccess);
        if (data != null) {
            data.incRef();
        }
        return data;
    }

    private synchronized UserData getUserData(Principal principal, boolean fullAccess) throws AuthorizationException {
        UserData data = this._users.get(principal);
        if (data == null) {
            data = this.createUserData(principal, fullAccess);
        } else if (data.isInvalid()) {
            data = this.resetUserData(principal, fullAccess);
        }
        if (data == null || data.isInvalid()) {
            _log.fatal((Object)"UserData was not retrieved for principal.");
            return null;
        }
        return data;
    }

    private synchronized UserData resetUserData(Principal principal, boolean fullAccess) throws AuthorizationException {
        UserData data = this._users.get(principal);
        if (data == null) {
            _log.fatal((Object)"Cannot reset null data");
            return null;
        }
        if (!data.isInvalid()) {
            return data;
        }
        if (!principal.refresh()) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)("Unable to refresh principal " + principal.getName()));
            }
            return null;
        }
        UserData oldData = data;
        data = this.createUserData(principal, fullAccess);
        data.setRef(oldData.getRef());
        return data;
    }

    private synchronized UserData createUserData(Principal principal, boolean fullAccess) throws AuthorizationException {
        UserData data = new UserData(principal, fullAccess);
        this._users.put(principal, data);
        return data;
    }

    @Override
    public LinkedHashMap<String, Collection<Permission>> getPermission(String objectId) throws AuthorizationException {
        return this.getPermission(objectId, false);
    }

    @Override
    public LinkedHashMap<String, Collection<Permission>> getPermission(String objectId, boolean propagationOnly) throws AuthorizationException {
        LinkedHashMap<String, Collection<Permission>> result = new LinkedHashMap<String, Collection<Permission>>();
        this.fillPermissions(objectId, result, propagationOnly);
        List<String> parentList = new ArrayList();
        ArrayList<String> altParentList = new ArrayList();
        if (this._hierarchyPlugin != null) {
            parentList = this.getParentChainFromPlugin(objectId, true);
            altParentList = this.getParentChainFromPlugin(objectId, false);
        }
        if (!objectId.equals(AclConstants.GLOBAL_PERMISSIONS_DOC_ENCODED) && !parentList.contains(AclConstants.GLOBAL_PERMISSIONS_DOC_ENCODED)) {
            parentList.add(AclConstants.GLOBAL_PERMISSIONS_DOC_ENCODED);
        }
        if (parentList.size() > 0) {
            this.traveseParentChain(result, parentList);
        }
        if (altParentList.size() > 0) {
            this.traveseParentChain(result, altParentList);
        }
        return result;
    }

    List getParentChainFromPlugin(String objectId, boolean usePrimaryParent) {
        ArrayList<String> parentChain;
        block10: {
            if (this._hierarchyPlugin == null) {
                return null;
            }
            parentChain = new ArrayList<String>();
            HashSet<String> visited = new HashSet<String>();
            visited.add(objectId);
            try {
                URI objectUri = new URI(objectId);
                URI owningDoc = this._hierarchyPlugin.getOwningDoc(objectUri);
                if (owningDoc != null && !objectUri.equals(owningDoc)) {
                    visited.add(owningDoc.toASCIIString());
                    parentChain.add(owningDoc.toASCIIString());
                    objectUri = owningDoc;
                }
                while (objectUri != null) {
                    URI parentDoc = usePrimaryParent ? this._hierarchyPlugin.getParentDoc(objectUri) : this._hierarchyPlugin.getAlternativeParentDoc(objectUri);
                    if (parentDoc != null) {
                        if (visited.contains(parentDoc.toASCIIString())) {
                            if (_log.isErrorEnabled()) {
                                _log.error((Object)"Detected loop obtaining parent chain from the hierarchy plugin.");
                            }
                            break;
                        }
                        parentChain.add(parentDoc.toASCIIString());
                        visited.add(parentDoc.toASCIIString());
                    }
                    objectUri = parentDoc;
                }
            }
            catch (URISyntaxException e) {
                if (_log.isErrorEnabled()) {
                    _log.error((Object)"Invalid object id detected applying hierarchy plugin", (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!_log.isErrorEnabled()) break block10;
                _log.error((Object)"Exception encountered applying hierarchy plugin", (Throwable)e);
            }
        }
        return parentChain;
    }

    private void traveseParentChain(Map<String, Collection<Permission>> result, List<String> parentList) throws AuthorizationException {
        if (parentList != null && !parentList.isEmpty()) {
            for (String id : parentList) {
                this.fillPermissions(id, result, true);
            }
        }
    }

    private void fillPermissions(String objectId, Map<String, Collection<Permission>> result, boolean selectPropogting) throws AuthorizationException {
        Collection<Permission> permissions = this._prov.getPermissions(objectId);
        if (permissions.isEmpty()) {
            return;
        }
        if (!selectPropogting) {
            result.put(objectId, permissions);
            return;
        }
        ArrayList<Permission> list = new ArrayList<Permission>();
        for (Permission p : permissions) {
            if (!p.getPropagate()) continue;
            list.add(p);
        }
        if (!list.isEmpty()) {
            result.put(objectId, list);
        }
    }

    private Collection<String> getAllRootObjectIds() throws AuthorizationException {
        return new HashSet<String>(this._prov.getAllRootObjectIds());
    }

    private String getVcRoot() throws AuthorizationException {
        return this._prov.getVcRootObjectId();
    }

    @Override
    public boolean isDescendantOf(String objectId, Set<String> parentIds) {
        return this._prov.isDescendantOf(objectId, parentIds);
    }

    @Override
    public AuthFilterInfo getAuthInfo(String objectId) {
        return this._prov.getAuthInfo(objectId);
    }

    @Override
    public boolean isAllowedOnRoot(Principal principal, Collection<String> privileges) throws AuthorizationException {
        return this.isAllowed(principal, this._globalDocId, privileges);
    }

    private <T> void processVcdPermissions(String objectId, AuthFilterInfo authInfo, Principal principal, ProcessPrivilegesFunctions functions) throws AuthorizationException {
        if (authInfo.getProviderUuid() == null) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("Object " + objectId + " does not have provider information."));
            }
            return;
        }
        String root = this._prov.getProviderRootObjectId(authInfo.getProviderUuid());
        if (root == null) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("Object " + objectId + " does not have root information."));
            }
            return;
        }
        Set<String> rootAccess = this.getUserPrivilegesInternal(principal, root);
        if (rootAccess.isEmpty()) {
            return;
        }
        if (authInfo.getOwner() != null && principal.matches(authInfo.getOwner())) {
            functions.processPrivileges(rootAccess);
            return;
        }
        Set<String> directAccess = this.getUserPrivilegesInternal(principal, objectId);
        if (directAccess.isEmpty()) {
            return;
        }
        Sets.SetView intersection = Sets.intersection(rootAccess, directAccess);
        functions.processPrivileges((Set<String>)intersection);
    }

    private Set<String> getUserPrivilegesInternal(Principal principal, String objectId) throws AuthorizationException {
        Set<Long> roles = this.getMatchingRoles(objectId, principal, false);
        if (roles.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Long roleId : roles) {
            RoleData roleData = this._prov.getRoles().get(roleId);
            if (roleData == null) {
                if (!_log.isTraceEnabled()) continue;
                _log.trace((Object)("Role with ID " + roleId + " does not exist"));
                continue;
            }
            result.addAll(roleData.getPrivilegeIds());
        }
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        return result;
    }

    private Set<Long> getMatchingRoles(String objectId, Principal principal, boolean propogatingOnly) throws AuthorizationException {
        Collection<Permission> permissions;
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("In getMatchingRoles for object " + objectId + " and principal " + principal.getName()));
        }
        if ((permissions = this._prov.getPermissions(objectId)).isEmpty()) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)("provider returned empty permission set for object " + objectId + ". Emtpy role set will be returned"));
            }
            return Collections.emptySet();
        }
        HashSet roles = new HashSet();
        for (Permission p : permissions) {
            if (propogatingOnly && !p.getPropagate() || !principal.matches(p.getPrincipal())) continue;
            if (!p.getPrincipal().isGroup() && !principal.isGroup()) {
                roles.clear();
                roles.addAll(p.getRoleIds());
                break;
            }
            roles.addAll(p.getRoleIds());
        }
        if (roles.isEmpty()) {
            _log.trace((Object)"permission set was found but no matching roles for principal was found. Will return emtpy role set. ");
        }
        return roles.isEmpty() ? Collections.emptySet() : roles;
    }

    public Set<String> getAdminPrivileges() {
        RoleData adminRole = this._prov.getRoles().get(-1L);
        if (adminRole == null) {
            _log.trace((Object)"Built in admin role is not initialized. If it is not client library code then it is a serious error. In case of client library code, user may not have required privileges to perform client side validation effectively.");
            return Collections.emptySet();
        }
        return adminRole.getPrivilegeIds();
    }

    public Set<String> getViewPrivileges() {
        RoleData viewRole = this._prov.getRoles().get(-3L);
        if (viewRole == null) {
            _log.trace((Object)"Built in view role is not initialized. If it is not client library code then it is a serious error. In case of client library code, user may not have required privileges to perform client side validation effectively.");
            return Collections.emptySet();
        }
        return viewRole.getPrivilegeIds();
    }

    @Override
    public void setHierarchyPlugin(DocHierarchyPlugin plugin) {
        this._hierarchyPlugin = plugin;
    }

    private static interface ProcessPrivilegesFunctions {
        public void processPrivileges(Set<String> var1);

        public boolean isDone();
    }
}

