/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authorization.impl;

import com.vmware.cis.core.Principal;
import java.util.concurrent.atomic.AtomicInteger;

class UserData {
    private final Principal _principal;
    private final AtomicInteger _refCount;
    private final boolean _fullAccess;
    private volatile boolean _invalid;

    public UserData(Principal p, boolean fullAccess) {
        this._principal = p;
        this._refCount = new AtomicInteger(0);
        this._fullAccess = fullAccess;
        this._invalid = false;
    }

    public void setInvalid(boolean invalid) {
        this._invalid = invalid;
    }

    public boolean isInvalid() {
        return this._invalid;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public boolean isFullAccess() {
        return this._fullAccess;
    }

    public int getRef() {
        return this._refCount.get();
    }

    public void setRef(int refCount) {
        this._refCount.set(refCount);
    }

    public void incRef() {
        this._refCount.incrementAndGet();
    }

    public boolean decRef() {
        return this._refCount.decrementAndGet() == 0;
    }
}

