/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.notif.provider.is;

import com.ctc.wstx.stax.WstxInputFactory;
import com.vmware.cis.notif.client.ChangeType;
import com.vmware.cis.notif.client.DeserializationException;
import com.vmware.cis.notif.client.NotificationException;
import com.vmware.cis.notif.client.ObjectChange;
import com.vmware.cis.notif.client.ObjectChangeIterator;
import com.vmware.cis.notif.client.Version;
import com.vmware.cis.notif.client.impl.ObjectChangeImpl;
import com.vmware.cis.notif.provider.is.IsNotificationProviderImpl;
import com.vmware.cis.notif.provider.is.VersionImpl;
import com.vmware.vim.query.client.provider.ProviderClient;
import com.vmware.vim.query.core.provider.AtomFeedEntry;
import com.vmware.vim.query.core.provider.content.ContentAtomFeed;
import com.vmware.vim.query.core.provider.content.ContentAtomFeedEntry;
import com.vmware.vim.query.core.provider.pull.PullEntryMetadata;
import com.vmware.vim.query.core.provider.pull.PullEntryProperty;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

class IsObjectChangeIterator
implements ObjectChangeIterator {
    private IsNotificationProviderImpl _provider;
    private Iterator<ContentAtomFeedEntry> _contentEntries;
    private static final XMLInputFactory _inputfactory = new WstxInputFactory();
    private static final Log _log = LogFactory.getLog(ObjectChangeIterator.class);

    public IsObjectChangeIterator(ContentAtomFeed resp, IsNotificationProviderImpl provider) {
        this._contentEntries = resp.getFeedEntries();
        this._provider = provider;
    }

    @Override
    public boolean hasNext() {
        return this._contentEntries.hasNext();
    }

    @Override
    public Version getCurrentVersion() {
        IsNotificationProviderImpl.IsPollState ps = this._provider.getPollState();
        if (ps == null) {
            return null;
        }
        return new VersionImpl(ps.getGeneration());
    }

    @Override
    public ObjectChange nextChange() throws NotificationException {
        ContentAtomFeedEntry e = this._contentEntries.next();
        ObjectChange o = this.createObjectChange(e);
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("Change received: ChangeType = " + o.getType().toString() + " Id = " + o.getObjectId().toString() + "Object Type = " + o.getObjectType()));
        }
        if (!this.hasNext() && _log.isDebugEnabled()) {
            _log.debug((Object)("Last Change received: ChangeType = " + o.getType().toString() + " Id = " + o.getObjectId().toString() + "Object Type = " + o.getObjectType()));
        }
        return o;
    }

    @Override
    public ObjectChange next() {
        try {
            return this.nextChange();
        }
        catch (NotificationException ne) {
            throw new RuntimeException(ne);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from PollResults");
    }

    private ObjectChange createObjectChange(ContentAtomFeedEntry e) throws NotificationException {
        ChangeType changeType = this.mapChangeType(e.getChangeType());
        QName[] propNames = null;
        Object doc = null;
        boolean tagChanges = false;
        String tags = null;
        String objectType = null;
        DeserializationException deserializationError = null;
        if (changeType == ChangeType.EDIT) {
            List pem = e.getEntryMetadataList();
            List pep = e.getEntryPropertyList();
            if (pem != null && !pem.isEmpty()) {
                for (PullEntryMetadata pe : pem) {
                    if (!pe.getMetadataName().equals((Object)PullEntryMetadata.MetadataName.TAGS)) continue;
                    tagChanges = true;
                    break;
                }
            }
            if (pep == null || pep.isEmpty()) {
                if (!tagChanges) {
                    // empty if block
                }
            } else {
                propNames = new QName[pep.size()];
                int n = 0;
                for (PullEntryProperty pe : pep) {
                    QName propName = pe.getPropertyName();
                    propNames[n++] = propName;
                }
            }
        }
        if (changeType != ChangeType.DELETE) {
            try {
                Map<String, String> metadata;
                ProviderClient client = this._provider.getClient();
                if (tagChanges && (metadata = client.getQueryDispatcher().getMetadata(e.getObjectId())) != null) {
                    tags = metadata.get("tags");
                }
                if (e.getContent() != null) {
                    doc = this.getStringFromDocument(e.getContent());
                    if (this._provider.getSubscription().getDeserializer() != null) {
                        try {
                            ByteArrayInputStream stream = new ByteArrayInputStream(doc.toString().getBytes("UTF-8"));
                            XMLStreamReader reader = _inputfactory.createXMLStreamReader(stream);
                            doc = this._provider.getSubscription().getDeserializer().deserialize(reader);
                        }
                        catch (DeserializationException de) {
                            deserializationError = new DeserializationException(de.getMessage() + " Deserialization Exception", de, doc.toString());
                        }
                    }
                }
            }
            catch (Exception ce) {
                throw new NotificationException(ce);
            }
        }
        String[] tagList = null;
        if (tags != null && (tags = tags.trim()).length() > 0) {
            tagList = tags.split(" *, *");
        }
        if (e.getType() != null) {
            objectType = e.getType().toString();
        }
        ObjectChangeImpl o = new ObjectChangeImpl(e.getObjectId(), objectType, changeType, propNames, doc, tagChanges, tagList, deserializationError);
        return o;
    }

    private ChangeType mapChangeType(AtomFeedEntry.ChangeType act) {
        switch (act) {
            case CREATE: {
                return ChangeType.CREATE;
            }
            case EDIT: {
                return ChangeType.EDIT;
            }
            case DELETE: {
                return ChangeType.DELETE;
            }
        }
        return ChangeType.EDIT;
    }

    private static String getAsString(InputStream stream) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)stream, (Writer)writer, (String)"utf-8");
        return writer.toString();
    }

    private String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
    }
}

