/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.clientutil;

import com.vmware.vim.binding.vim.InternalServiceInstanceContent;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.clientutil.VmomiClientUtil;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InventoryClientUtil {
    private static final Log _log = LogFactory.getLog(InventoryClientUtil.class);

    public ServiceData getAuthDataForDataService(Client client) throws ExecutionException, InterruptedException {
        ServiceData data = new ServiceData();
        ManagedObjectReference si = new ManagedObjectReference();
        si.setType("ServiceInstance");
        si.setValue("ServiceInstance");
        ServiceInstance siStub = VmomiClientUtil.createStub(client, ServiceInstance.class, si, "IS");
        BlockingFuture result = new BlockingFuture();
        siStub.retrieveContent((Future)result);
        ServiceInstanceContent sic = (ServiceInstanceContent)result.get();
        String vcInstanceUuid = sic.getAbout().getInstanceUuid();
        BlockingFuture resultIsic = new BlockingFuture();
        siStub.retrieveInternalContent((Future)resultIsic);
        InternalServiceInstanceContent isic = (InternalServiceInstanceContent)resultIsic.get();
        ServiceDirectory sd = VmomiClientUtil.createStub(client, ServiceDirectory.class, isic.getServiceDirectory(), "IS");
        BlockingFuture endpointsF = new BlockingFuture();
        sd.queryServiceEndpointList((Future)endpointsF);
        ServiceDirectory.ServiceEndpoint[] endpoints = (ServiceDirectory.ServiceEndpoint[])endpointsF.get();
        String vwsKey = null;
        for (ServiceDirectory.ServiceEndpoint ep : endpoints) {
            if (!ep.getProtocol().equals("vimWebServices") || !ep.getInstanceName().equals("VSPHERE-INVENTORY-SERVICE/" + vcInstanceUuid)) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Found endpoint: " + ep.getInstanceName() + " with UUID: " + ep.getInstanceUuid()));
            }
            vwsKey = ep.getKey();
            String ticket = InventoryClientUtil.acquireSessionTicket(client, vwsKey);
            data._ticket = ticket;
            data._instanceUuid = ep.getInstanceUuid();
            data._url = ep.getUrl();
            break;
        }
        if (vwsKey == null) {
            throw new IllegalStateException("No valid endpoints found.");
        }
        return data;
    }

    private static String acquireSessionTicket(Client c, String vwsKey) throws ExecutionException, InterruptedException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Using key: " + vwsKey));
        }
        ManagedObjectReference si = new ManagedObjectReference();
        si.setType("ServiceInstance");
        si.setValue("ServiceInstance");
        ServiceInstance siStub = VmomiClientUtil.createStub(c, ServiceInstance.class, si, "IS");
        BlockingFuture result = new BlockingFuture();
        siStub.getContent((Future)result);
        ServiceInstanceContent content = (ServiceInstanceContent)result.get();
        SessionManager sessionMgr = VmomiClientUtil.createStub(c, SessionManager.class, content.getSessionManager(), "IS");
        BlockingFuture ticketF = new BlockingFuture();
        sessionMgr.acquireSessionTicket(vwsKey, (Future)ticketF);
        String ticket = (String)ticketF.get();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Got ticket: " + ticket));
        }
        return ticket;
    }

    public static class ServiceData {
        private String _instanceUuid;
        private String _url;
        private String _ticket;

        public String getInstanceUuid() {
            return this._instanceUuid;
        }

        public String getUrl() {
            return this._url;
        }

        public String getTicket() {
            return this._ticket;
        }
    }
}

