/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.impl;

import com.vmware.cis.notif.client.ValueSelector;
import com.vmware.vim.query.client.ObjectFilterSpec;
import com.vmware.vim.query.client.PropertyFilterSpec;
import com.vmware.vim.query.client.QueryDispatcher;
import com.vmware.vim.query.client.QueryFilterSpec;
import com.vmware.vim.query.client.ValueFilterSpec;
import com.vmware.vim.query.client.exception.ClientException;
import com.vmware.vim.query.client.impl.ClientImpl;
import com.vmware.vim.query.client.impl.HttpUtil;
import com.vmware.vim.query.client.impl.RetryAction;
import com.vmware.vim.query.client.impl.ValidationHelper;
import com.vmware.vim.query.client.provider.impl.AtomFeedUnmarshaller;
import com.vmware.vim.query.core.SourceVersion;
import com.vmware.vim.query.core.provider.content.ContentAtomFeed;
import com.vmware.vim.query.core.provider.pull.PullAtomFeed;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;

public class QueryDispatcherImpl
implements QueryDispatcher {
    private static final Log _log = LogFactory.getLog(QueryDispatcherImpl.class);
    private ClientImpl _client;
    private String _queryContext = "/query/";
    private String _atomFeedContext = "/atom";
    private final AtomFeedUnmarshaller _unmarshaller;

    QueryDispatcherImpl(ClientImpl client, AtomFeedUnmarshaller unmarshaller) {
        this._client = client;
        this._unmarshaller = unmarshaller;
    }

    public void setQueryContext(String queryContext) {
        this._queryContext = queryContext;
    }

    public void setProviderFeedContext(String atomFeedContext) {
        this._atomFeedContext = atomFeedContext;
    }

    @Override
    public QueryDispatcher.QueryResponse query(final String query, final Map<String, Object> options) throws ClientException {
        return (QueryDispatcher.QueryResponse)new RetryAction<QueryDispatcher.QueryResponse>(this._client){

            @Override
            public QueryDispatcher.QueryResponse doAction() throws ClientException {
                return QueryDispatcherImpl.this.queryImpl(query, options);
            }

            @Override
            public void resetState() {
            }
        }.execute();
    }

    private boolean isFederated(Map<String, Object> options) throws ClientException {
        if (options.containsKey(QueryDispatcher.QueryOption.FEDERATED.name())) {
            Object val = options.get(QueryDispatcher.QueryOption.FEDERATED.name());
            ValidationHelper.assertType(val, Boolean.class);
            if (val.toString().equals(Boolean.TRUE.toString())) {
                return true;
            }
        }
        return false;
    }

    private String getCommaSepStrFromCollection(Collection<String> c) {
        if (!c.isEmpty()) {
            Iterator<String> iter = c.iterator();
            StringBuilder sb = new StringBuilder(iter.next().toString());
            while (iter.hasNext()) {
                sb.append(",").append(iter.next());
            }
            return sb.toString();
        }
        return null;
    }

    private QueryDispatcher.QueryResponse queryImpl(String query, Map<String, Object> options) throws ClientException {
        if (query == null) {
            throw new IllegalArgumentException("query cannot be null");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Dispatching query:\n" + query));
        }
        HttpPost method = new HttpPost(this._client.getSecureBaseUri() + this._queryContext);
        method.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        try {
            method.setEntity((HttpEntity)new StringEntity(query, "UTF-8"));
        }
        catch (UnsupportedCharsetException e) {
            throw new IllegalArgumentException(e);
        }
        if (options != null) {
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                String key = entry.getKey();
                Object val = entry.getValue();
                if (val == null) {
                    throw new ClientException("value not set for option:" + key);
                }
                if (key.equals(QueryDispatcher.QueryOption.FEDERATED.name())) {
                    ValidationHelper.assertType(val, Boolean.class);
                    method.setHeader("federated", val.toString());
                    continue;
                }
                if (key.equals(QueryDispatcher.QueryOption.FEDERATED_MULTICAST.name())) {
                    if (!this.isFederated(options)) {
                        throw new ClientException("FEDERATED_MULTICAST cannot be set if FEDERATED is set to false");
                    }
                    ValidationHelper.assertType(val, Collection.class);
                    String uuids = this.getCommaSepStrFromCollection((Collection)val);
                    if (uuids == null) continue;
                    method.setHeader("multicast_federated", uuids);
                    continue;
                }
                if (key.equals(QueryDispatcher.QueryOption.TARGET_SPECIFIC_PRODUCT.name())) {
                    ValidationHelper.assertType(val, String.class);
                    method.setHeader("product", this.urlEncode(val.toString()));
                    continue;
                }
                if (key.equals(QueryDispatcher.QueryOption.TARGET_SPECIFIC_UUID.name())) {
                    ValidationHelper.assertType(val, String.class);
                    method.setHeader("uuid", this.urlEncode(val.toString()));
                    continue;
                }
                if (key.equals(QueryDispatcher.QueryOption.SOURCE_VERSION_VECTOR.name())) {
                    ValidationHelper.assertType(val, Collection.class);
                    for (Object svv : (Collection)val) {
                        ValidationHelper.assertType(svv, SourceVersion.class);
                        method.addHeader("X-SVV-Vector", this.urlEncode(svv.toString()));
                    }
                    continue;
                }
                if (key.equals(QueryDispatcher.QueryOption.SOURCE_VERSION_TIMEOUT_MS.name())) {
                    ValidationHelper.assertType(val, Long.class);
                    method.setHeader("X-SVV-Timeout", val.toString());
                    continue;
                }
                if (key.equals(InternalOption.TIMEOUT.name())) {
                    ValidationHelper.assertType(val, Integer.class);
                    method.setHeader("timeout", val.toString());
                    continue;
                }
                if (key.equals(InternalOption.SYNC_PROVIDER.name())) {
                    ValidationHelper.assertType(val, Boolean.class);
                    method.setHeader("sync_provider", val.toString());
                    continue;
                }
                if (key.equals(InternalOption.PROVIDERS_TO_SYNC.name())) {
                    ValidationHelper.assertType(val, String[].class);
                    StringBuilder sb = new StringBuilder();
                    String[] str = (String[])val;
                    for (int i = 0; i < str.length; ++i) {
                        sb.append(str[i]);
                        if (i >= str.length - 1) continue;
                        sb.append(',');
                    }
                    method.setHeader("sync_multiple_providers", sb.toString());
                    continue;
                }
                if (key.equals(InternalOption.IS_DESCENDANT_OF.name())) {
                    if (String.class.isAssignableFrom(val.getClass())) {
                        method.setHeader("is_descendant_of", val.toString());
                        continue;
                    }
                    ValidationHelper.assertType(val, Collection.class);
                    String result = this.getCommaSepStrFromCollection((Collection)val);
                    if (result == null) continue;
                    method.setHeader("is_descendant_of", result);
                    continue;
                }
                if (key.equals(InternalOption.IS_REMOTE_CALL.name())) {
                    ValidationHelper.assertType(val, Boolean.class);
                    method.setHeader("is_remote_call", val.toString());
                    continue;
                }
                if (key.equals(QueryDispatcher.QueryOption.RETURN_DELETED_DOCS.name())) {
                    ValidationHelper.assertType(val, Boolean.class);
                    method.setHeader("return_deleted_docs", val.toString());
                    continue;
                }
                throw new ClientException("unknown option:" + key);
            }
        }
        return new QueryResponseImpl(HttpUtil.executeWithResponse(this._client, (HttpUriRequest)method));
    }

    private String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public QueryDispatcher.QueryResponse getDocument(final URI docId, final QName[] properties) throws ClientException {
        return (QueryDispatcher.QueryResponse)new RetryAction<QueryDispatcher.QueryResponse>(this._client){

            @Override
            public QueryDispatcher.QueryResponse doAction() throws ClientException {
                return QueryDispatcherImpl.this.getDocumentImpl(docId, properties);
            }

            @Override
            public void resetState() {
            }
        }.execute();
    }

    private QueryDispatcher.QueryResponse getDocumentImpl(URI docId, QName[] properties) throws ClientException {
        HttpResponse resp;
        HttpEntity entity;
        HttpGet method = new HttpGet(this._client.getSecureBaseUri() + "/query/" + "N2R?" + docId);
        String propString = "";
        if (properties != null && properties.length != 0) {
            propString = StringUtils.join((Object[])properties, (char)',');
            method.addHeader("X-Vmomi-Prop", propString);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Dispatching N2R getDocument:\n docId:" + docId + "\n properties:" + propString));
        }
        if ((entity = (resp = HttpUtil.executeWithResponseAndHeaders(this._client, (HttpUriRequest)method)).getEntity()) == null) {
            throw new ClientException("request entity was null; unable to fetch response from server.");
        }
        return new QueryResponseImpl(entity, this.getQueryResponseMetadata(resp));
    }

    private Map<String, String> getQueryResponseMetadata(HttpResponse resp) {
        HashMap<String, String> result = null;
        for (Header h : resp.getAllHeaders()) {
            String name = h.getName();
            if (!name.startsWith("X-QueryService-Metadata-")) continue;
            if (result == null) {
                result = new HashMap<String, String>();
            }
            result.put(name.replace("X-QueryService-Metadata-", ""), h.getValue());
        }
        return result;
    }

    private QueryDispatcher.QueryResponse getProviderAtomFeed(final String providerUuid, final long generation, final boolean includeContent) throws ClientException {
        return (QueryDispatcher.QueryResponse)new RetryAction<QueryDispatcher.QueryResponse>(this._client){

            @Override
            public QueryDispatcher.QueryResponse doAction() throws ClientException {
                return QueryDispatcherImpl.this.getProviderAtomFeedImpl(providerUuid, generation, includeContent);
            }

            @Override
            public void resetState() {
            }
        }.execute();
    }

    @Override
    public QueryDispatcher.QueryResponse getProviderAtomFeed(String providerUuid, long generation) throws ClientException {
        return this.getProviderAtomFeed(providerUuid, generation, false);
    }

    private QueryDispatcher.QueryResponse getProviderAtomFeedImpl(String providerUuid, long generation, boolean includeContent) throws ClientException {
        if (providerUuid == null && _log.isDebugEnabled()) {
            _log.debug((Object)"ProviderUuid not set - execution will return the service document.");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Dispatching feed request:\n providerUuid:" + providerUuid + "\n generation:" + generation));
        }
        String context = this._client.getSecureBaseUri() + this._atomFeedContext;
        if (providerUuid != null) {
            try {
                context = context + String.format("?providerid=%1$s", URLEncoder.encode(providerUuid, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        HttpGet method = new HttpGet(context);
        method.setHeader("X-Vmomi-If-Modified-Since-Generation", Long.toString(generation));
        if (includeContent) {
            method.setHeader("X-Notification-Include-Content", "true");
            HttpResponse resp = HttpUtil.executeWithResponseAndHeaders(this._client, (HttpUriRequest)method);
            HttpEntity entity = resp.getEntity();
            return new QueryResponseImpl(entity, this.getQueryResponseMetadata(resp));
        }
        return new QueryResponseImpl(HttpUtil.executeWithResponse(this._client, (HttpUriRequest)method));
    }

    private QueryDispatcher.QueryResponse getProviderAtomFeedImpl(String providerUuid, ObjectFilterSpec objSpec, PropertyFilterSpec propertySpec, ValueFilterSpec valueFilterSpec, long generation, boolean includeContent) throws ClientException {
        Iterator<BasicHeader> it;
        if (!(objSpec != null && objSpec.getObjectFilter().size() != 0 || propertySpec != null && propertySpec.getPropertyFilter().size() != 0 || valueFilterSpec != null && valueFilterSpec.getValueFilter().size() != 0)) {
            return this.getProviderAtomFeedImpl(providerUuid, generation, includeContent);
        }
        if (providerUuid == null && _log.isDebugEnabled()) {
            _log.debug((Object)"ProviderUuid not set - execution will return the service document.");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Dispatching feed request:\n providerUuid:" + providerUuid + "\n generation:" + generation));
        }
        String context = this._client.getSecureBaseUri() + this._atomFeedContext;
        if (providerUuid != null) {
            try {
                context = context + String.format("?providerid=%1$s", URLEncoder.encode(providerUuid, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        HttpGet method = new HttpGet(context);
        method.setHeader("X-Vmomi-If-Modified-Since-Generation", Long.toString(generation));
        if (objSpec != null) {
            method.setHeader("X-QueryService-Query-Object-Filter", StringUtils.join((Collection)objSpec.getObjectFilter(), (char)','));
        }
        if (propertySpec != null) {
            List<BasicHeader> propertySpecHeaders = this.serializeHeadersFromPropertyFilter(propertySpec);
            it = propertySpecHeaders.iterator();
            while (it.hasNext()) {
                method.addHeader((Header)it.next());
            }
        }
        if (valueFilterSpec != null) {
            List<BasicHeader> valueSpecHeaders = this.serializeHeadersFromValueFilter(valueFilterSpec);
            it = valueSpecHeaders.iterator();
            while (it.hasNext()) {
                method.addHeader((Header)it.next());
            }
        }
        if (includeContent) {
            method.setHeader("X-Notification-Include-Content", "true");
            HttpResponse resp = HttpUtil.executeWithResponseAndHeaders(this._client, (HttpUriRequest)method);
            HttpEntity entity = resp.getEntity();
            return new QueryResponseImpl(entity, this.getQueryResponseMetadata(resp));
        }
        return new QueryResponseImpl(HttpUtil.executeWithResponse(this._client, (HttpUriRequest)method));
    }

    private QueryDispatcher.QueryResponse getProviderAtomFeedImpl(String providerUuid, QueryFilterSpec filterSpec, long generation, boolean includeContent) throws ClientException {
        if (filterSpec == null) {
            return this.getProviderAtomFeedImpl(providerUuid, generation, includeContent);
        }
        URI[] objectIds = filterSpec.getObjectIds();
        Object[] changeTypes = filterSpec.getChangeTypes();
        if (!(objectIds != null && objectIds.length != 0 || changeTypes != null && changeTypes.length != 0)) {
            return this.getProviderAtomFeedImpl(providerUuid, generation, includeContent);
        }
        if (providerUuid == null && _log.isDebugEnabled()) {
            _log.debug((Object)"ProviderUuid not set - execution will return the service document.");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Dispatching feed request:\n providerUuid:" + providerUuid + "\n generation:" + generation));
        }
        String context = this._client.getSecureBaseUri() + this._atomFeedContext;
        if (providerUuid != null) {
            try {
                context = context + String.format("?providerid=%1$s", URLEncoder.encode(providerUuid, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        HttpGet method = new HttpGet(context);
        method.setHeader("X-Vmomi-If-Modified-Since-Generation", Long.toString(generation));
        if (changeTypes != null && changeTypes.length > 0) {
            method.setHeader("X-QueryService-Query-Change-Type-Filter", StringUtils.join((Object[])changeTypes, (char)','));
        }
        if (objectIds != null && objectIds.length > 0) {
            List<BasicHeader> objectIdHeaders = this.serializeHeadersFromObjectIds(objectIds);
            Iterator<BasicHeader> it = objectIdHeaders.iterator();
            while (it.hasNext()) {
                method.addHeader((Header)it.next());
            }
        }
        if (includeContent) {
            method.setHeader("X-Notification-Include-Content", "true");
            HttpResponse resp = HttpUtil.executeWithResponseAndHeaders(this._client, (HttpUriRequest)method);
            HttpEntity entity = resp.getEntity();
            return new QueryResponseImpl(entity, this.getQueryResponseMetadata(resp));
        }
        return new QueryResponseImpl(HttpUtil.executeWithResponse(this._client, (HttpUriRequest)method));
    }

    private List<BasicHeader> serializeHeadersFromPropertyFilter(PropertyFilterSpec spec) {
        if (spec == null || spec.getPropertyFilter().size() == 0) {
            return null;
        }
        ArrayList<BasicHeader> headerList = new ArrayList<BasicHeader>();
        Map<QName, List<QName>> propertyFilter = spec.getPropertyFilter();
        Set<QName> typeNames = propertyFilter.keySet();
        for (QName typeName : typeNames) {
            List<QName> propertyList = propertyFilter.get(typeName);
            if (propertyList == null) {
                propertyList = new ArrayList<QName>();
            }
            propertyList.add(0, typeName);
            String propertyFilterString = StringUtils.join(propertyList, (char)',');
            BasicHeader header = new BasicHeader("X-QueryService-Query-Property-Filter", propertyFilterString);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Property Filter header" + header.toString()));
            }
            headerList.add(header);
        }
        return headerList;
    }

    private List<BasicHeader> serializeHeadersFromValueFilter(ValueFilterSpec spec) {
        if (spec == null || spec.getValueFilter().size() == 0) {
            return null;
        }
        ArrayList<BasicHeader> headerList = new ArrayList<BasicHeader>();
        List<ValueSelector> valueFilter = spec.getValueFilter();
        for (ValueSelector valueSelector : valueFilter) {
            BasicHeader header;
            String valueFilterString;
            QName typeName = valueSelector.getObjectType();
            QName attributeName = valueSelector.getAttributeName();
            QName propertyName = valueSelector.getPropertyName();
            String[] values = valueSelector.getValues();
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.addAll(Arrays.asList(values));
            if (attributeName == null) {
                valueList.add(0, typeName.toString());
                valueList.add(1, propertyName.toString());
                valueList.add(2, "DummyAttr");
                valueFilterString = StringUtils.join(valueList, (char)',');
                header = new BasicHeader("X-QueryService-Query-Value-Filter", valueFilterString);
            } else {
                valueList.add(0, typeName.toString());
                valueList.add(1, propertyName.toString());
                valueList.add(2, attributeName.toString());
                valueFilterString = StringUtils.join(valueList, (char)',');
                header = new BasicHeader("X-QueryService-Query-Value-Filter", valueFilterString);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Value Filter header" + header.toString()));
            }
            headerList.add(header);
        }
        return headerList;
    }

    private List<BasicHeader> serializeHeadersFromObjectIds(URI[] objectIds) {
        if (objectIds == null || objectIds.length == 0) {
            return null;
        }
        int idsPerHeader = 4;
        ArrayList<BasicHeader> headerList = new ArrayList<BasicHeader>();
        String ids = "";
        for (int i = 0; i < objectIds.length; ++i) {
            ids = ids + objectIds[i].toASCIIString();
            if ((i + 1) % 4 == 0 || i + 1 == objectIds.length) {
                BasicHeader header = new BasicHeader("X-QueryService-Query-Object-Id-Filter", ids);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Object Id Filter header: " + header.toString()));
                }
                headerList.add(header);
                continue;
            }
            ids = ids + ",";
        }
        return headerList;
    }

    @Override
    public QueryDispatcher.QueryResponse getStatus() throws ClientException {
        return (QueryDispatcher.QueryResponse)new RetryAction<QueryDispatcher.QueryResponse>(this._client){

            @Override
            public QueryDispatcher.QueryResponse doAction() throws ClientException {
                return QueryDispatcherImpl.this.getStatusImpl();
            }

            @Override
            public void resetState() {
            }
        }.execute();
    }

    private QueryDispatcher.QueryResponse getStatusImpl() throws ClientException {
        String context = this._client.getBaseUri() + "/health/";
        HttpGet method = new HttpGet(context);
        return new QueryResponseImpl(HttpUtil.executeWithResponse(this._client, (HttpUriRequest)method));
    }

    @Override
    public PullAtomFeed getProviderFeed(String providerUuid, long generation) throws ClientException {
        InputStream stream = this.getProviderAtomFeed(providerUuid, generation).getResponseStream();
        try {
            PullAtomFeed pullAtomFeed = this._unmarshaller.unmarshalPullFeed(stream, this._client.getBaseUri());
            return pullAtomFeed;
        }
        catch (XMLStreamException e) {
            throw new ClientException(e);
        }
        finally {
            block9: {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (!_log.isTraceEnabled()) break block9;
                    _log.trace((Object)("Error closing stream: " + e.toString()));
                }
            }
        }
    }

    @Override
    public PullAtomFeed getProviderFeed(final String providerUuid, final ObjectFilterSpec objSpec, final long generation) throws ClientException {
        QueryDispatcher.QueryResponse response = (QueryDispatcher.QueryResponse)new RetryAction<QueryDispatcher.QueryResponse>(this._client){

            @Override
            public QueryDispatcher.QueryResponse doAction() throws ClientException {
                return QueryDispatcherImpl.this.getProviderAtomFeedImpl(providerUuid, objSpec, null, null, generation, false);
            }

            @Override
            public void resetState() {
            }
        }.execute();
        InputStream stream = response.getResponseStream();
        try {
            PullAtomFeed pullAtomFeed = this._unmarshaller.unmarshalPullFeed(stream, this._client.getBaseUri());
            return pullAtomFeed;
        }
        catch (XMLStreamException e) {
            throw new ClientException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public PullAtomFeed getProviderFeed(final String providerUuid, final PropertyFilterSpec propertySpec, final long generation) throws ClientException {
        QueryDispatcher.QueryResponse response = (QueryDispatcher.QueryResponse)new RetryAction<QueryDispatcher.QueryResponse>(this._client){

            @Override
            public QueryDispatcher.QueryResponse doAction() throws ClientException {
                return QueryDispatcherImpl.this.getProviderAtomFeedImpl(providerUuid, null, propertySpec, null, generation, false);
            }

            @Override
            public void resetState() {
            }
        }.execute();
        InputStream stream = response.getResponseStream();
        try {
            PullAtomFeed pullAtomFeed = this._unmarshaller.unmarshalPullFeed(stream, this._client.getBaseUri());
            return pullAtomFeed;
        }
        catch (XMLStreamException e) {
            throw new ClientException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public PullAtomFeed getProviderFeed(final String providerUuid, final QueryFilterSpec filterSpec, final long generation) throws ClientException {
        QueryDispatcher.QueryResponse response = (QueryDispatcher.QueryResponse)new RetryAction<QueryDispatcher.QueryResponse>(this._client){

            @Override
            public QueryDispatcher.QueryResponse doAction() throws ClientException {
                return QueryDispatcherImpl.this.getProviderAtomFeedImpl(providerUuid, filterSpec, generation, false);
            }

            @Override
            public void resetState() {
            }
        }.execute();
        InputStream stream = response.getResponseStream();
        try {
            PullAtomFeed pullAtomFeed = this._unmarshaller.unmarshalPullFeed(stream, this._client.getBaseUri());
            return pullAtomFeed;
        }
        catch (XMLStreamException e) {
            throw new ClientException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public ContentAtomFeed getProviderContentFeed(String providerUuid, long generation, boolean includeContent) throws ClientException {
        QueryDispatcher.QueryResponse response = this.getProviderAtomFeed(providerUuid, generation, includeContent);
        InputStream stream = response.getResponseStream();
        try {
            ContentAtomFeed contentAtomFeed = this._unmarshaller.unmarshalContentFeed(stream, this._client.getBaseUri());
            return contentAtomFeed;
        }
        catch (XMLStreamException e) {
            throw new ClientException(e);
        }
        finally {
            block9: {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (!_log.isTraceEnabled()) break block9;
                    _log.trace((Object)("Error closing stream: " + e.toString()));
                }
            }
        }
    }

    @Override
    public ContentAtomFeed getProviderContentFeed(final String providerUuid, final ObjectFilterSpec objSpec, final long generation, final boolean includeContent) throws ClientException {
        QueryDispatcher.QueryResponse response = (QueryDispatcher.QueryResponse)new RetryAction<QueryDispatcher.QueryResponse>(this._client){

            @Override
            public QueryDispatcher.QueryResponse doAction() throws ClientException {
                return QueryDispatcherImpl.this.getProviderAtomFeedImpl(providerUuid, objSpec, null, null, generation, includeContent);
            }

            @Override
            public void resetState() {
            }
        }.execute();
        InputStream stream = response.getResponseStream();
        try {
            ContentAtomFeed contentAtomFeed = this._unmarshaller.unmarshalContentFeed(stream, this._client.getBaseUri());
            return contentAtomFeed;
        }
        catch (XMLStreamException e) {
            throw new ClientException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public ContentAtomFeed getProviderContentFeed(final String providerUuid, final PropertyFilterSpec propertySpec, final long generation, final boolean includeContent) throws ClientException {
        QueryDispatcher.QueryResponse response = (QueryDispatcher.QueryResponse)new RetryAction<QueryDispatcher.QueryResponse>(this._client){

            @Override
            public QueryDispatcher.QueryResponse doAction() throws ClientException {
                return QueryDispatcherImpl.this.getProviderAtomFeedImpl(providerUuid, null, propertySpec, null, generation, includeContent);
            }

            @Override
            public void resetState() {
            }
        }.execute();
        InputStream stream = response.getResponseStream();
        try {
            ContentAtomFeed contentAtomFeed = this._unmarshaller.unmarshalContentFeed(stream, this._client.getBaseUri());
            return contentAtomFeed;
        }
        catch (XMLStreamException e) {
            throw new ClientException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public ContentAtomFeed getProviderContentFeed(final String providerUuid, final QueryFilterSpec filterSpec, final long generation, final boolean includeContent) throws ClientException {
        QueryDispatcher.QueryResponse response = (QueryDispatcher.QueryResponse)new RetryAction<QueryDispatcher.QueryResponse>(this._client){

            @Override
            public QueryDispatcher.QueryResponse doAction() throws ClientException {
                return QueryDispatcherImpl.this.getProviderAtomFeedImpl(providerUuid, filterSpec, generation, includeContent);
            }

            @Override
            public void resetState() {
            }
        }.execute();
        InputStream stream = response.getResponseStream();
        try {
            ContentAtomFeed contentAtomFeed = this._unmarshaller.unmarshalContentFeed(stream, this._client.getBaseUri());
            return contentAtomFeed;
        }
        catch (XMLStreamException e) {
            throw new ClientException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public ContentAtomFeed getProviderContentFeed(final String providerUuid, final ValueFilterSpec valueFilterSpec, final long generation, final boolean includeContent) throws ClientException {
        QueryDispatcher.QueryResponse response = (QueryDispatcher.QueryResponse)new RetryAction<QueryDispatcher.QueryResponse>(this._client){

            @Override
            public QueryDispatcher.QueryResponse doAction() throws ClientException {
                return QueryDispatcherImpl.this.getProviderAtomFeedImpl(providerUuid, null, null, valueFilterSpec, generation, includeContent);
            }

            @Override
            public void resetState() {
            }
        }.execute();
        InputStream stream = response.getResponseStream();
        try {
            ContentAtomFeed contentAtomFeed = this._unmarshaller.unmarshalContentFeed(stream, this._client.getBaseUri());
            return contentAtomFeed;
        }
        catch (XMLStreamException e) {
            throw new ClientException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public Map<String, String> getMetadata(URI uri) {
        return this._unmarshaller.getContentFeedMetadata(uri);
    }

    void close() {
    }

    public static class QueryResponseImpl
    implements QueryDispatcher.QueryResponse {
        private static AtomicInteger _cnt = new AtomicInteger(1);
        private HttpEntity _entity;
        private Map<String, String> _metadata;
        private long _createdTime;
        private int _id = _cnt.getAndIncrement();
        private boolean _wasRead = false;
        private StackTraceElement[] _creationStackTrace;

        private QueryResponseImpl(HttpEntity entity, Map<String, String> metadata) throws ClientException {
            this._entity = entity;
            this._metadata = metadata;
            this._createdTime = System.currentTimeMillis();
            this._creationStackTrace = Thread.currentThread().getStackTrace();
        }

        private QueryResponseImpl(HttpEntity entity) throws ClientException {
            this(entity, (Map<String, String>)null);
        }

        private void cleanup() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._id).append(" open for ").append(System.currentTimeMillis() - this._createdTime).append("(ms) + (was read from:) ").append(this._wasRead).append("\n  Creation stacktrace:");
            for (StackTraceElement ste : this._creationStackTrace) {
                sb.append("\n").append(ste);
            }
            return sb.toString();
        }

        @Override
        public InputStream getResponseStream() throws ClientException {
            try {
                return new AutoCloseInputStream((InputStream)new EntityStream(this._entity));
            }
            catch (IOException e) {
                throw new ClientException(e);
            }
        }

        @Override
        public Map<String, String> getMetadata() {
            return this._metadata;
        }

        private class EntityStream
        extends InputStream {
            private HttpEntity _entity;
            private InputStream _stream;

            public EntityStream(HttpEntity entity) throws IOException {
                this._entity = entity;
                this._stream = entity.getContent();
            }

            @Override
            public int available() throws IOException {
                return this._stream.available();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    this._stream.close();
                    this._entity.consumeContent();
                }
                finally {
                    QueryResponseImpl.this.cleanup();
                }
            }

            @Override
            public void mark(int readlimit) {
                this._stream.mark(readlimit);
            }

            @Override
            public boolean markSupported() {
                return this._stream.markSupported();
            }

            @Override
            public int read() throws IOException {
                QueryResponseImpl.this._wasRead = true;
                return this._stream.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                QueryResponseImpl.this._wasRead = true;
                return this._stream.read(b, off, len);
            }

            @Override
            public void reset() throws IOException {
                this._stream.reset();
            }

            @Override
            public long skip(long n) throws IOException {
                return this._stream.skip(n);
            }
        }
    }

    public class QueryResponseMonitor {
        public void registerQueryResponse(QueryResponseImpl resp) {
        }

        public void unregisterQueryResponse(QueryResponseImpl resp) {
        }

        public void init() {
        }

        public void close() {
        }

        public boolean isClosed() {
            return true;
        }

        public ConcurrentHashMap<Integer, WeakReference<QueryResponseImpl>> getStreams() {
            return null;
        }
    }

    public static enum InternalOption {
        TIMEOUT,
        SYNC_PROVIDER,
        PROVIDERS_TO_SYNC,
        IS_DESCENDANT_OF,
        IS_REMOTE_CALL;

    }
}

