/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.impl;

import com.vmware.vim.query.client.AuthenticationStrategy;
import com.vmware.vim.query.client.exception.ClientException;
import com.vmware.vim.query.client.exception.UnauthenticatedException;
import com.vmware.vim.query.client.impl.ClientImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RetryAction<T> {
    private static final Log _log = LogFactory.getLog(RetryAction.class);
    private static ThreadLocal<Boolean> REENTRANT_CHECK = new ThreadLocal();
    private final ClientImpl _client;

    public RetryAction(ClientImpl client) {
        this._client = client;
    }

    public T execute() throws ClientException {
        AuthenticationStrategy authStrategy = this._client.getAuthenticationStrategy();
        if (REENTRANT_CHECK.get() != null && REENTRANT_CHECK.get().booleanValue()) {
            throw new ClientException("Cannot login again - re-entrant call");
        }
        REENTRANT_CHECK.set(true);
        try {
            int loginAttempts = 0;
            while (true) {
                T t;
                try {
                    t = this.doAction();
                }
                catch (UnauthenticatedException e) {
                    if (authStrategy == null) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)"Authentication strategy not set.  Re-throwing exception");
                        }
                        throw e;
                    }
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Hit retry-able exception.  Login attempts so far: " + loginAttempts));
                    }
                    if (authStrategy.getMaxLoginAttempts() <= loginAttempts) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)"Too many retries, re-throwing exception");
                        }
                        throw e;
                    }
                    authStrategy.login(this._client);
                    ++loginAttempts;
                    this.resetState();
                    continue;
                }
                return t;
            }
        }
        finally {
            REENTRANT_CHECK.set(false);
        }
    }

    protected abstract T doAction() throws ClientException;

    protected abstract void resetState();
}

