/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.kv.impl;

import com.vmware.cis.kv.client.ClientConflictResolution;
import com.vmware.cis.kv.client.ClientDeleteSpec;
import com.vmware.cis.kv.client.ClientEntry;
import com.vmware.cis.kv.client.ClientPutSpec;
import com.vmware.cis.kv.client.ClientValue;
import com.vmware.cis.kv.client.ValueMarshaller;
import com.vmware.vim.binding.cis.kv.DeleteSpec;
import com.vmware.vim.binding.cis.kv.Entry;
import com.vmware.vim.binding.cis.kv.MultiDeleteSpec;
import com.vmware.vim.binding.cis.kv.MultiPutSpec;
import com.vmware.vim.binding.cis.kv.OptionalValue;
import com.vmware.vim.binding.cis.kv.PutSpec;
import com.vmware.vim.binding.cis.kv.SearchClause;
import com.vmware.vim.binding.cis.kv.Value;
import com.vmware.vim.binding.impl.cis.kv.ConflictResolutionImpl;
import com.vmware.vim.binding.impl.cis.kv.DeleteSpecImpl;
import com.vmware.vim.binding.impl.cis.kv.MultiDeleteSpecImpl;
import com.vmware.vim.binding.impl.cis.kv.MultiPutSpecImpl;
import com.vmware.vim.binding.impl.cis.kv.PutSpecImpl;
import com.vmware.vim.binding.impl.cis.kv.SearchClauseImpl;
import com.vmware.vim.query.client.kv.impl.ClientEntryImpl;
import com.vmware.vim.query.client.kv.impl.ClientValueImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ConversionHelper {
    private static final Log _log = LogFactory.getLog(ConversionHelper.class);
    private static final String VMODL_ALLOWED_CHARSET = "US-ASCII";

    ConversionHelper() {
    }

    static PutSpec getPutSpec(ValueMarshaller vm, ClientPutSpec cps) {
        PutSpecImpl ps = new PutSpecImpl();
        ps.setExpectedGeneration(Long.valueOf(cps.getExpectedGeneration()));
        ps.setExpectedLastWriter(cps.getExpectedLastWriter());
        ps.setKey(cps.getKey());
        ps.setValue(ConversionHelper.getServerValue(vm, cps.getValue()));
        ps.setOperationID(cps.getOperationID());
        ps.setCheckForCreate(Boolean.valueOf(cps.getCheckForCreate()));
        return ps;
    }

    static String getServerValue(ValueMarshaller vm, Object value) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        vm.marshal(value, bo);
        try {
            byte[] b2 = Base64.encodeBase64((byte[])bo.toByteArray(), (boolean)false);
            String retString = new String(b2, VMODL_ALLOWED_CHARSET);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Marshalling: Server value:" + retString + " Client value:" + value));
            }
            return retString;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static DeleteSpec getDeleteSpec(ClientDeleteSpec cps) {
        DeleteSpecImpl ds = new DeleteSpecImpl();
        ds.setExpectedGeneration(Long.valueOf(cps.getExpectedGeneration()));
        ds.setExpectedLastWriter(cps.getExpectedLastWriter());
        ds.setKey(cps.getKey());
        ds.setOperationID(cps.getOperationID());
        return ds;
    }

    static ClientValue getClientValue(ValueMarshaller vm, Value serverValue) {
        ByteArrayInputStream bis;
        if (serverValue == null) {
            return null;
        }
        ClientValueImpl cv = new ClientValueImpl();
        cv._lastWriter = serverValue.getLastWriterNodeID();
        cv._generation = serverValue.getGeneration();
        try {
            byte[] b2 = serverValue.getContent().getBytes(VMODL_ALLOWED_CHARSET);
            bis = new ByteArrayInputStream(Base64.decodeBase64((byte[])b2));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        cv._object = vm.unmarshal(bis);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unmarshalling: Server value:" + serverValue.getContent() + " Client value:" + cv.getValue()));
        }
        return cv;
    }

    static SearchClause getSearchClauseForPrefix(String kp) {
        SearchClauseImpl sc = new SearchClauseImpl();
        sc.setKeyPrefix(kp);
        return sc;
    }

    static MultiPutSpec getMultiPutSpec(Map<String, ValueMarshaller> marshallers, ValueMarshaller defaultMarshaller, Map<String, ClientPutSpec[]> spec) {
        MultiPutSpecImpl.BatchPutSpecImpl[] batch = new MultiPutSpecImpl.BatchPutSpecImpl[spec.size()];
        int i = 0;
        for (String provider : spec.keySet()) {
            ValueMarshaller vm = ConversionHelper.getValueMarshaller(marshallers, defaultMarshaller, provider);
            batch[i] = ConversionHelper.createBatchPutSpec(spec.get(provider), vm, provider);
            ++i;
        }
        MultiPutSpecImpl specImpl = new MultiPutSpecImpl();
        specImpl.setBatchPutSpec((MultiPutSpec.BatchPutSpec[])batch);
        return specImpl;
    }

    static MultiPutSpecImpl.BatchPutSpecImpl createBatchPutSpec(ClientPutSpec[] cpsa, ValueMarshaller vm, String provider) {
        MultiPutSpecImpl.BatchPutSpecImpl bpsi = new MultiPutSpecImpl.BatchPutSpecImpl();
        PutSpec[] psi = new PutSpec[cpsa.length];
        int j = 0;
        for (ClientPutSpec cps : cpsa) {
            psi[j++] = ConversionHelper.getPutSpec(vm, cps);
        }
        bpsi.setPuts(psi);
        bpsi.setProvider(provider);
        return bpsi;
    }

    static MultiDeleteSpec getMultiDeleteSpec(Map<String, ClientDeleteSpec[]> spec) {
        MultiDeleteSpecImpl.BatchDeleteSpecImpl[] batch = new MultiDeleteSpecImpl.BatchDeleteSpecImpl[spec.size()];
        int i = 0;
        for (String provider : spec.keySet()) {
            batch[i++] = ConversionHelper.createBatchDeleteSpec(spec.get(provider), provider);
        }
        MultiDeleteSpecImpl specImpl = new MultiDeleteSpecImpl();
        specImpl.setBatchDeleteSpec((MultiDeleteSpec.BatchDeleteSpec[])batch);
        return specImpl;
    }

    static MultiDeleteSpecImpl.BatchDeleteSpecImpl createBatchDeleteSpec(ClientDeleteSpec[] cdsa, String provider) {
        MultiDeleteSpecImpl.BatchDeleteSpecImpl bpsi = new MultiDeleteSpecImpl.BatchDeleteSpecImpl();
        DeleteSpec[] dsa = new DeleteSpec[cdsa.length];
        int j = 0;
        for (ClientDeleteSpec cps : cdsa) {
            dsa[j++] = ConversionHelper.getDeleteSpec(cps);
        }
        bpsi.setDeletes(dsa);
        bpsi.setProvider(provider);
        return bpsi;
    }

    static ValueMarshaller getValueMarshaller(Map<String, ValueMarshaller> marshallers, ValueMarshaller defaultMarshaller, String provider) {
        if (marshallers != null && marshallers.containsKey(provider)) {
            return marshallers.get(provider);
        }
        return defaultMarshaller;
    }

    public static List<ClientValue> getClientValues(ValueMarshaller vm, OptionalValue[] values) {
        ArrayList<ClientValue> ces = new ArrayList<ClientValue>(values.length);
        for (OptionalValue ov : values) {
            ces.add(ConversionHelper.getClientValue(vm, ov.getValue()));
        }
        return ces;
    }

    public static ConflictResolutionImpl getConflictResolution(ClientConflictResolution ccr, ValueMarshaller vm) {
        ConflictResolutionImpl cri = new ConflictResolutionImpl();
        cri.setKey(ccr.getKey());
        cri.setCorrectedValue(ConversionHelper.getServerValue(vm, ccr.getValue()));
        cri.setOperationID(ccr.getOperationID());
        cri.setExpectedGeneration(Long.valueOf(ccr.getExpectedGeneration()));
        cri.setExpectedLastWriter(ccr.getExpectedLastWriter());
        return cri;
    }

    public static List<ClientEntry> getClientEntries(ValueMarshaller vm, Entry[] entries) {
        if (entries == null || entries.length == 0) {
            return new ArrayList<ClientEntry>();
        }
        ArrayList<ClientEntry> ces = new ArrayList<ClientEntry>(entries.length);
        for (Entry entry : entries) {
            ClientEntryImpl ce = new ClientEntryImpl();
            ce.setKey(entry.getKey());
            ce.setValue(ConversionHelper.getClientValue(vm, entry.getValue()));
            ces.add(ce);
        }
        return ces;
    }
}

