/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.kv.impl;

import com.vmware.cis.kv.client.AuthenticationStrategy;
import com.vmware.cis.kv.client.ClientManager;
import com.vmware.cis.kv.client.KVClient;
import com.vmware.cis.kv.client.KVClientFactory;
import com.vmware.cis.kv.client.exception.KVException;
import com.vmware.vim.binding.cis.kv.Manager;
import com.vmware.vim.binding.cis.kv.authentication.SessionManager;
import com.vmware.vim.binding.cis.kv.fault.NotAuthenticatedFault;
import com.vmware.vim.binding.cis.kv.version.internal.version1;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.query.client.kv.impl.ClientManagerImpl;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.RequestRetryCallback;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class KVClientImpl
implements KVClient {
    private static final Log _log;
    private URI _serverUri;
    private String _vmomiContext = "/vmomi/sdk/";
    private static final KVClientFactory.Configuration DEFAULT_CONFIGURATION;
    private Client _vmomiDsClient;
    private List<ClientManager> _clientManagerList;
    private boolean _closed = false;
    private AuthenticationStrategy _authStrategy;

    @Deprecated
    public KVClientImpl(URI uri, HttpConfiguration config, AuthenticationStrategy as, Class<?> version) {
        this._serverUri = uri;
        this._authStrategy = as;
        this._clientManagerList = Collections.synchronizedList(new ArrayList());
        this.createVmomiClient(config, version);
    }

    public KVClientImpl(URI uri, KVClientFactory.Configuration config) {
        this._serverUri = uri;
        if (config == null) {
            config = DEFAULT_CONFIGURATION;
        }
        this._authStrategy = config.getAuthenticationStrategy();
        HttpClientConfiguration clientConfig = config.getClientConfig();
        Class<?> version = config.getVersion();
        this._clientManagerList = Collections.synchronizedList(new ArrayList());
        this.createVmomiClient(clientConfig, version);
    }

    @Override
    public Manager getKeyValueManager() {
        ManagedObjectReference reference = new ManagedObjectReference("KVManager", "ds-kv-mgr");
        return (Manager)this._vmomiDsClient.createStub(Manager.class, reference);
    }

    @Override
    public ClientManager getKeyValueClientManager() {
        ClientManagerImpl clientManager = new ClientManagerImpl(this);
        clientManager.setServerManager(this.getKeyValueManager());
        this._clientManagerList.add(clientManager);
        return clientManager;
    }

    @Override
    public void loginBySamlToken(SamlToken samlToken, PrivateKey privateKey) throws KVException {
        ManagedObjectReference reference = new ManagedObjectReference("KVSessionManager", "kvSessionManager");
        SessionManager authManager = (SessionManager)this._vmomiDsClient.createStub(SessionManager.class, reference);
        BlockingFuture f = new BlockingFuture();
        RequestContextImpl requestContext = new RequestContextImpl();
        requestContext.setSignInfo((SignInfo)new SignInfoImpl(privateKey, samlToken));
        ((Stub)authManager)._setRequestContext((RequestContext)requestContext);
        authManager.loginBySamlToken((Future)f);
        try {
            f.get();
        }
        catch (Exception e) {
            throw new KVException(e);
        }
    }

    @Override
    public void login(String username, String password) throws KVException {
        ManagedObjectReference reference = new ManagedObjectReference("KVSessionManager", "kvSessionManager");
        SessionManager authManager = (SessionManager)this._vmomiDsClient.createStub(SessionManager.class, reference);
        BlockingFuture f = new BlockingFuture();
        authManager.login(username, password, (Future)f);
        try {
            f.get();
        }
        catch (Exception e) {
            throw new KVException(e);
        }
    }

    @Override
    public boolean logout() {
        ManagedObjectReference reference = new ManagedObjectReference("KVSessionManager", "kvSessionManager");
        SessionManager authManager = (SessionManager)this._vmomiDsClient.createStub(SessionManager.class, reference);
        BlockingFuture f = new BlockingFuture();
        authManager.logout((Future)f);
        try {
            return (Boolean)f.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this._closed = true;
        List<ClientManager> list = this._clientManagerList;
        synchronized (list) {
            for (ClientManager clientMgr : this._clientManagerList) {
                clientMgr.close();
            }
            this._clientManagerList.clear();
        }
        if (!this.logout()) {
            _log.debug((Object)"not logging out");
        }
        this._vmomiDsClient.shutdown();
    }

    protected void reportClientMgrClosed(ClientManager clientMgr) {
        if (!this._closed) {
            this._clientManagerList.remove(clientMgr);
        }
    }

    private void createVmomiClient(HttpClientConfiguration httpClientConfig, Class<?> version) {
        if (httpClientConfig == null) {
            this.createVmomiClient((HttpConfiguration)null, version);
            return;
        }
        this.createVmomiClient(httpClientConfig, httpClientConfig.getHttpConfiguration(), version);
    }

    private void createVmomiClient(HttpConfiguration httpConfig, Class<?> version) {
        HttpClientConfiguration httpClientConfig = HttpClientConfiguration.Factory.newInstance();
        this.createVmomiClient(httpClientConfig, httpConfig, version);
    }

    private void createVmomiClient(HttpClientConfiguration httpClientConfig, HttpConfiguration httpConfig, Class<?> version) {
        URI vmomiUri;
        try {
            String uri = this._serverUri.toString();
            while (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            vmomiUri = new URI(uri + this._vmomiContext);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        if (httpConfig == null) {
            httpConfig = HttpConfiguration.Factory.newInstance();
        }
        if (httpConfig.getThumbprintVerifier() == null) {
            httpConfig.setThumbprintVerifier(ThumbprintVerifier.Factory.createAllowAllThumbprintVerifier());
        }
        httpClientConfig.setHttpConfiguration(httpConfig);
        final KVClientImpl thisClient = this;
        if (this._authStrategy != null) {
            httpClientConfig.setRequestRetryCallback(new RequestRetryCallback(){

                public boolean retry(Exception exception, InvocationContext context, int retrycount) {
                    if (!(exception instanceof NotAuthenticatedFault)) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Cannot handle server exception: " + exception));
                        }
                        return false;
                    }
                    if (retrycount > KVClientImpl.this._authStrategy.getMaxLoginAttempts()) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Unable to login to server after retries:" + retrycount));
                        }
                        return false;
                    }
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Calling caller-defined login method");
                    }
                    KVClientImpl.this._authStrategy.login(thisClient);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Done calling caller-defined login method");
                    }
                    return true;
                }
            });
        }
        if (version == null) {
            version = version1.class;
        }
        this._vmomiDsClient = Client.Factory.createClient((URI)vmomiUri, version, (ClientConfiguration)httpClientConfig);
    }

    @Override
    public URI getServerUri() {
        return URI.create(this._serverUri.toString());
    }

    static {
        block2: {
            _log = LogFactory.getLog(KVClientImpl.class);
            DEFAULT_CONFIGURATION = new KVClientFactory.DefaultConfiguration();
            try {
                VmodlContext.initContext((String[])new String[]{"com.vmware.vim.binding.cis.kv"});
            }
            catch (IllegalArgumentException e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("InitContext threw IllegalArgumentException:" + e.getMessage()));
                _log.warn((Object)"This will happen if the context com.vmware.vim.binding.cis.kvis already initialized");
            }
        }
    }
}

