/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.pipeline.internal;

import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.pipeline.internal.StandardPipeline;
import org.eclipse.virgo.kernel.install.pipeline.stage.PipelineStage;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyBundleDependenciesException;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.util.common.GraphNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CompensatingPipeline
extends StandardPipeline {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PipelineStage compensation;

    public CompensatingPipeline(PipelineStage compensation) {
        this.compensation = compensation;
    }

    @Override
    protected void doProcessGraph(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment) throws DeploymentException, UnableToSatisfyBundleDependenciesException {
        try {
            super.doProcessGraph(installGraph, installEnvironment);
        }
        catch (DeploymentException de) {
            this.compensate(installGraph, installEnvironment, (Exception)((Object)de));
            throw de;
        }
        catch (UnableToSatisfyBundleDependenciesException utsbde) {
            this.compensate(installGraph, installEnvironment, (Exception)((Object)utsbde));
            throw utsbde;
        }
        catch (RuntimeException re) {
            this.compensate(installGraph, installEnvironment, re);
            throw re;
        }
    }

    private void compensate(GraphNode<InstallArtifact> installGraph, InstallEnvironment installEnvironment, Exception e) {
        try {
            if (!(e instanceof DeploymentException) || !((DeploymentException)((Object)e)).isDiagnosed()) {
                installEnvironment.getInstallLog().logFailure((LogEvent)DeployerLogEvents.INSTALL_FAILURE, e, new Object[0]);
            } else {
                installEnvironment.getInstallLog().logFailure((LogEvent)DeployerLogEvents.INSTALL_FAILURE, null, new Object[0]);
            }
            this.compensation.process(installGraph, installEnvironment);
        }
        catch (Exception ex) {
            this.logger.warn(String.format("exception thrown while compensating for '%s'", e.getMessage()), (Throwable)ex);
        }
    }
}

