/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.commands;

import com.vmware.automatic.plugin.registration.commands.utils.PrintHelper;
import com.vmware.automatic.plugin.registration.commands.utils.TrustAllTrustManager;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class PluginCmd {
    private static final ManagedObjectReference SVC_INST_REF = new ManagedObjectReference();
    private static final String SVC_INST_NAME = "ServiceInstance";
    protected String _url;
    protected String _username;
    protected String _password;
    protected String _key = "";
    protected CommandLine _commandLine;
    protected ManagedObjectReference _extensionManager;
    protected VimPortType _vimPort;
    protected String _action = "";
    protected String _errorMessage = "";
    private VimService _vimService;
    private ServiceContent _serviceContent;
    private boolean _isConnected = false;

    public Options getPluginOpts() {
        Options options = new Options();
        options.addOption(Option.builder("action").hasArg().argName("action").desc("registerPlugin, unregisterPlugin, updatePlugin, isPluginRegistered").required().build());
        options.addOption(Option.builder("url").hasArg().argName("vc url").desc("vCenter server URL").required().build());
        options.addOption(Option.builder("u").longOpt("username").hasArg().argName("vc user").desc("vCenter server username").required().build());
        options.addOption(Option.builder("p").longOpt("password").hasArg().argName("vc pass").desc("vCenter server password").required().build());
        options.addOption(Option.builder("k").longOpt("key").hasArg().argName("key").desc("Plugin key").required().build());
        return options;
    }

    public void execute(String[] stringArray) {
        this.populateFields(stringArray);
        try {
            this.connect();
            this.doExecute();
        }
        catch (Exception exception) {
            if (exception.getMessage() != null) {
                System.out.println(exception.getMessage());
            }
        }
        finally {
            try {
                this.disconnect();
            }
            catch (SOAPFaultException sOAPFaultException) {
                PrintHelper.printSoapFaultException(sOAPFaultException);
            }
            catch (Exception exception) {
                System.out.println("Failed to disconnect - " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected void populateFields(String[] stringArray) {
        Options options = this.getPluginOpts();
        DefaultParser defaultParser = new DefaultParser();
        try {
            this._commandLine = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            new HelpFormatter().printHelp(this._action, this._errorMessage, options, "\n" + parseException.getMessage(), true);
            return;
        }
        this._url = this._commandLine.getOptionValue("url");
        this._username = this._commandLine.getOptionValue("username");
        this._password = this._commandLine.getOptionValue("password");
        this._key = this._commandLine.getOptionValue("key");
    }

    private void connect() throws Exception {
        if (!this._isConnected) {
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
            TrustAllTrustManager.trustAllHttpsCertificates();
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            SVC_INST_REF.setType(SVC_INST_NAME);
            SVC_INST_REF.setValue(SVC_INST_NAME);
            this._vimService = new VimService();
            this._vimPort = this._vimService.getVimPort();
            Map map = ((BindingProvider)this._vimPort).getRequestContext();
            map.put("javax.xml.ws.service.endpoint.address", this._url);
            map.put("javax.xml.ws.session.maintain", true);
            this._serviceContent = this._vimPort.retrieveServiceContent(SVC_INST_REF);
            this._vimPort.login(this._serviceContent.getSessionManager(), this._username, this._password, null);
            this._isConnected = true;
            this._extensionManager = this._serviceContent.getExtensionManager();
        }
    }

    private void disconnect() throws Exception {
        if (this._isConnected) {
            this._vimPort.logout(this._serviceContent.getSessionManager());
        }
        this._isConnected = false;
    }

    protected abstract void doExecute();
}

