/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.commands;

import com.vmware.automatic.plugin.registration.commands.PluginCmd;
import com.vmware.automatic.plugin.registration.commands.utils.PrintHelper;
import com.vmware.vim25.Description;
import com.vmware.vim25.Extension;
import com.vmware.vim25.ExtensionClientInfo;
import com.vmware.vim25.ExtensionResourceInfo;
import com.vmware.vim25.ExtensionServerInfo;
import com.vmware.vim25.KeyValue;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class RegisterPluginCmd
extends PluginCmd {
    private static final String DEFAULT_PLUGIN_TYPE = "vsphere-client-serenity";
    private static final String HTTPS_PROTOCOL = "HTTPS";
    private static final String ADMIN_EMAIL = "noreply@vmware.com";
    private String _pluginUrl;
    private String _name;
    private String _summary;
    private String _version;
    private String _company;
    private boolean _showInSolutionManager;
    private String _serverThumbprint;

    public RegisterPluginCmd() {
        this._action = "-action registerPlugin";
        this._errorMessage = "Register plugin to the VC";
    }

    @Override
    public Options getPluginOpts() {
        Options options = super.getPluginOpts();
        options.addOption(Option.builder("pu").longOpt("pluginUrl").hasArg().argName("plugin url").desc("Url from where the plugin will be downloaded").required().build());
        options.addOption(Option.builder("v").longOpt("version").hasArg().argName("version").desc("Plugin version").required().build());
        options.addOption(Option.builder("n").longOpt("name").hasArg().argName("name").desc("Plugin name").required(false).build());
        options.addOption(Option.builder("s").longOpt("summary").hasArg().argName("summary").desc("Plugin summary").required(false).build());
        options.addOption(Option.builder("c").longOpt("company").hasArg().argName("company").desc("Plugin company").required(false).build());
        options.addOption(Option.builder("st").longOpt("serverThumbprint").hasArg().argName("server thumbprint").desc("Thumbprint of the server from which the plugin will be downloaded.").required(false).build());
        options.addOption(Option.builder("show").longOpt("showInSolutionManager").desc("If specified the plugin will be shown in Administration panel, Solutions plug-in list").required(false).build());
        return options;
    }

    @Override
    protected void populateFields(String[] stringArray) {
        super.populateFields(stringArray);
        if (this._commandLine != null) {
            String string;
            String string2;
            String string3;
            this._pluginUrl = this._commandLine.getOptionValue("pu");
            String string4 = this._commandLine.getOptionValue("n");
            if (string4 != null) {
                this._name = string4;
            }
            if ((string3 = this._commandLine.getOptionValue("s")) != null) {
                this._summary = string3;
            }
            if ((string2 = this._commandLine.getOptionValue("v")) != null) {
                this._version = string2;
            }
            if ((string = this._commandLine.getOptionValue("c")) != null) {
                this._company = string;
            }
            this._showInSolutionManager = this._commandLine.hasOption("show");
            String string5 = this._commandLine.getOptionValue("st");
            if (string5 != null) {
                this._serverThumbprint = string5;
            }
        }
    }

    @Override
    protected void doExecute() {
        Object object;
        Extension extension = new Extension();
        Description description = new Description();
        description.setLabel(this._name != null ? this._name : "");
        description.setSummary(this._summary != null ? this._summary : "");
        extension.setKey(this._key);
        extension.setVersion(this._version != null ? this._version : "");
        extension.setCompany(this._company);
        extension.setDescription(description);
        ExtensionClientInfo extensionClientInfo = new ExtensionClientInfo();
        extensionClientInfo.setVersion(this._version != null ? this._version : "");
        extensionClientInfo.setCompany(this._company != null ? this._company : "");
        extensionClientInfo.setDescription(description);
        extensionClientInfo.setType(DEFAULT_PLUGIN_TYPE);
        extensionClientInfo.setUrl(this._pluginUrl);
        extension.getClient().add(extensionClientInfo);
        ExtensionResourceInfo extensionResourceInfo = new ExtensionResourceInfo();
        extensionResourceInfo.setLocale("en_US");
        extensionResourceInfo.setModule("name");
        KeyValue keyValue = new KeyValue();
        keyValue.setKey("name");
        keyValue.setValue(this._name != null ? this._name : "");
        extensionResourceInfo.getData().add(keyValue);
        extension.getResourceList().add(extensionResourceInfo);
        if (this._pluginUrl.startsWith(HTTPS_PROTOCOL.toLowerCase())) {
            if (this._serverThumbprint == null) {
                PrintHelper.printHelp(this.getPluginOpts(), "Missing required option: -serverThumbprint required argument when -pluginUrl is https");
                return;
            }
            object = new ExtensionServerInfo();
            ((ExtensionServerInfo)object).getAdminEmail().add(ADMIN_EMAIL);
            ((ExtensionServerInfo)object).setCompany(this._company != null ? this._company : "");
            ((ExtensionServerInfo)object).setDescription(description);
            ((ExtensionServerInfo)object).setType(HTTPS_PROTOCOL);
            ((ExtensionServerInfo)object).setServerThumbprint(this._serverThumbprint);
            ((ExtensionServerInfo)object).setUrl(this._pluginUrl);
            extension.getServer().add((ExtensionServerInfo)object);
        } else {
            System.out.println("INFO: Not using https for your plugin URL is OK for testing but not recommended for production.\nUsers will have to include the flag allowHttp=true in their vSphere Client webclient.properties otherwise the http URL will be ignored");
        }
        extension.setShownInSolutionManager(this._showInSolutionManager);
        object = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)object);
            extension.setLastHeartbeatTime(xMLGregorianCalendar);
            this._vimPort.registerExtension(this._extensionManager, extension);
            System.out.println("Plugin: " + this._key + " has been successfully registered in vCenter <" + this._url + ">.");
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            System.out.println("Exception while registering plugin " + this._key);
            runtimeFaultFaultMsg.printStackTrace();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            System.out.println("Exception while registering plugin" + this._key);
            datatypeConfigurationException.printStackTrace();
        }
    }
}

