/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.cis.bundles.impl;

import com.vmware.vapi.cis.bundles.RequestAuthenticator;
import com.vmware.vapi.cis.bundles.ResourceBundleLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ResourceBundleServlet.class);
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private final ResourceBundleLocator locator;
    private final RequestAuthenticator authenticator;

    public ResourceBundleServlet(ResourceBundleLocator locator, RequestAuthenticator authenticator) {
        Validate.notNull((Object)locator);
        this.locator = locator;
        this.authenticator = authenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("doGet: Entering (%s)", httpServletRequest.getRequestURI()));
        }
        if (this.authenticator != null && !this.authenticator.authenticateRequest(httpServletRequest)) {
            logger.error("doGet: request authentication failed for client " + this.getRemoteClientInfo(httpServletRequest));
            httpServletResponse.setStatus(401);
            return;
        }
        String contentType = this.locator.getContentType();
        if (contentType == null) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        httpServletResponse.setContentType(contentType);
        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=\"" + this.locator.getName() + "\"");
        if (this.locator.getLength() != -1L) {
            httpServletResponse.setHeader("Content-Length", String.valueOf(this.locator.getLength()));
        }
        InputStream is = this.locator.getInputStream();
        try {
            IOUtils.copy((InputStream)is, (OutputStream)httpServletResponse.getOutputStream());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("doGet: Leaving (%s)", httpServletRequest.getRequestURI()));
        }
    }

    private String getRemoteClientInfo(HttpServletRequest request) {
        String info = request.getHeader("X-Forwarded-For");
        if (info == null) {
            info = request.getRemoteAddr();
        }
        return info;
    }
}

