/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.cis.bundles.impl;

import com.vmware.vapi.cis.bundles.RequestAuthenticator;
import com.vmware.vim.sso.http.AuthException;
import com.vmware.vim.sso.http.AuthVerifier;
import com.vmware.vim.sso.http.AuthVerifierFactory;
import com.vmware.vim.sso.http.Request;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSsoAuthenticator
implements RequestAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(RestSsoAuthenticator.class);
    public static final String HTTP_AUTHORIZATION = "Authorization";
    private static final int CLOCK_TOLERANCE_SEC = 0;
    private static final int MAX_REQUEST_AGE_SEC = 3600;
    private final List<X509Certificate> certificates;

    public RestSsoAuthenticator(List<X509Certificate> certificates) {
        this.certificates = certificates;
    }

    @Override
    public boolean authenticateRequest(HttpServletRequest request) throws IOException {
        AuthVerifier verifier = AuthVerifierFactory.instance((X509Certificate[])this.certificates.toArray(new X509Certificate[this.certificates.size()]), (int)0, (int)3600);
        String[] authHeaders = this.deserializeAuthToken(request);
        if (authHeaders == null) {
            logger.warn("Request not authenticated");
            return false;
        }
        try {
            verifier.verifyToken((Request)new SsoRequest(request), authHeaders);
        }
        catch (AuthException e) {
            logger.warn("Request not authenticated", (Throwable)e);
            return false;
        }
        catch (IllegalArgumentException e) {
            logger.warn("Request not authenticated", (Throwable)e);
            return false;
        }
        catch (IllegalStateException e) {
            logger.warn("Request not authenticated", (Throwable)e);
            return false;
        }
        return true;
    }

    private String[] deserializeAuthToken(HttpServletRequest request) {
        Enumeration authHeaders = request.getHeaders(HTTP_AUTHORIZATION);
        if (authHeaders == null || !authHeaders.hasMoreElements()) {
            return null;
        }
        String[] result = Collections.list(authHeaders).toArray(new String[0]);
        return result;
    }

    private static class SsoRequest
    implements Request {
        private HttpServletRequest request;
        private URL requestUrl;
        private InputStream body;

        SsoRequest(HttpServletRequest request) throws IOException {
            this.request = request;
            this.body = request.getInputStream();
            this.requestUrl = new URL(request.getRequestURL().toString());
        }

        public Request.Method method() {
            return Request.Method.valueOf((String)this.request.getMethod());
        }

        public String requestURI() {
            return this.requestUrl.getPath();
        }

        public String hostName() {
            return this.requestUrl.getHost();
        }

        public int port() {
            int port = this.requestUrl.getPort();
            if (port == -1) {
                port = this.requestUrl.getDefaultPort();
            }
            return port;
        }

        public InputStream payload() {
            return this.body;
        }
    }
}

