/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cls.util;

import com.vmware.content.LibraryDefinitions;
import com.vmware.content.SubscribedLibraryDefinitions;
import com.vmware.content.TypeDefinitions;
import com.vmware.content.library.ItemDefinitions;
import com.vmware.content.library.StructDefinitions;
import com.vmware.content.library.item.StorageDefinitions;
import com.vmware.content.library.item.downloadsession.FileDefinitions;
import com.vmware.vapi.bindings.type.StructType;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class StructTypeUtil {
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> mapping) {
        Validate.notNull(mapping);
        StructTypeUtil.add(mapping, "com.vmware.content.configuration_model", com.vmware.content.StructDefinitions.configurationModel);
        StructTypeUtil.add(mapping, "com.vmware.content.library_model", com.vmware.content.StructDefinitions.libraryModel);
        StructTypeUtil.add(mapping, "com.vmware.content.library.find_spec", LibraryDefinitions.findSpec);
        StructTypeUtil.add(mapping, "com.vmware.content.subscribed_library.probe_result", SubscribedLibraryDefinitions.probeResult);
        StructTypeUtil.add(mapping, "com.vmware.content.type.info", TypeDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item_model", StructDefinitions.itemModel);
        StructTypeUtil.add(mapping, "com.vmware.content.library.optimization_info", StructDefinitions.optimizationInfo);
        StructTypeUtil.add(mapping, "com.vmware.content.library.publish_info", StructDefinitions.publishInfo);
        StructTypeUtil.add(mapping, "com.vmware.content.library.storage_backing", StructDefinitions.storageBacking);
        StructTypeUtil.add(mapping, "com.vmware.content.library.subscription_info", StructDefinitions.subscriptionInfo);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.find_spec", ItemDefinitions.findSpec);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.download_session_model", com.vmware.content.library.item.StructDefinitions.downloadSessionModel);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.transfer_endpoint", com.vmware.content.library.item.StructDefinitions.transferEndpoint);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.update_session_model", com.vmware.content.library.item.StructDefinitions.updateSessionModel);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.file.checksum_info", com.vmware.content.library.item.FileDefinitions.checksumInfo);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.file.info", com.vmware.content.library.item.FileDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.storage.info", StorageDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.downloadsession.file.info", FileDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.updatesession.file.add_spec", com.vmware.content.library.item.updatesession.FileDefinitions.addSpec);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.updatesession.file.info", com.vmware.content.library.item.updatesession.FileDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.updatesession.file.validation_error", com.vmware.content.library.item.updatesession.FileDefinitions.validationError);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.updatesession.file.validation_result", com.vmware.content.library.item.updatesession.FileDefinitions.validationResult);
        StructTypeUtil.add(mapping, "com.vmware.content.library.item.updatesession.file.probe_result", com.vmware.content.library.item.updatesession.FileDefinitions.probeResult);
    }

    private static void add(Map<String, StructType> mapping, String key, StructType structType) {
        if (mapping.containsKey(key)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + key + ". Unable to populate the map.");
        }
        mapping.put(key, structType);
    }
}

