/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content;

import com.vmware.content.LibraryModel;
import com.vmware.content.LocalLibraryDefinitions;
import com.vmware.content.LocalLibrarySyncProvider;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class LocalLibrarySyncApiInterface
extends ApiInterfaceSkeleton {
    private LocalLibrarySyncProvider impl;

    public LocalLibrarySyncApiInterface() {
        this((Class<? extends LocalLibrarySyncProvider>)null);
    }

    public LocalLibrarySyncApiInterface(Class<? extends LocalLibrarySyncProvider> implClass) {
        this((LocalLibrarySyncProvider)LocalLibrarySyncApiInterface.createImplInstance(implClass, (String)"com.vmware.content.impl.LocalLibraryImpl", LocalLibrarySyncProvider.class));
    }

    public LocalLibrarySyncApiInterface(LocalLibrarySyncProvider impl) {
        super("com.vmware.content.local_library");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(LocalLibrarySyncApiInterface.this.getIdentifier(), "update", LocalLibraryDefinitions.__updateInput, LocalLibraryDefinitions.__updateOutput, LocalLibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceBusy;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.concurrentChange;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LocalLibraryDefinitions.__updateInput, LocalLibrarySyncApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            LibraryModel updateSpec = (LibraryModel)extr.valueForField("update_spec");
            try {
                LocalLibrarySyncApiInterface.this.impl.update(libraryId, updateSpec, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(LocalLibrarySyncApiInterface.this.getIdentifier(), "list", LocalLibraryDefinitions.__listInput, LocalLibraryDefinitions.__listOutput, LocalLibrarySyncApiInterface.this.getTypeConverter(), null, false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)LocalLibrarySyncApiInterface.this.getTypeConverter().convertToVapi(LocalLibrarySyncApiInterface.this.impl.list(invocationContext), LocalLibraryDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(LocalLibrarySyncApiInterface.this.getIdentifier(), "get", LocalLibraryDefinitions.__getInput, LocalLibraryDefinitions.__getOutput, LocalLibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LocalLibraryDefinitions.__getInput, LocalLibrarySyncApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)LocalLibrarySyncApiInterface.this.getTypeConverter().convertToVapi((Object)LocalLibrarySyncApiInterface.this.impl.get(libraryId, invocationContext), LocalLibraryDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(LocalLibrarySyncApiInterface.this.getIdentifier(), "delete", LocalLibraryDefinitions.__deleteInput, LocalLibraryDefinitions.__deleteOutput, LocalLibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LocalLibraryDefinitions.__deleteInput, LocalLibrarySyncApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            try {
                LocalLibrarySyncApiInterface.this.impl.delete(libraryId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(LocalLibrarySyncApiInterface.this.getIdentifier(), "create", LocalLibraryDefinitions.__createInput, LocalLibraryDefinitions.__createOutput, LocalLibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unsupported;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LocalLibraryDefinitions.__createInput, LocalLibrarySyncApiInterface.this.getTypeConverter());
            String clientToken = (String)extr.valueForField("client_token");
            LibraryModel createSpec = (LibraryModel)extr.valueForField("create_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)LocalLibrarySyncApiInterface.this.getTypeConverter().convertToVapi((Object)LocalLibrarySyncApiInterface.this.impl.create(clientToken, createSpec, invocationContext), LocalLibraryDefinitions.__createOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

