/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library;

import com.vmware.content.library.ItemDefinitions;
import com.vmware.content.library.ItemModel;
import com.vmware.content.library.ItemProvider;
import com.vmware.content.library.ItemTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class ItemApiInterface
extends ApiInterfaceSkeleton {
    private ItemProvider impl;

    public ItemApiInterface() {
        this((Class<? extends ItemProvider>)null);
    }

    public ItemApiInterface(Class<? extends ItemProvider> implClass) {
        this((ItemProvider)ItemApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.impl.ItemImpl", ItemProvider.class));
    }

    public ItemApiInterface(ItemProvider impl) {
        super("com.vmware.content.library.item");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new CopyApiMethod());
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new FindApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(ItemApiInterface.this.getIdentifier(), "update", ItemDefinitions.__updateInput, ItemDefinitions.__updateOutput, ItemApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__updateInput, ItemApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            ItemModel updateSpec = (ItemModel)extr.valueForField("update_spec");
            ItemApiInterface.this.impl.update(libraryItemId, updateSpec, (AsyncContext<Void>)new AsyncContextImpl(ItemApiInterface.this.getTypeConverter(), ItemDefinitions.__updateOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class FindApiMethod
    extends ApiMethodSkeleton {
        public FindApiMethod() {
            super(ItemApiInterface.this.getIdentifier(), "find", ItemDefinitions.__findInput, ItemDefinitions.__findOutput, ItemApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__findInput, ItemApiInterface.this.getTypeConverter());
            ItemTypes.FindSpec spec = (ItemTypes.FindSpec)extr.valueForField("spec");
            ItemApiInterface.this.impl.find(spec, (AsyncContext<List<String>>)new AsyncContextImpl(ItemApiInterface.this.getTypeConverter(), ItemDefinitions.__findOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(ItemApiInterface.this.getIdentifier(), "list", ItemDefinitions.__listInput, ItemDefinitions.__listOutput, ItemApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__listInput, ItemApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            ItemApiInterface.this.impl.list(libraryId, (AsyncContext<List<String>>)new AsyncContextImpl(ItemApiInterface.this.getTypeConverter(), ItemDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(ItemApiInterface.this.getIdentifier(), "get", ItemDefinitions.__getInput, ItemDefinitions.__getOutput, ItemApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__getInput, ItemApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            ItemApiInterface.this.impl.get(libraryItemId, (AsyncContext<ItemModel>)new AsyncContextImpl(ItemApiInterface.this.getTypeConverter(), ItemDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(ItemApiInterface.this.getIdentifier(), "delete", ItemDefinitions.__deleteInput, ItemDefinitions.__deleteOutput, ItemApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__deleteInput, ItemApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            ItemApiInterface.this.impl.delete(libraryItemId, (AsyncContext<Void>)new AsyncContextImpl(ItemApiInterface.this.getTypeConverter(), ItemDefinitions.__deleteOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(ItemApiInterface.this.getIdentifier(), "create", ItemDefinitions.__createInput, ItemDefinitions.__createOutput, ItemApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__createInput, ItemApiInterface.this.getTypeConverter());
            String clientToken = (String)extr.valueForField("client_token");
            ItemModel createSpec = (ItemModel)extr.valueForField("create_spec");
            ItemApiInterface.this.impl.create(clientToken, createSpec, (AsyncContext<String>)new AsyncContextImpl(ItemApiInterface.this.getTypeConverter(), ItemDefinitions.__createOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CopyApiMethod
    extends ApiMethodSkeleton {
        public CopyApiMethod() {
            super(ItemApiInterface.this.getIdentifier(), "copy", ItemDefinitions.__copyInput, ItemDefinitions.__copyOutput, ItemApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__copyInput, ItemApiInterface.this.getTypeConverter());
            String clientToken = (String)extr.valueForField("client_token");
            String sourceLibraryItemId = (String)extr.valueForField("source_library_item_id");
            ItemModel destinationCreateSpec = (ItemModel)extr.valueForField("destination_create_spec");
            ItemApiInterface.this.impl.copy(clientToken, sourceLibraryItemId, destinationCreateSpec, (AsyncContext<String>)new AsyncContextImpl(ItemApiInterface.this.getTypeConverter(), ItemDefinitions.__copyOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

