/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library;

import com.vmware.content.library.SubscribedItemDefinitions;
import com.vmware.content.library.SubscribedItemProvider;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class SubscribedItemApiInterface
extends ApiInterfaceSkeleton {
    private SubscribedItemProvider impl;

    public SubscribedItemApiInterface() {
        this((Class<? extends SubscribedItemProvider>)null);
    }

    public SubscribedItemApiInterface(Class<? extends SubscribedItemProvider> implClass) {
        this((SubscribedItemProvider)SubscribedItemApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.impl.SubscribedItemImpl", SubscribedItemProvider.class));
    }

    public SubscribedItemApiInterface(SubscribedItemProvider impl) {
        super("com.vmware.content.library.subscribed_item");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new EvictApiMethod());
        this.registerMethod((ApiMethod)new SyncApiMethod());
    }

    private class SyncApiMethod
    extends ApiMethodSkeleton {
        public SyncApiMethod() {
            super(SubscribedItemApiInterface.this.getIdentifier(), "sync", SubscribedItemDefinitions.__syncInput, SubscribedItemDefinitions.__syncOutput, SubscribedItemApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedItemDefinitions.__syncInput, SubscribedItemApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            boolean forceSyncContent = (Boolean)extr.valueForField("force_sync_content");
            SubscribedItemApiInterface.this.impl.sync(libraryItemId, forceSyncContent, (AsyncContext<Void>)new AsyncContextImpl(SubscribedItemApiInterface.this.getTypeConverter(), SubscribedItemDefinitions.__syncOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class EvictApiMethod
    extends ApiMethodSkeleton {
        public EvictApiMethod() {
            super(SubscribedItemApiInterface.this.getIdentifier(), "evict", SubscribedItemDefinitions.__evictInput, SubscribedItemDefinitions.__evictOutput, SubscribedItemApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementConfiguration;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedItemDefinitions.__evictInput, SubscribedItemApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            SubscribedItemApiInterface.this.impl.evict(libraryItemId, (AsyncContext<Void>)new AsyncContextImpl(SubscribedItemApiInterface.this.getTypeConverter(), SubscribedItemDefinitions.__evictOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

