/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item.downloadsession;

import com.vmware.content.library.item.downloadsession.FileDefinitions;
import com.vmware.content.library.item.downloadsession.FileSyncProvider;
import com.vmware.content.library.item.downloadsession.FileTypes;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class FileSyncApiInterface
extends ApiInterfaceSkeleton {
    private FileSyncProvider impl;

    public FileSyncApiInterface() {
        this((Class<? extends FileSyncProvider>)null);
    }

    public FileSyncApiInterface(Class<? extends FileSyncProvider> implClass) {
        this((FileSyncProvider)FileSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.item.downloadsession.impl.FileImpl", FileSyncProvider.class));
    }

    public FileSyncApiInterface(FileSyncProvider impl) {
        super("com.vmware.content.library.item.downloadsession.file");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new PrepareApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(FileSyncApiInterface.this.getIdentifier(), "get", FileDefinitions.__getInput, FileDefinitions.__getOutput, FileSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__getInput, FileSyncApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            String fileName = (String)extr.valueForField("file_name");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)FileSyncApiInterface.this.getTypeConverter().convertToVapi((Object)FileSyncApiInterface.this.impl.get(downloadSessionId, fileName, invocationContext), FileDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class PrepareApiMethod
    extends ApiMethodSkeleton {
        public PrepareApiMethod() {
            super(FileSyncApiInterface.this.getIdentifier(), "prepare", FileDefinitions.__prepareInput, FileDefinitions.__prepareOutput, FileSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__prepareInput, FileSyncApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            String fileName = (String)extr.valueForField("file_name");
            FileTypes.EndpointType endpointType = (FileTypes.EndpointType)((Object)extr.valueForField("endpoint_type"));
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)FileSyncApiInterface.this.getTypeConverter().convertToVapi((Object)FileSyncApiInterface.this.impl.prepare(downloadSessionId, fileName, endpointType, invocationContext), FileDefinitions.__prepareOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(FileSyncApiInterface.this.getIdentifier(), "list", FileDefinitions.__listInput, FileDefinitions.__listOutput, FileSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__listInput, FileSyncApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)FileSyncApiInterface.this.getTypeConverter().convertToVapi(FileSyncApiInterface.this.impl.list(downloadSessionId, invocationContext), FileDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

