/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item.updatesession;

import com.vmware.content.library.item.TransferEndpoint;
import com.vmware.content.library.item.updatesession.FileDefinitions;
import com.vmware.content.library.item.updatesession.FileSyncProvider;
import com.vmware.content.library.item.updatesession.FileTypes;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class FileSyncApiInterface
extends ApiInterfaceSkeleton {
    private FileSyncProvider impl;

    public FileSyncApiInterface() {
        this((Class<? extends FileSyncProvider>)null);
    }

    public FileSyncApiInterface(Class<? extends FileSyncProvider> implClass) {
        this((FileSyncProvider)FileSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.item.updatesession.impl.FileImpl", FileSyncProvider.class));
    }

    public FileSyncApiInterface(FileSyncProvider impl) {
        super("com.vmware.content.library.item.updatesession.file");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new ValidateApiMethod());
        this.registerMethod((ApiMethod)new AddApiMethod());
        this.registerMethod((ApiMethod)new RemoveApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ProbeApiMethod());
    }

    private class ProbeApiMethod
    extends ApiMethodSkeleton {
        public ProbeApiMethod() {
            super(FileSyncApiInterface.this.getIdentifier(), "probe", FileDefinitions.__probeInput, FileDefinitions.__probeOutput, FileSyncApiInterface.this.getTypeConverter(), null, false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__probeInput, FileSyncApiInterface.this.getTypeConverter());
            TransferEndpoint sourceEndpoint = (TransferEndpoint)extr.valueForField("source_endpoint");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)FileSyncApiInterface.this.getTypeConverter().convertToVapi((Object)FileSyncApiInterface.this.impl.probe(sourceEndpoint, invocationContext), FileDefinitions.__probeOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(FileSyncApiInterface.this.getIdentifier(), "get", FileDefinitions.__getInput, FileDefinitions.__getOutput, FileSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__getInput, FileSyncApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            String fileName = (String)extr.valueForField("file_name");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)FileSyncApiInterface.this.getTypeConverter().convertToVapi((Object)FileSyncApiInterface.this.impl.get(updateSessionId, fileName, invocationContext), FileDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(FileSyncApiInterface.this.getIdentifier(), "list", FileDefinitions.__listInput, FileDefinitions.__listOutput, FileSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__listInput, FileSyncApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)FileSyncApiInterface.this.getTypeConverter().convertToVapi(FileSyncApiInterface.this.impl.list(updateSessionId, invocationContext), FileDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class RemoveApiMethod
    extends ApiMethodSkeleton {
        public RemoveApiMethod() {
            super(FileSyncApiInterface.this.getIdentifier(), "remove", FileDefinitions.__removeInput, FileDefinitions.__removeOutput, FileSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__removeInput, FileSyncApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            String fileName = (String)extr.valueForField("file_name");
            try {
                FileSyncApiInterface.this.impl.remove(updateSessionId, fileName, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class AddApiMethod
    extends ApiMethodSkeleton {
        public AddApiMethod() {
            super(FileSyncApiInterface.this.getIdentifier(), "add", FileDefinitions.__addInput, FileDefinitions.__addOutput, FileSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__addInput, FileSyncApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            FileTypes.AddSpec fileSpec = (FileTypes.AddSpec)extr.valueForField("file_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)FileSyncApiInterface.this.getTypeConverter().convertToVapi((Object)FileSyncApiInterface.this.impl.add(updateSessionId, fileSpec, invocationContext), FileDefinitions.__addOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ValidateApiMethod
    extends ApiMethodSkeleton {
        public ValidateApiMethod() {
            super(FileSyncApiInterface.this.getIdentifier(), "validate", FileDefinitions.__validateInput, FileDefinitions.__validateOutput, FileSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__validateInput, FileSyncApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)FileSyncApiInterface.this.getTypeConverter().convertToVapi((Object)FileSyncApiInterface.this.impl.validate(updateSessionId, invocationContext), FileDefinitions.__validateOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

