/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.client.api.commondataformat20;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.commondataformat.types.FreeFormData;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.commondataformat20.types.JsonLd;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;

public class Payload20
implements Payload {
    protected final Collection<CdfAble> cdfs;
    protected List<FreeFormData> freeforms = null;
    protected List<Resource> resources = null;
    protected List<JsonLd> jsons = null;

    Payload20(Collection<FreeFormData> freeforms, Collection<Resource> resources, Collection<JsonLd> jsons) {
        LinkedList<Object> list = new LinkedList<Object>();
        if (null != freeforms) {
            list.addAll(freeforms);
            this.freeforms = this.asUnmodifiableList(freeforms);
        }
        if (null != resources) {
            list.addAll(resources);
            this.resources = this.asUnmodifiableList(resources);
        }
        if (null != jsons) {
            list.addAll(jsons);
            this.jsons = this.asUnmodifiableList(jsons);
        }
        this.cdfs = Collections.unmodifiableCollection(list);
    }

    private <T> List<T> asUnmodifiableList(Collection<T> cdfs) {
        List<Object> list = null != cdfs && cdfs instanceof List ? (List)cdfs : new LinkedList<T>(cdfs);
        return Collections.unmodifiableList(list);
    }

    public List<FreeFormData> getFreeforms() {
        return this.freeforms;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.cdfs == null ? 0 : this.cdfs.hashCode());
        result = 31 * result + (this.freeforms == null ? 0 : this.freeforms.hashCode());
        result = 31 * result + (this.jsons == null ? 0 : this.jsons.hashCode());
        result = 31 * result + (this.resources == null ? 0 : this.resources.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Payload20 other = (Payload20)obj;
        return EqualsBuilder.reflectionEquals(this.cdfs, other.cdfs);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[Contains " + this.cdfs.size() + " cdfs (" + this.resources.size() + " resources," + this.freeforms.size() + " freeforms, " + this.jsons.size() + " jsons): " + this.cdfs + "]";
    }

    protected Payload20(Collection<CdfAble> o) {
        LinkedList<FreeFormData> f = new LinkedList<FreeFormData>();
        LinkedList<Resource> r = new LinkedList<Resource>();
        LinkedList<JsonLd> j = new LinkedList<JsonLd>();
        for (CdfAble cdf : o) {
            if (cdf instanceof FreeFormData) {
                f.add((FreeFormData)cdf);
            }
            if (cdf instanceof Resource) {
                r.add((Resource)cdf);
            }
            if (!(cdf instanceof JsonLd)) continue;
            j.add((JsonLd)cdf);
        }
        LinkedList<Object> res = new LinkedList<Object>();
        res.addAll(f);
        res.addAll(r);
        res.addAll(j);
        this.freeforms = Collections.unmodifiableList(f);
        this.resources = Collections.unmodifiableList(r);
        this.jsons = Collections.unmodifiableList(j);
        this.cdfs = Collections.unmodifiableCollection(res);
    }

    public List<JsonLd> getJsons() {
        return this.jsons;
    }

    public Collection<CdfAble> getCdfs() {
        return this.cdfs;
    }

    public static class Builder {
        Collection<CdfAble> cdfs = new LinkedList<CdfAble>();

        public Builder add(CdfAble cdf) {
            if (null != cdf) {
                this.cdfs.add(cdf);
            }
            return this;
        }

        public Builder add(Collection<CdfAble> cdfables) {
            if (null != cdfables) {
                this.cdfs.addAll(cdfables);
            }
            return this;
        }

        public Builder add(Payload20 payload) {
            if (null != payload) {
                this.cdfs.addAll(payload.getCdfs());
            }
            return this;
        }

        public Payload20 build() {
            return new Payload20(this.cdfs);
        }

        public String toString() {
            return Payload20.class.getSimpleName() + "." + Builder.class.getSimpleName() + this.cdfs;
        }
    }
}

