/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ceip.impl;

import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.phservice.common.cache.Cache;
import com.vmware.ph.phservice.common.cache.SimpleTimeBasedCacheImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedCeipConfigProviderWrapperImpl
implements CeipConfigProvider {
    private static final Log _log = LogFactory.getLog(CachedCeipConfigProviderWrapperImpl.class);
    private static final String KEY = "CEIP_STATE_KEY";
    private static final int CEIP_CACHE_CAPACITY = 1;
    private final CeipConfigProvider _wrappedCeipConfigProvider;
    private final Cache<String, Boolean> _consentStateCache;

    public CachedCeipConfigProviderWrapperImpl(CeipConfigProvider wrappedCeipConfigProvider, long cacheExpirationMillis) {
        this(wrappedCeipConfigProvider, new SimpleTimeBasedCacheImpl<String, Boolean>(cacheExpirationMillis, 1));
    }

    CachedCeipConfigProviderWrapperImpl(CeipConfigProvider wrappedCeipConfigProvider, Cache<String, Boolean> consentStateCache) {
        this._wrappedCeipConfigProvider = wrappedCeipConfigProvider;
        this._consentStateCache = consentStateCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCeipEnabled() {
        Boolean isCeipEnabled = this._consentStateCache.get(KEY);
        if (isCeipEnabled == null) {
            CachedCeipConfigProviderWrapperImpl cachedCeipConfigProviderWrapperImpl = this;
            synchronized (cachedCeipConfigProviderWrapperImpl) {
                isCeipEnabled = this._consentStateCache.get(KEY);
                if (isCeipEnabled == null) {
                    this.refreshCeipCache();
                    isCeipEnabled = this._consentStateCache.get(KEY);
                }
            }
        }
        return isCeipEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCeipCache() {
        boolean newCeipState;
        Boolean previousCeipState = null;
        CachedCeipConfigProviderWrapperImpl cachedCeipConfigProviderWrapperImpl = this;
        synchronized (cachedCeipConfigProviderWrapperImpl) {
            previousCeipState = this._consentStateCache.get(KEY);
            newCeipState = this._wrappedCeipConfigProvider.isCeipEnabled();
            this._consentStateCache.invalidate();
            this._consentStateCache.put(KEY, newCeipState);
        }
        if ((previousCeipState == null || previousCeipState != newCeipState) && _log.isInfoEnabled()) {
            _log.info((Object)("CEIP cache refreshed with value " + String.valueOf(newCeipState)));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Acquired CEIP state " + String.valueOf(newCeipState)));
        }
    }
}

