/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ceip.impl;

import com.vmware.ph.phservice.ceip.CeipApi;
import com.vmware.ph.phservice.ceip.CeipApiAuthenticationValidator;
import com.vmware.ph.phservice.ceip.CeipApiException;
import com.vmware.ph.phservice.ceip.ConsentException;
import com.vmware.ph.phservice.ceip.ConsentManager;
import com.vmware.vim.binding.phonehome.data.ConsentConfiguration;
import com.vmware.vim.binding.phonehome.data.ConsentConfigurationData;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CeipApiImpl
implements CeipApi {
    static final int CEIP_CONSENT_ID_OLD = 1;
    static final int CEIP_CONSENT_ID = 2;
    private static final String DEFAULT_OWNER = "";
    private static final long VERSION_DEFAULT = 0L;
    private static final Log _log = LogFactory.getLog(CeipApiImpl.class);
    private final ConsentManager _localConsentManager;
    private final ConsentManager _globalConsentManager;
    private final CeipApiAuthenticationValidator _ceipApiAuthneticationValidator;

    public CeipApiImpl(ConsentManager localConsentManager, ConsentManager globalConsentManager, CeipApiAuthenticationValidator ceipApiAuthneticationValidator) {
        this._localConsentManager = Objects.requireNonNull(localConsentManager);
        this._globalConsentManager = Objects.requireNonNull(globalConsentManager);
        this._ceipApiAuthneticationValidator = Objects.requireNonNull(ceipApiAuthneticationValidator);
    }

    @Override
    public Boolean isConsentAccepted() {
        ConsentState localConsentState = this.readLocal();
        return CeipApiImpl.isCeipConsentAccepted(localConsentState.getConsentConfigurations());
    }

    @Override
    public boolean isConsentChangeAllowed(SamlToken samlToken, PrivateKey privateKey) {
        return this._ceipApiAuthneticationValidator.isConsentChangeAllowed(samlToken, privateKey);
    }

    @Override
    public void setConsentAccepted(boolean consentAccepted) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Setting consent to: " + consentAccepted));
        }
        ConsentState localConsentState = this.readLocal();
        long localVersion = localConsentState.getVersion();
        ConsentConfiguration[] cc = CeipApiImpl.changeCeipConsentAccepted(localConsentState.getConsentConfigurations(), consentAccepted);
        localVersion = localVersion != 0L ? localVersion + 1L : localVersion;
        this.writeLocal(cc, localVersion + 1L);
        this.writeGlobalSafe(cc, ++localVersion);
    }

    @Override
    public synchronized void sync() {
        boolean isGlobalChanged;
        _log.debug((Object)"Start syncing the consent...");
        ConsentState localConsentState = this.readLocal();
        long localVersion = localConsentState.getVersion();
        ConsentState globalConsentState = this.readGlobal();
        long globalVersion = globalConsentState.getVersion();
        boolean isGlobalCcChanged = !CeipApiImpl.equals(localConsentState.getConsentConfigurations(), globalConsentState.getConsentConfigurations());
        boolean isGlobalVersionChanged = localVersion != globalVersion - 1L && localVersion != globalVersion && localVersion != globalVersion + 1L;
        boolean bl = isGlobalChanged = isGlobalCcChanged || isGlobalVersionChanged;
        if (isGlobalChanged) {
            ++localVersion;
        }
        if (isGlobalChanged) {
            if (localVersion <= globalVersion) {
                if (globalVersion > localVersion) {
                    localVersion = globalVersion + 1L;
                }
                this.writeLocal(globalConsentState.getConsentConfigurations(), localVersion);
            } else {
                this.writeGlobal(localConsentState.getConsentConfigurations(), localVersion);
            }
        }
    }

    private void writeLocal(ConsentConfiguration[] consentAccepted, long version) {
        ConsentConfigurationData ccData = new ConsentConfigurationData(consentAccepted, Long.toString(version));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Storing consent data locally. Stored data is: " + ccData));
        }
        try {
            this._localConsentManager.writeConsent(ccData);
            _log.debug((Object)"Consent data has been sucessfully stored locally.");
        }
        catch (ConsentException e) {
            throw new CeipApiException("Error while locally storing the consent data.As a result consent state cannot be saved. Please check the logs for details.", e);
        }
    }

    private void writeGlobal(ConsentConfiguration[] consentConfiguration, long localVersion) {
        ConsentConfigurationData ccData = new ConsentConfigurationData(consentConfiguration, Long.toString(localVersion + 1L));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Global consent is successfully changed. Conset data sent: " + ccData));
        }
        try {
            this._globalConsentManager.writeConsent(ccData);
            _log.debug((Object)"Global consent data has been sent successfully.");
        }
        catch (ConsentException | RuntimeException e) {
            throw new CeipApiException("Error while sending the changes to the global consent.As a result consent state cannot be updated. Please check the logs for details.", e);
        }
    }

    private ConsentState readGlobal() {
        ConsentState globalConsentState = null;
        try {
            try {
                globalConsentState = new ConsentState(this._globalConsentManager.readConsent());
            }
            catch (ConsentException e) {
                throw new CeipApiException("Failed to read global consent configuration.", e);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Loaded consentConfigData from CCS -> " + Arrays.toString(globalConsentState.getConsentConfigurations())));
            }
        }
        catch (RuntimeException re) {
            throw new CeipApiException("Error while reading global consent. As a result consent state is not up to date.", re);
        }
        return globalConsentState;
    }

    private void writeGlobalSafe(ConsentConfiguration[] consentConfiguration, long currentVersion) {
        try {
            this.writeGlobal(consentConfiguration, currentVersion);
        }
        catch (RuntimeException e) {
            _log.debug((Object)"Failed to write global consent while setting consent state.", (Throwable)e);
        }
    }

    private ConsentState readLocal() {
        _log.debug((Object)"Reading the locally stored consent.");
        ConsentState localConsentState = null;
        try {
            localConsentState = new ConsentState(this._localConsentManager.readConsent());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Successfully read the locally stored consent data. Consent data is: " + Arrays.toString(localConsentState.getConsentConfigurations())));
            }
        }
        catch (ConsentException e) {
            _log.debug((Object)"Failed to read local consent state.");
            localConsentState = new ConsentState();
        }
        return localConsentState;
    }

    private static boolean equals(ConsentConfiguration[] arr1, ConsentConfiguration[] arr2) {
        if (arr1 == arr2) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        HashSet<String> s = new HashSet<String>();
        for (ConsentConfiguration a : arr1) {
            s.add(CeipApiImpl.consentConfigToString(a));
        }
        for (ConsentConfiguration a : arr2) {
            s.remove(CeipApiImpl.consentConfigToString(a));
        }
        return s.size() == 0;
    }

    private static String consentConfigToString(ConsentConfiguration cc) {
        StringBuilder sb = new StringBuilder();
        sb.append("consentAccepted=");
        sb.append(cc.isConsentAccepted());
        sb.append("consentId=");
        sb.append(cc.getConsentId());
        String ccOwner = DEFAULT_OWNER;
        if (cc.getOwner() != null) {
            ccOwner = cc.getOwner();
        }
        sb.append("owner=");
        sb.append(ccOwner);
        return sb.toString();
    }

    private static Boolean isCeipConsentAccepted(ConsentConfiguration[] cc) {
        for (int i = 0; cc != null && i < cc.length; ++i) {
            if (cc[i].getConsentId() != 2) continue;
            return cc[i].isConsentAccepted();
        }
        return false;
    }

    private static ConsentConfiguration[] changeCeipConsentAccepted(ConsentConfiguration[] cc, Boolean consentAccepted) {
        if (cc == null) {
            return new ConsentConfiguration[]{new ConsentConfiguration(consentAccepted.booleanValue(), 1, DEFAULT_OWNER), new ConsentConfiguration(consentAccepted.booleanValue(), 2, DEFAULT_OWNER)};
        }
        cc = CeipApiImpl.changeCeipConsentAccepted(1, cc, consentAccepted);
        cc = CeipApiImpl.changeCeipConsentAccepted(2, cc, consentAccepted);
        return cc;
    }

    private static ConsentConfiguration[] changeCeipConsentAccepted(int ceipConsentId, ConsentConfiguration[] cc, Boolean consentAccepted) {
        boolean isCeipConsentAvailable = false;
        cc = CeipApiImpl.deepCopy(cc);
        for (int i = 0; i < cc.length; ++i) {
            if (cc[i].getConsentId() != ceipConsentId) continue;
            cc[i].setConsentAccepted(consentAccepted.booleanValue());
            isCeipConsentAvailable = true;
        }
        if (!isCeipConsentAvailable) {
            cc = Arrays.copyOf(cc, cc.length + 1);
            cc[cc.length - 1] = new ConsentConfiguration(consentAccepted.booleanValue(), ceipConsentId, DEFAULT_OWNER);
        }
        return cc;
    }

    private static ConsentConfiguration[] deepCopy(ConsentConfiguration[] cc) {
        ConsentConfiguration[] result = new ConsentConfiguration[cc.length];
        for (int i = 0; i < cc.length; ++i) {
            result[i] = new ConsentConfiguration(cc[i].isConsentAccepted(), cc[i].getConsentId(), cc[i].getOwner());
        }
        return result;
    }

    static class ConsentState {
        private final ConsentConfiguration[] _consentConfigurations;
        private final long _version;

        public ConsentState() {
            this(null, 0L);
        }

        public ConsentState(ConsentConfiguration[] consentConfigurations, long version) {
            this._consentConfigurations = consentConfigurations;
            this._version = version;
        }

        public ConsentState(ConsentConfigurationData consentConfigurationData) {
            if (consentConfigurationData != null) {
                this._consentConfigurations = consentConfigurationData.getConsentConfigurations();
                this._version = Long.parseLong(consentConfigurationData.getVersion());
            } else {
                this._consentConfigurations = null;
                this._version = 0L;
            }
        }

        public ConsentConfiguration[] getConsentConfigurations() {
            return this._consentConfigurations;
        }

        public long getVersion() {
            return this._version;
        }
    }
}

