/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ceip.impl;

import com.vmware.ph.phservice.ceip.CeipApi;
import com.vmware.ph.phservice.ceip.CeipApiException;
import com.vmware.ph.phservice.ceip.CeipApiProvider;
import com.vmware.ph.phservice.ceip.CeipSynchronizer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCeipSynchronizer
implements CeipSynchronizer {
    private static final Log _log = LogFactory.getLog(DefaultCeipSynchronizer.class);
    private final int _syncDelayMillis;
    private final int _syncPeriodMillis;
    private final Timer _timer;
    private final CeipApiProvider _ceipApiProvider;
    private boolean _startMethodBeenExecuted = false;

    public DefaultCeipSynchronizer(int syncPeriodMillis, CeipApiProvider ceipApiProvider) {
        this(syncPeriodMillis, syncPeriodMillis, ceipApiProvider, new TimerFactory());
    }

    DefaultCeipSynchronizer(int syncDelayMillis, int syncPeriodMillis, CeipApiProvider ceipApiProvider, TimerFactory timerFactory) {
        this._syncDelayMillis = syncDelayMillis;
        this._syncPeriodMillis = syncPeriodMillis;
        this._ceipApiProvider = ceipApiProvider;
        this._timer = timerFactory.createTimer();
    }

    @Override
    public void start() {
        this._startMethodBeenExecuted = true;
        this._timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    int syncDelaySeconds = DefaultCeipSynchronizer.this._syncDelayMillis / 1000;
                    DefaultCeipSynchronizer.this.sync();
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Global consent status synchronizer will start again after " + syncDelaySeconds + " s."));
                    }
                }
                catch (RuntimeException e) {
                    _log.error((Object)"Global consent status synchronizer has stopped unexpectedly. As a result the local consent state will not be synchronized with other consent states. To recover please verify/fix the exact reason in the cause exception and restart the service", (Throwable)e);
                }
            }
        }, this._syncDelayMillis, (long)this._syncPeriodMillis);
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("CEIP synchronization scheduleAtFixedRate, delay = %d / period = %d", this._syncDelayMillis, this._syncPeriodMillis));
        }
    }

    @Override
    public void stop() {
        this._timer.cancel();
    }

    public boolean hasStartMethodBeenExecuted() {
        return this._startMethodBeenExecuted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        _log.info((Object)"Synchronization with the other PSC nodes started...");
        CeipApi ceipApi = this._ceipApiProvider.getCeipApi();
        if (ceipApi == null) {
            _log.debug((Object)"Synchronization will not be perfromed - no CeipApi object is available.");
            return;
        }
        try {
            ceipApi.sync();
            _log.info((Object)"Synchronization with the other PSC nodes finished successfuly");
        }
        catch (CeipApiException e) {
            _log.warn((Object)"Error while synchronizing the CopnsentConfiguration between different PSC nodes. The detailed reason is contained in the inner exception log. As a result of this problem the current consent configuration is out of sync with the other PSC nodes.", (Throwable)e);
        }
        finally {
            this._ceipApiProvider.releaseCeipApi(ceipApi);
        }
    }

    static class TimerFactory {
        TimerFactory() {
        }

        public Timer createTimer() {
            return new Timer("CEIPSynchronizerTimer", true);
        }
    }
}

