/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ceip.impl;

import com.vmware.ph.phservice.ceip.ConsentException;
import com.vmware.ph.phservice.ceip.ConsentManager;
import com.vmware.ph.phservice.client.CcsClientUtil;
import com.vmware.ph.phservice.vmomicommon.client.VmomiClient;
import com.vmware.vim.binding.phonehome.data.ConsentConfigurationData;
import com.vmware.vim.binding.phonehome.service.ConsentConfigurationService;
import java.util.Objects;

public class GlobalConsentManager
implements ConsentManager {
    private final VmomiClient _ccsClient;

    public GlobalConsentManager(VmomiClient ccsClient) {
        this._ccsClient = Objects.requireNonNull(ccsClient);
    }

    @Override
    public ConsentConfigurationData readConsent() throws ConsentException {
        ConsentConfigurationData ccData = null;
        try {
            ConsentConfigurationService ccs = CcsClientUtil.getConsentConfigurationServiceMo(this._ccsClient);
            ccData = ccs.get();
            if (ccData == null) {
                throw new ConsentException("Failed to read consent data from Consent Configuration Service.");
            }
        }
        catch (Exception e) {
            throw new ConsentException("Failed to create Consent Configuration Serivce client stub.", e);
        }
        return ccData;
    }

    @Override
    public void writeConsent(ConsentConfigurationData consent) throws ConsentException {
        try {
            ConsentConfigurationService ccs = CcsClientUtil.getConsentConfigurationServiceMo(this._ccsClient);
            ccs.set(consent);
        }
        catch (Exception e) {
            throw new ConsentException("Failed to write consent data via the Consent Configuration Serivce", e);
        }
    }
}

