/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ceip.impl;

import com.vmware.ph.phservice.ceip.CeipApi;
import com.vmware.ph.phservice.ceip.CeipApiProvider;
import com.vmware.ph.phservice.ceip.impl.CeipApiImpl;
import com.vmware.ph.phservice.ceip.impl.GlobalConsentManager;
import com.vmware.ph.phservice.ceip.impl.VcConsentManager;
import com.vmware.ph.phservice.ceip.impl.VimContextCeipApiAuthenticationValidator;
import com.vmware.ph.phservice.client.CcsClientUtil;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.provider.vimcommon.VimContextProvider;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.vmomicommon.client.VmomiClient;

public class VimContextSingleCeipApiProviderImpl
implements CeipApiProvider {
    private final VimContextProvider _vimContextProvider;
    private final CcsVmomiClientFactory _ccsVmomiClientFactory;
    private final Object _lock;
    private VcClient _vcClient;
    private VmomiClient _ccsClient;
    private volatile CeipApi _ceipApi;

    public VimContextSingleCeipApiProviderImpl(VimContextProvider vimContextProvider) {
        this(vimContextProvider, new CcsVmomiClientFactory());
    }

    VimContextSingleCeipApiProviderImpl(VimContextProvider vimContextProvider, CcsVmomiClientFactory ccsVmomiClientFactory) {
        this._vimContextProvider = vimContextProvider;
        this._ccsVmomiClientFactory = ccsVmomiClientFactory;
        this._lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CeipApi getCeipApi() {
        CeipApi result = this._ceipApi;
        if (result == null) {
            Object object = this._lock;
            synchronized (object) {
                VimContext vimContext;
                result = this._ceipApi;
                if (result == null && (vimContext = this._vimContextProvider.getVimContext()) != null) {
                    this._ccsClient = this._ccsVmomiClientFactory.createCcsVmomiClient(vimContext);
                    this._vcClient = vimContext.getVcClientBuilder(true).build();
                    this._ceipApi = result = new CeipApiImpl(new VcConsentManager(this._vcClient), new GlobalConsentManager(this._ccsClient), new VimContextCeipApiAuthenticationValidator(vimContext));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this._ceipApi != null) {
            Object object = this._lock;
            synchronized (object) {
                if (this._ceipApi != null) {
                    if (this._vcClient != null) {
                        this._vcClient.close();
                        this._vcClient = null;
                    }
                    if (this._ccsClient != null) {
                        this._ccsClient.close();
                        this._ccsClient = null;
                    }
                    this._ceipApi = null;
                }
            }
        }
    }

    @Override
    public void releaseCeipApi(CeipApi ceipApi) {
    }

    static class CcsVmomiClientFactory {
        CcsVmomiClientFactory() {
        }

        public VmomiClient createCcsVmomiClient(VimContext vimContext) {
            return CcsClientUtil.createCcsVmomiClient(vimContext);
        }
    }
}

