/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ciscommon;

import com.vmware.ph.phservice.ciscommon.CisContext;
import com.vmware.ph.phservice.ciscommon.lookup.LookupClientBuilder;
import com.vmware.ph.phservice.ciscommon.sso.SsoTokenProvider;
import com.vmware.ph.phservice.ciscommon.sso.SsoTokenProviderBuilder;
import com.vmware.ph.phservice.ciscommon.sso.impl.LookupSsoEndpointProviderImpl;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.Executors;

public class CisContextBuilder {
    private final KeyStore _vimTrustStore;
    private ThumbprintVerifier _vimThumbprintVerifier;
    private boolean _isLegacyVim = false;
    private final URI _lookupSdkUri;
    private String _ssoUsername;
    private char[] _ssoPassword;
    private X509Certificate _solutionCertificate;
    private Key _solutionPrivateKey;
    private SsoTokenProvider.TokenKeyPair _tokenKeyPair;
    private KeyStore _solutionKeyStore;
    private String _solutionKeyAlias;
    private char[] _solutionKeyPassword;

    private CisContextBuilder(URI lookupSdkUri, KeyStore vimTrustStore) {
        this._lookupSdkUri = lookupSdkUri;
        this._vimTrustStore = vimTrustStore;
        this._isLegacyVim = false;
    }

    public static CisContextBuilder forCis(URI lookupSdkUri, KeyStore vimTrustStore) {
        return new CisContextBuilder(lookupSdkUri, vimTrustStore);
    }

    public CisContextBuilder withTrust(ThumbprintVerifier vimThumbprintVerifier) {
        this._vimThumbprintVerifier = vimThumbprintVerifier;
        return this;
    }

    public CisContextBuilder withSsoUser(String ssoUsername, char[] ssoPassword) {
        this._ssoUsername = ssoUsername;
        this._ssoPassword = ssoPassword;
        return this;
    }

    public CisContextBuilder withSamlTokenAndPrivateKey(SamlToken samlToken, PrivateKey privateKey) {
        this._tokenKeyPair = new SsoTokenProvider.TokenKeyPair();
        this._tokenKeyPair.token = samlToken;
        this._tokenKeyPair.key = privateKey;
        return this;
    }

    public CisContextBuilder withSsoSolutionUser(X509Certificate solutionCertificate, Key solutionPrivateKey) {
        this._solutionCertificate = solutionCertificate;
        this._solutionPrivateKey = solutionPrivateKey;
        return this;
    }

    public CisContextBuilder withSsoSolutionUser(KeyStore solutionKeyStore, String solutionKeyAlias, char[] solutionKeyPassword) {
        this._solutionKeyStore = solutionKeyStore;
        this._solutionKeyAlias = solutionKeyAlias;
        this._solutionKeyPassword = solutionKeyPassword;
        return this;
    }

    public CisContext build() {
        CisContext vimContext = null;
        LookupClientBuilder lookupClientBuilder = LookupClientBuilder.forLookupVersion(LookupClientBuilder.LEGACY_LOOKUP_VERSION_CLASS, Executors.newSingleThreadExecutor()).withTrust(this._vimTrustStore, this._vimThumbprintVerifier).withLookupSdkUri(this._lookupSdkUri);
        SsoTokenProvider ssoTokenProvider = this.createSsoTokenProvider(lookupClientBuilder);
        vimContext = new CisContext(this._vimTrustStore, this._lookupSdkUri, lookupClientBuilder, ssoTokenProvider);
        vimContext.setVimThumbprintVerifier(this._vimThumbprintVerifier);
        return vimContext;
    }

    private SsoTokenProvider createSsoTokenProvider(LookupClientBuilder lookupClientBuilder) {
        if (this._isLegacyVim) {
            return null;
        }
        LookupSsoEndpointProviderImpl ssoEndpointProvider = new LookupSsoEndpointProviderImpl(lookupClientBuilder);
        SsoTokenProviderBuilder ssoTokenProviderBuilder = SsoTokenProviderBuilder.forSsoService(ssoEndpointProvider).withTrust(this._vimTrustStore, this._vimThumbprintVerifier);
        if (this._ssoUsername != null) {
            ssoTokenProviderBuilder.withSsoUser(this._ssoUsername, this._ssoPassword);
        } else if (this._tokenKeyPair != null) {
            ssoTokenProviderBuilder.withTokenKeyPair(this._tokenKeyPair);
        } else if (this._solutionCertificate != null) {
            ssoTokenProviderBuilder.withSsoSolutionUser(this._solutionCertificate, this._solutionPrivateKey);
        } else if (this._solutionKeyStore != null) {
            ssoTokenProviderBuilder.withSsoSolutionUser(this._solutionKeyStore, this._solutionKeyAlias, this._solutionKeyPassword);
        } else {
            throw new IllegalArgumentException("Missing SSO user");
        }
        SsoTokenProvider ssoTokenProvider = ssoTokenProviderBuilder.build();
        return ssoTokenProvider;
    }
}

