/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ciscommon.lookup;

import com.vmware.ph.phservice.ciscommon.lookup.LookupClient;
import com.vmware.ph.phservice.ciscommon.lookup.impl.LookupClientFactoryImpl;
import com.vmware.vim.binding.lookup.version.internal.version1;
import com.vmware.vim.binding.lookup.version.internal.version2;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.security.KeyStore;
import java.util.concurrent.ExecutorService;

public class LookupClientBuilder {
    public static final Class<?> LEGACY_LOOKUP_VERSION_CLASS = version1.class;
    public static final Class<?> LATEST_LOOKUP_VERSION_CLASS = version2.class;
    private final Class _versionClass;
    private final LookupClientFactoryImpl _lookupClientFactory;
    private URI _lookupSdkUri;

    public static LookupClientBuilder forLookupVersion(Class<?> versionClass, ExecutorService threadPool) {
        return new LookupClientBuilder(versionClass, threadPool);
    }

    private LookupClientBuilder(Class<?> versionClass, ExecutorService threadPool) {
        this._versionClass = versionClass;
        this._lookupClientFactory = new LookupClientFactoryImpl(versionClass, threadPool);
        this._lookupClientFactory.setTimeoutMs(180000);
    }

    public LookupClientBuilder withTrust(KeyStore trustStore, ThumbprintVerifier thumbprintVerifier) {
        this._lookupClientFactory.setTrustStore(trustStore);
        this._lookupClientFactory.setThumbprintVerifier(thumbprintVerifier);
        return this;
    }

    public LookupClientBuilder withLookupSdkUri(URI lookupSdkUri) {
        this._lookupSdkUri = lookupSdkUri;
        return this;
    }

    public LookupClient build() {
        LookupClient lookupClient = this._lookupClientFactory.connectLookup(this._lookupSdkUri);
        return lookupClient;
    }

    public Class getVersion() {
        return this._versionClass;
    }
}

