/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ciscommon.sso.impl;

import com.vmware.ph.phservice.ciscommon.sso.AdminClient;
import com.vmware.ph.phservice.ciscommon.sso.SsoEndpoint;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.ServiceContent;
import com.vmware.vim.binding.sso.admin.ServiceInstance;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.net.URI;
import java.security.KeyStore;

public class AdminClientImpl
implements AdminClient {
    private static final String SSO_ADMIN_SERVICE_INSTANCE = "SsoAdminServiceInstance";
    private final VmodlContext _vmodlContext;
    private final Class<?> _versionClass;
    private final SsoEndpoint _ssoAdminEndpoint;
    private final KeyStore _trustStore;
    private final ThumbprintVerifier _thumbprintVerifier;
    private final Object _configurationManagementServiceInitLock = new Object();
    private Client _vmomiClient;
    private ServiceInstance _serviceInstance;
    private ConfigurationManagementService _configurationManagementService;

    AdminClientImpl(VmodlContext vmodlContext, Class<?> versionClass, SsoEndpoint ssoAdminEndpoint, KeyStore trustStore, ThumbprintVerifier thumbprintVerifier) {
        this._vmodlContext = vmodlContext;
        this._versionClass = versionClass;
        this._ssoAdminEndpoint = ssoAdminEndpoint;
        this._trustStore = trustStore;
        this._thumbprintVerifier = thumbprintVerifier;
        this.initVmomiClient();
        this.initServiceInstance();
    }

    @Override
    public ConfigurationManagementService getConfigurationManagementService() {
        if (this._configurationManagementService == null) {
            this.initConfigurationManagementService();
        }
        return this._configurationManagementService;
    }

    @Override
    public void close() {
        this._vmomiClient.shutdown();
    }

    private void initVmomiClient() {
        HttpClientConfiguration httpClientConfig = this.createHttpClientConfiguration();
        this._vmomiClient = Client.Factory.createClient((URI)this._ssoAdminEndpoint.getUrl(), this._versionClass, (VmodlContext)this._vmodlContext, (ClientConfiguration)httpClientConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initServiceInstance() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this._serviceInstance = (ServiceInstance)this._vmomiClient.createStub(ServiceInstance.class, SSO_ADMIN_SERVICE_INSTANCE);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfigurationManagementService() {
        Object object = this._configurationManagementServiceInitLock;
        synchronized (object) {
            if (this._configurationManagementService == null) {
                ServiceContent serviceContent = this._serviceInstance.retrieveServiceContent();
                ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    this._configurationManagementService = (ConfigurationManagementService)this._vmomiClient.createStub(ConfigurationManagementService.class, serviceContent.getConfigurationManagementService());
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
    }

    private HttpClientConfiguration createHttpClientConfiguration() {
        HttpConfiguration httpConfig = HttpConfiguration.Factory.newInstance();
        httpConfig.setTrustStore(this._trustStore);
        httpConfig.setThumbprintVerifier(this._thumbprintVerifier);
        httpConfig.setTimeoutMs(180000);
        HttpClientConfiguration httpClientConfig = HttpClientConfiguration.Factory.newInstance();
        httpClientConfig.setHttpConfiguration(httpConfig);
        return httpClientConfig;
    }
}

