/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ciscommon.sso.impl;

import com.vmware.ph.phservice.ciscommon.lookup.LookupClient;
import com.vmware.ph.phservice.ciscommon.lookup.LookupClientBuilder;
import com.vmware.ph.phservice.ciscommon.sso.SsoEndpoint;
import com.vmware.ph.phservice.ciscommon.sso.SsoEndpointProvider;
import com.vmware.ph.phservice.ciscommon.sso.SsoException;
import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import java.net.URI;
import java.net.URISyntaxException;

public class LookupSsoEndpointProviderImpl
implements SsoEndpointProvider {
    private static final URI SERVICE_TYPE_SSO_STS;
    private static final URI SERVICE_TYPE_SSO_ADMIN;
    private final LookupClientBuilder _lookupClientBuilder;

    public LookupSsoEndpointProviderImpl(LookupClientBuilder lookupClientBuilder) {
        this._lookupClientBuilder = lookupClientBuilder;
    }

    @Override
    public SsoEndpoint getAdminEndpoint() throws SsoException {
        return this.getSsoEndpoint(SERVICE_TYPE_SSO_ADMIN);
    }

    @Override
    public SsoEndpoint getStsEndpoint() throws SsoException {
        return this.getSsoEndpoint(SERVICE_TYPE_SSO_STS);
    }

    private SsoEndpoint getSsoEndpoint(URI serviceType) throws SsoException {
        try {
            ServiceEndpoint endpoint = this.getSsoLookupServiceEndpoint(serviceType);
            return new SsoEndpoint(endpoint.getUrl(), new String[]{endpoint.getSslTrustAnchor()});
        }
        catch (Exception e) {
            if (e instanceof SsoException) {
                throw e;
            }
            throw new SsoException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ServiceEndpoint getSsoLookupServiceEndpoint(URI serviceType) throws SsoException {
        try (LookupClient lookupClient = this._lookupClientBuilder.build();){
            Service service = this.getServiceByType(serviceType, lookupClient);
            ServiceEndpoint[] endpoints = service.getEndpoints();
            if (endpoints == null) throw new SsoException("There must be exactly one endpoint for the STS service with endpointType='" + serviceType + "'. Actual found=" + endpoints);
            if (endpoints.length != 1) {
                throw new SsoException("There must be exactly one endpoint for the STS service with endpointType='" + serviceType + "'. Actual found=" + endpoints);
            }
            ServiceEndpoint serviceEndpoint = endpoints[0];
            return serviceEndpoint;
        }
        catch (ServiceFault e) {
            throw new SsoException(e);
        }
    }

    private Service getServiceByType(URI serviceType, LookupClient lookupClient) throws ServiceFault, SsoException {
        LookupService lookupService = lookupClient.getLookupService();
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setViSite(lookupService.getViSite());
        searchCriteria.setServiceType(serviceType);
        Service[] services = lookupService.find(searchCriteria);
        return services[0];
    }

    static {
        try {
            SERVICE_TYPE_SSO_STS = new URI("urn:sso:sts");
            SERVICE_TYPE_SSO_ADMIN = new URI("urn:sso:admin");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

