/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.client;

import com.vmware.ph.phservice.client.CcsVmomiClientBuilder;
import com.vmware.ph.phservice.client.VimContextCcsLocator;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.provider.vimcommon.VimContextBuilder;
import com.vmware.ph.phservice.vmomicommon.client.VmomiClient;
import com.vmware.vim.binding.phonehome.service.ConsentConfigurationService;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;
import java.util.concurrent.Executors;

public final class CcsClientUtil {
    private static final String CONSENT_CONFIG_SERVICE_MO_ID = "ccService";

    private CcsClientUtil() {
    }

    public static VmomiClient createCcsVmomiClient(VimContext vimContext) {
        CcsVmomiClientBuilder ccsVmomiClientBuilder = CcsVmomiClientBuilder.forCcsEndpointLocation(new VimContextCcsLocator(vimContext), Executors.newSingleThreadExecutor()).withTrust(vimContext.getVimTrustedStore(), vimContext.getThumprintVerifier()).withSsoTokenProvider(vimContext.getSsoTokenProvider()).withTimeoutMs(180000);
        VmomiClient ccsVmomiClient = ccsVmomiClientBuilder.build();
        return ccsVmomiClient;
    }

    public static VmomiClient createCcsVmomiClient(VimContext vimContext, SamlToken samlToken, PrivateKey privateKey) {
        VimContext vimContextWithModifiedAuthentication = VimContextBuilder.forVim(vimContext.getLookupSdkUri(), vimContext.getVimTrustedStore()).withVcSdkUri(vimContext.getVcSdkUri()).withVcInstanceUuid(vimContext.getVcInstanceUuid()).withSamlTokenAndPrivateKey(samlToken, privateKey).withTrust(vimContext.getThumprintVerifier()).build();
        return CcsClientUtil.createCcsVmomiClient(vimContextWithModifiedAuthentication);
    }

    public static ConsentConfigurationService getConsentConfigurationServiceMo(VmomiClient ccsClient) throws Exception {
        String ccsWsdlName = ccsClient.getVmodlContext().getVmodlTypeMap().getVmodlType(ConsentConfigurationService.class).getWsdlName();
        ManagedObjectReference ccsMoRef = new ManagedObjectReference(ccsWsdlName, CONSENT_CONFIG_SERVICE_MO_ID);
        ConsentConfigurationService ccsStub = (ConsentConfigurationService)ccsClient.createStub(ccsMoRef);
        return ccsStub;
    }
}

