/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.client;

import com.vmware.ph.phservice.ciscommon.sso.SsoTokenProvider;
import com.vmware.ph.phservice.client.CcsLocator;
import com.vmware.ph.phservice.client.SsoTokenAuthenticationHelper;
import com.vmware.ph.phservice.provider.common.Builder;
import com.vmware.ph.phservice.vmomicommon.VmodlContextProvider;
import com.vmware.ph.phservice.vmomicommon.client.VmomiClient;
import com.vmware.ph.phservice.vmomicommon.client.impl.VmomiClientFactoryImpl;
import com.vmware.vim.binding.phonehome.service.ConsentConfigurationService;
import com.vmware.vim.binding.phonehome.version.version1;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.security.KeyStore;
import java.util.concurrent.ExecutorService;

public class CcsVmomiClientBuilder
implements Builder<VmomiClient> {
    private static final String PH_VMODL_PACAKGE_NAME = "com.vmware.vim.binding.phonehome";
    private static final Class<?> CCS_VERSION_CLASS = version1.class;
    private final CcsLocator _ccsLocator;
    private final VmomiClientFactoryImpl _vmomiClientFactory;
    private SsoTokenProvider _ssoTokenProvider;

    public static CcsVmomiClientBuilder forCcsEndpointLocation(CcsLocator ccsLocator, ExecutorService threadPool) {
        return new CcsVmomiClientBuilder(ccsLocator, threadPool);
    }

    private CcsVmomiClientBuilder(CcsLocator ccsLocator, ExecutorService threadPool) {
        this._ccsLocator = ccsLocator;
        VmodlContext vmodlContext = VmodlContextProvider.getVmodlContextForPacakgeAndClass(PH_VMODL_PACAKGE_NAME, ConsentConfigurationService.class, false);
        this._vmomiClientFactory = new VmomiClientFactoryImpl(CCS_VERSION_CLASS, vmodlContext, threadPool);
    }

    public CcsVmomiClientBuilder withTrust(KeyStore trustStore, ThumbprintVerifier thumbprintVerifier) {
        this._vmomiClientFactory.setTrustStore(trustStore);
        this._vmomiClientFactory.setThumbprintVerifier(thumbprintVerifier);
        return this;
    }

    public CcsVmomiClientBuilder withSsoTokenProvider(SsoTokenProvider ssoTokenProvider) {
        this._ssoTokenProvider = ssoTokenProvider;
        return this;
    }

    public CcsVmomiClientBuilder withTimeoutMs(int timeoutMs) {
        this._vmomiClientFactory.setTimeoutMs(timeoutMs);
        return this;
    }

    @Override
    public VmomiClient build() {
        SsoTokenAuthenticationHelper ssoTokenAuthenticationHelper = null;
        if (this._ssoTokenProvider != null) {
            ssoTokenAuthenticationHelper = new SsoTokenAuthenticationHelper(this._ssoTokenProvider);
        }
        VmomiClient vmomiClient = this._vmomiClientFactory.create(this._ccsLocator.getSdkUri(), ssoTokenAuthenticationHelper);
        return vmomiClient;
    }
}

