/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.client;

import com.vmware.ph.phservice.ciscommon.lookup.LookupClient;
import com.vmware.ph.phservice.ciscommon.lookup.ServiceLocatorUtil;
import com.vmware.ph.phservice.client.CcsLocator;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VimContextCcsLocator
implements CcsLocator {
    private static final Log _log = LogFactory.getLog(VimContextCcsLocator.class);
    private static final String CCS_SDK_PATH = "/ls/ph/sdk";
    static final String LICENSING_SDK_PATH = "/ls/sdk";
    static final String PH_SERVICE_ENDPOINT_TYPE = "com.vmware.ph.globalconfig.consentservice";
    static final String LICENSEING_SERVICE_ENDPOINT_TYPE = "com.vmware.cis.cs.license.sdk";
    private final VimContext _vimContext;

    public VimContextCcsLocator(VimContext vimContext) {
        this._vimContext = vimContext;
    }

    @Override
    public URI getSdkUri() {
        LookupClient lookupClient = this._vimContext.getLookupClientBuilder(true).build();
        URI sdkUri = ServiceLocatorUtil.getEndpointUriByEndpointType(lookupClient, new ServiceRegistration.EndpointType(null, PH_SERVICE_ENDPOINT_TYPE));
        if (sdkUri == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("LookupService does not contain endpoints of type %s. Will look for endpoints of type %s and construct the URL as relative to the found one.", PH_SERVICE_ENDPOINT_TYPE, LICENSEING_SERVICE_ENDPOINT_TYPE));
            }
            sdkUri = VimContextCcsLocator.constructSdkUriFromLicenseServiceUri(lookupClient);
        }
        return sdkUri;
    }

    private static URI constructSdkUriFromLicenseServiceUri(LookupClient lookupClient) {
        URI sdkUri = null;
        URI licensingServiceUri = ServiceLocatorUtil.getEndpointUriByEndpointType(lookupClient, new ServiceRegistration.EndpointType(null, LICENSEING_SERVICE_ENDPOINT_TYPE));
        if (licensingServiceUri == null) {
            throw new IllegalStateException("Cannot initialize ConsentConfigService because LookupService does not contain registration neither of endpoint type com.vmware.ph.globalconfig.consentservicenor of endpoint type com.vmware.cis.cs.license.sdk.");
        }
        if (LICENSING_SDK_PATH.equals(licensingServiceUri.getPath())) {
            try {
                sdkUri = new URI(licensingServiceUri.getScheme(), licensingServiceUri.getUserInfo(), licensingServiceUri.getHost(), licensingServiceUri.getPort(), CCS_SDK_PATH, licensingServiceUri.getQuery(), licensingServiceUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Cannot construct URI.", e);
            }
        } else {
            throw new IllegalStateException("Found URI of the Licensing service: " + licensingServiceUri + "Its path " + licensingServiceUri.getPath() + " is not equal to the expected " + LICENSING_SDK_PATH + ". " + "Changing CEIP status through UI will not work properly because of this fact.");
        }
        return sdkUri;
    }
}

