/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.vmware.cis.data.api.QueryService;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.cdf.CdfCollector;
import com.vmware.ph.phservice.collector.cdf.CollectedPayload;
import com.vmware.ph.phservice.collector.cdf.PayloadUtil;
import com.vmware.ph.phservice.collector.file.CollectedFile;
import com.vmware.ph.phservice.collector.file.FileCollector;
import com.vmware.ph.phservice.collector.manifest.Manifest;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class Aggregators {
    public static CdfCollector cdf(List<CdfCollector> collectors) {
        return new Cdf(collectors);
    }

    public static FileCollector file(List<FileCollector> collectors) {
        return new File(collectors);
    }

    private static final class File
    implements FileCollector {
        private final List<FileCollector> collectors;

        public File(List<FileCollector> collectors) {
            Validate.notNull(collectors, (String)"Argument `collectors' is requried.");
            this.collectors = collectors;
        }

        @Override
        public Iterable<CollectedFile> collect(final Manifest manifest, final QueryService queryService, final Context context, final int pageSize) {
            return Iterables.concat((Iterable)Iterables.transform(this.collectors, (Function)new Function<FileCollector, Iterable<CollectedFile>>(){

                public Iterable<CollectedFile> apply(FileCollector input) {
                    return input.collect(manifest, queryService, context, pageSize);
                }
            }));
        }
    }

    private static final class Cdf
    implements CdfCollector {
        private final List<CdfCollector> collectors;

        public Cdf(List<CdfCollector> collectors) {
            Validate.notNull(collectors, (String)"Argument `collectors' is requried.");
            this.collectors = collectors;
        }

        @Override
        public Iterable<CollectedPayload> collect(final Manifest manifest, final QueryService queryService, final Context context, final int pageSize) {
            return Iterables.concat((Iterable)Iterables.transform(this.collectors, (Function)new Function<CdfCollector, Iterable<CollectedPayload>>(){

                public Iterable<CollectedPayload> apply(CdfCollector input) {
                    long startTimeNano = System.nanoTime();
                    Iterable<CollectedPayload> result = input.collect(manifest, queryService, context, pageSize);
                    long endTimeNano = System.nanoTime();
                    String collectorName = input.getClass().getSimpleName();
                    Iterable<CollectedPayload> perfData = PayloadUtil.buildPerfData(endTimeNano - startTimeNano, collectorName, context);
                    return Iterables.concat(result, perfData);
                }
            }));
        }
    }
}

