/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.cdf;

import com.vmware.cis.data.api.QueryService;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.commondataformat20.Payload20;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.NamedQueryResultSetMapping;
import com.vmware.ph.phservice.collector.cdf.CdfCollector;
import com.vmware.ph.phservice.collector.cdf.CollectedPayload;
import com.vmware.ph.phservice.collector.cdf.PayloadUtil;
import com.vmware.ph.phservice.collector.data.NamedQuery;
import com.vmware.ph.phservice.collector.data.NamedQueryResultSet;
import com.vmware.ph.phservice.collector.data.QueryServiceCollector;
import com.vmware.ph.phservice.collector.manifest.Manifest;

public final class QueryServiceCdfCollector
implements CdfCollector {
    private final QueryServiceCollector<CollectedPayload> _queryServiceCollector;

    public QueryServiceCdfCollector() {
        this(new QueryServiceCollector<CollectedPayload>());
    }

    public QueryServiceCdfCollector(QueryServiceCollector<CollectedPayload> queryServiceCollector) {
        this._queryServiceCollector = queryServiceCollector;
    }

    @Override
    public Iterable<CollectedPayload> collect(Manifest manifest, QueryService queryService, Context context, int pageSize) {
        Context modifiedContext = new Context(context);
        NamedQuery[] queries = manifest.getQueries();
        NamedQueryResultSetMapping<Payload20> responseMapping = manifest.getCdfMapping();
        NamedQueryResutlSetToCollectedPayloadMapping resultMapping = new NamedQueryResutlSetToCollectedPayloadMapping(responseMapping);
        Iterable<CollectedPayload> result = this._queryServiceCollector.collect(queries, resultMapping, queryService, modifiedContext, pageSize);
        return result;
    }

    static class NamedQueryResutlSetToCollectedPayloadMapping
    implements NamedQueryResultSetMapping<CollectedPayload> {
        private final NamedQueryResultSetMapping<Payload20> _resultSetToPayloadMapping;

        public NamedQueryResutlSetToCollectedPayloadMapping(NamedQueryResultSetMapping<Payload20> resultSetToPayloadMapping) {
            this._resultSetToPayloadMapping = resultSetToPayloadMapping;
        }

        @Override
        public CollectedPayload map(NamedQueryResultSet namedQueryResultSet, Context context) {
            Context modifiedContext = new Context(context);
            modifiedContext.put("currObjectCounter", namedQueryResultSet.getCurrObjectCounter());
            Payload20 payload = (Payload20)this._resultSetToPayloadMapping.map(namedQueryResultSet, context);
            String queryName = namedQueryResultSet.getQueryName();
            long startTimeNanos = namedQueryResultSet.getStartTimeNanos();
            int currentPageIndex = namedQueryResultSet.getCurrPageIndex();
            long elapsedNano = System.nanoTime() - startTimeNanos;
            Resource perfPayload = PayloadUtil.buildPerfDataResource(elapsedNano, queryName, currentPageIndex, context);
            Payload20.Builder mergedPayload = new Payload20.Builder();
            mergedPayload.add(payload);
            mergedPayload.add((CdfAble)perfPayload);
            CollectedPayload.Builder collectedData = new CollectedPayload.Builder().setPayload(mergedPayload);
            CollectedPayload collectedPayload = collectedData.build();
            return collectedPayload;
        }

        @Override
        public boolean isQuerySupported(String queryName) {
            return this._resultSetToPayloadMapping.isQuerySupported(queryName);
        }
    }
}

