/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.cdf.mapping;

import com.vmware.ph.client.api.commondataformat.types.FreeFormData;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.AnyPrimitive;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.cdf.mapping.Mapping;
import com.vmware.ph.phservice.collector.cdf.mapping.velocity.VelocityHelper;
import com.vmware.ph.phservice.collector.data.NamedPropertiesResourceItem;
import com.vmware.ph.phservice.common.cdf.CdfUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public class ResourceItemToCdfFreeFormDataMapping
implements Mapping<NamedPropertiesResourceItem, FreeFormData> {
    private static final Log _logger = LogFactory.getLog(ResourceItemToCdfFreeFormDataMapping.class);
    private String _idPattern;
    private String _resourceType;
    private String _dataProperty;

    public ResourceItemToCdfFreeFormDataMapping(String idPattern, String resourceType, String dataProperty) {
        this._idPattern = idPattern;
        this._resourceType = resourceType;
        this._dataProperty = dataProperty;
    }

    @Override
    public FreeFormData map(NamedPropertiesResourceItem input, Context parentContext) {
        Map<String, Object> resourceItemDictionary = ResourceItemToCdfFreeFormDataMapping.createResourceItemDictionary(input);
        String idValue = this.evaluateIdPattern(resourceItemDictionary);
        if (idValue == null) {
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)String.format("Skipping current ResultItem, because its idPattern [%s] was evaluted to null.", this._idPattern));
            }
            return null;
        }
        List<AnyPrimitive[]> data = this.evaluateDataProperty(resourceItemDictionary);
        return new FreeFormData(this._resourceType, idValue, data);
    }

    private static Map<String, Object> createResourceItemDictionary(NamedPropertiesResourceItem input) {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        List<String> propertyNames = input.getActualPropertyNames();
        List<Object> propertyValues = input.getActualPropertyValues();
        for (int i = 0; i < propertyNames.size(); ++i) {
            propertiesMap.put(propertyNames.get(i), propertyValues.get(i));
        }
        return propertiesMap;
    }

    private String evaluateIdPattern(Map<String, Object> resourceItemDictionary) {
        VelocityEngine velocityEngine = VelocityHelper.createVelocityEngine();
        VelocityContext context = VelocityHelper.createVelocityContextWithPredefinedGlobalObjects();
        VelocityHelper.updateContextWith(context, resourceItemDictionary);
        return VelocityHelper.executeVelocityExpression(this._idPattern, velocityEngine, context, this._idPattern);
    }

    private List<AnyPrimitive[]> evaluateDataProperty(Map<String, Object> resourceItemDictionary) {
        Object dataValueObj = resourceItemDictionary.get(this._dataProperty);
        if (dataValueObj == null) {
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)String.format("Freeform data property [%s] is missing in query result.", this._dataProperty));
            }
            return null;
        }
        if (!Iterable.class.isAssignableFrom(dataValueObj.getClass())) {
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)String.format("Freeform data property [%s] should be an iterable of array. Cannot evaluate property.", this._dataProperty));
            }
            return null;
        }
        Iterable dataValues = (Iterable)dataValueObj;
        Iterator iterator = dataValues.iterator();
        ArrayList<AnyPrimitive[]> anyPrimitiveDataValues = new ArrayList<AnyPrimitive[]>();
        while (iterator.hasNext()) {
            Object[] dataValue = (Object[])iterator.next();
            AnyPrimitive[] anyPrimitiveValue = CdfUtil.convertObjectArrayToAnyPrimitiveArray(dataValue);
            anyPrimitiveDataValues.add(anyPrimitiveValue);
        }
        return anyPrimitiveDataValues;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }
}

