/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.cdf.mapping;

import com.vmware.ph.phservice.collector.cdf.mapping.velocity.VelocityResourceMapping;
import com.vmware.ph.phservice.collector.data.NamedPropertiesResourceItem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceItemToCdfResourceMapping
extends VelocityResourceMapping<NamedPropertiesResourceItem> {
    private static final Log logger = LogFactory.getLog(ResourceItemToCdfResourceMapping.class);
    private String _forType;

    public ResourceItemToCdfResourceMapping(String forType, String resourceType, String idPattern, Map<String, String> attributePatterns, Map<String, String> relationPatterns) {
        super(resourceType, idPattern, attributePatterns, relationPatterns);
        this._forType = forType;
    }

    @Override
    public Map<String, Object> createDictionary(NamedPropertiesResourceItem input) {
        Object resourceObject = input.getResourceObject();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will create dictionary with properties for mapping data service ResourceItem which resourceObject class is: " + resourceObject.getClass().getCanonicalName()));
        }
        if (resourceObject instanceof ManagedObjectReference) {
            ManagedObjectReference moRef = (ManagedObjectReference)resourceObject;
            if (!moRef.getType().equalsIgnoreCase(this._forType)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)String.format("Skipping current ResourceItem, because its MOR type is %s, while current resultItemMapping is for type %s.", moRef.getType(), this._forType));
                }
                return null;
            }
        } else if (resourceObject instanceof URI) {
            URI uri = (URI)resourceObject;
            if (!uri.toString().toLowerCase().startsWith(this._forType.toLowerCase())) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)String.format("Skipping current ResourceItem, because its URI type is %s, while current resultItemMapping is for type %s.", uri, this._forType));
                }
                return null;
            }
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Skipping current ResourceItem, because its resourceObject is not of one of the supported types (ManagedObjectReference or java.net.URI).Its type is: " + resourceObject.getClass().getCanonicalName()));
            }
            return null;
        }
        return this.createPropertiesMap(input);
    }

    private Map<String, Object> createPropertiesMap(NamedPropertiesResourceItem input) {
        Object resourceObject = input.getResourceObject();
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put("resultItem-resourceObject-class", resourceObject.getClass().getCanonicalName());
        if (resourceObject instanceof ManagedObjectReference) {
            ManagedObjectReference moref = (ManagedObjectReference)resourceObject;
            propertiesMap.put("moref-serverGuid", moref.getServerGuid() == null ? null : moref.getServerGuid().toUpperCase());
            propertiesMap.put("moref-value", moref.getValue());
        }
        if (resourceObject instanceof URI) {
            URI uri = (URI)resourceObject;
            propertiesMap.put("resultItem-resourceObject-uri", uri);
        }
        List<String> propertyNames = input.getActualPropertyNames();
        List<Object> propertyValues = input.getActualPropertyValues();
        for (int i = 0; i < propertyNames.size(); ++i) {
            propertiesMap.put(propertyNames.get(i), propertyValues.get(i));
        }
        return propertiesMap;
    }
}

