/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.cdf.mapping;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.commondataformat20.Payload20;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.cdf.mapping.Mapping;
import com.vmware.ph.phservice.collector.cdf.mapping.velocity.VelocityResourceMapping;
import com.vmware.ph.phservice.collector.data.NamedPropertiesResourceItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetToCdfPayloadMapping
implements Mapping<ResultSet, Payload20> {
    private static final Log logger = LogFactory.getLog(ResultSetToCdfPayloadMapping.class);
    private final List<Mapping<NamedPropertiesResourceItem, ? extends CdfAble>> _itemMappings;
    private final ResultSetResourceMapping _setMapping;

    public ResultSetToCdfPayloadMapping(List<Mapping<NamedPropertiesResourceItem, ? extends CdfAble>> itemMappings, ResultSetResourceMapping setMapping) {
        this._itemMappings = itemMappings;
        this._setMapping = setMapping;
    }

    @Override
    public Payload20 map(ResultSet input, Context context) {
        Payload20.Builder builder = new Payload20.Builder();
        this.applyItemMappings(input, builder, context);
        this.applySetMapping(input, builder, context);
        return builder.build();
    }

    private void applySetMapping(ResultSet input, Payload20.Builder builder, Context context) {
        Resource result;
        if (this._setMapping != null && (result = this._setMapping.map(input, context)) != null) {
            builder.add((CdfAble)result);
        }
    }

    private void applyItemMappings(ResultSet input, Payload20.Builder builder, Context context) {
        if (input.getItems() == null) {
            return;
        }
        for (ResourceItem item : input.getItems()) {
            for (Mapping<NamedPropertiesResourceItem, ? extends CdfAble> itemMapping : this._itemMappings) {
                NamedPropertiesResourceItem namedPropertiesResourceItem;
                CdfAble result = itemMapping.map(namedPropertiesResourceItem = new NamedPropertiesResourceItem(item, input.getProperties()), context);
                if (result instanceof Payload20) {
                    builder.add((Payload20)result);
                } else if (result instanceof CdfAble) {
                    builder.add(result);
                } else if (result != null && logger.isDebugEnabled()) {
                    logger.debug((Object)("Ignoring unexpected result of type " + result.getClass().getName()));
                }
                if (!(itemMapping instanceof VelocityResourceMapping)) continue;
                Payload20 payload = ((VelocityResourceMapping)itemMapping).getPayload();
                if (payload == null) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("getPayload() returned null for item " + item));
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)String.format("getPayload() returned payload for item %s with %d resources and %d free forms.", item, payload.getResources().size(), payload.getFreeforms().size()));
                }
                builder.add(payload);
            }
        }
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }

    public String toString() {
        return "ResultSetToCdfPayloadMapping [itemMappings=" + this._itemMappings + "]";
    }

    public static class ResultSetResourceMapping
    extends VelocityResourceMapping<ResultSet> {
        public ResultSetResourceMapping(String resourceType, String idPattern, Map<String, String> attributePatterns, Map<String, String> relationPatterns) {
            super(resourceType, idPattern, attributePatterns, relationPatterns);
        }

        @Override
        public Map<String, Object> createDictionary(ResultSet input) {
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put("totalMatchedObjectCount", input.getTotalCount());
            return ctx;
        }
    }
}

