/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.cdf.mapping.velocity;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.ph.client.api.commondataformat20.Payload20;
import com.vmware.ph.phservice.collector.cdf.mapping.velocity.CalendarUtil;
import com.vmware.ph.phservice.collector.cdf.mapping.velocity.SystemWrapper;
import com.vmware.ph.phservice.collector.data.NamedPropertiesResourceItem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.util.introspection.SecureUberspector;

public final class VelocityHelper {
    public static final Log log = LogFactory.getLog(VelocityHelper.class);
    private static final String GLOBAL_PREDEFINED_PREFIX = "GLOBAL-";
    private static final String GLOBAL_EMPTY = "GLOBAL-EMPTY";
    private static final String GLOBAL_Integer = "GLOBAL-" + Integer.class.getSimpleName();
    private static final String GLOBAL_logger = "GLOBAL-logger";
    private static final String GLOBAL_System = "GLOBAL-System";
    private static final String GLOBAL_Arrays = "GLOBAL-" + Arrays.class.getSimpleName();
    private static final String GLOBAL_Collections = "GLOBAL-" + Collections.class.getSimpleName();
    private static final String GLOBAL_DigestUtils = "GLOBAL-" + DigestUtils.class.getSimpleName();
    private static final String GLOBAL_CalendarUtil = "GLOBAL-" + CalendarUtil.class.getSimpleName();
    private static final String LOCAL_PREDEFINED_PREFIX = "LOCAL-";
    private static final String LOCAL_OUTPUT = "LOCAL-output";
    private static final String LOCAL_RESOURCE_ITEM = "LOCAL-resourceItem";
    private static final String MOREF_OBJECT = "moref-object";
    private static final String MOREF_OBJECT_SERVER_GUID = "moref-serverGuid";
    private static final String MOREF_OBJECT_VALUE = "moref-value";
    private static final String MOREF_OBJECT_TYPE = "moref-type";
    public static final String LOCAL_CDF20RESULT = "LOCAL-cdf20Result";
    private static final Map<String, Object> predefinedVelocityObjects;

    public static VelocityContext createVelocityContextWithPredefinedGlobalObjects() {
        VelocityContext context = new VelocityContext();
        VelocityHelper.updateContextWith(context, predefinedVelocityObjects);
        return context;
    }

    public static VelocityEngine createVelocityEngine() {
        Properties properties = new Properties();
        properties.setProperty("runtime.references.strict", "true");
        properties.setProperty("runtime.references.strict.escape", "true");
        properties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogChute");
        properties.setProperty("runtime.introspector.uberspect", SecureUberspector.class.getName());
        return new VelocityEngine(properties);
    }

    public static void updateContextWith(VelocityContext context, Map<String, Object> objectsToAdd) {
        for (Map.Entry<String, Object> ent : objectsToAdd.entrySet()) {
            VelocityHelper.updateContextWith(context, ent.getKey(), ent.getValue());
        }
    }

    public static void updateContextWith(VelocityContext context, String key, Object value) {
        StringBuilder sb = new StringBuilder(key.length());
        for (int n : key.toCharArray()) {
            if (!(n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 95 || n == 45)) {
                n = 45;
            }
            sb.append((char)n);
        }
        context.put(sb.toString(), value);
    }

    public static String executeVelocityExpression(String expression, VelocityEngine velocityEngine, VelocityContext substitutor, String logTag) {
        try {
            StringWriter dummySw = new StringWriter();
            velocityEngine.evaluate((Context)substitutor, (Writer)dummySw, logTag, expression);
            return dummySw.toString();
        }
        catch (VelocityException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Returning null for input expression %s, because of VelocityException. Exception is: %s", expression, ExceptionUtils.getMessage((Throwable)e)));
            }
            return null;
        }
    }

    public static Map<String, Object> prepareVelocityPropertiesForResourceItemsThatMayContainMoref(ResourceItem input) {
        TreeMap<String, Object> attributes = new TreeMap<String, Object>();
        Object resourceObject = input.getPropertyValues().get(0);
        if (resourceObject instanceof ManagedObjectReference) {
            ManagedObjectReference moref = (ManagedObjectReference)resourceObject;
            attributes.put(MOREF_OBJECT, moref);
            attributes.put(MOREF_OBJECT_TYPE, moref == null ? null : moref.getType());
            attributes.put(MOREF_OBJECT_VALUE, moref == null ? null : moref.getValue());
            attributes.put(MOREF_OBJECT_SERVER_GUID, moref == null ? null : moref.getServerGuid());
        }
        return attributes;
    }

    public static Map<String, Object> prepareVelocityPropertiesFromResourceItem(NamedPropertiesResourceItem input) {
        TreeMap<String, Object> attributes = new TreeMap<String, Object>();
        List<String> propertyNames = input.getActualPropertyNames();
        List<Object> propertyValues = input.getActualPropertyValues();
        for (int i = 0; i < propertyNames.size(); ++i) {
            attributes.put(propertyNames.get(i), propertyValues.get(i));
        }
        attributes.put(LOCAL_RESOURCE_ITEM, input);
        return attributes;
    }

    public static Map<String, Object> evaluateAttributes(Map<String, String> attributePatterns, VelocityEngine velocityEngine, VelocityContext context) {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        Set<Map.Entry<String, String>> attribs = attributePatterns.entrySet();
        for (Map.Entry<String, String> attr : attribs) {
            String attrName = attr.getKey();
            String attrMapping = attr.getValue();
            Object rawValue = context.get(attrMapping);
            if (rawValue != null) {
                res.put(attrName, rawValue);
                continue;
            }
            if (!attrMapping.contains("$")) continue;
            String value = VelocityHelper.executeVelocityExpression(attrMapping, velocityEngine, context, attrName);
            if (value != null) {
                res.put(attrName, value);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Cannot evaluate the value of attribute '" + attrName + "' - it's mapping (from the manifest) is: " + attrMapping));
        }
        return res;
    }

    public static void updateContextWith(VelocityContext context, NamedPropertiesResourceItem resourceItem) {
        VelocityHelper.updateContextWith(context, LOCAL_RESOURCE_ITEM, resourceItem);
    }

    public static void updateContextWith(VelocityContext context, Payload20.Builder payloadBuilder) {
        VelocityHelper.updateContextWith(context, LOCAL_OUTPUT, payloadBuilder);
    }

    static {
        TreeMap<String, Class> m = new TreeMap<String, Class>();
        m.put(GLOBAL_EMPTY, null);
        m.put(GLOBAL_DigestUtils, DigestUtils.class);
        m.put(GLOBAL_Collections, Collections.class);
        m.put(GLOBAL_Arrays, Arrays.class);
        m.put(GLOBAL_System, SystemWrapper.class);
        m.put(GLOBAL_logger, (Class)log);
        m.put(GLOBAL_CalendarUtil, CalendarUtil.class);
        m.put(GLOBAL_Integer, Integer.class);
        predefinedVelocityObjects = Collections.unmodifiableMap(m);
    }
}

