/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.core;

import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.phservice.CollectionPeriod;
import com.vmware.ph.phservice.PayloadAuditPersisterProvider;
import com.vmware.ph.phservice.collector.core.Collector;
import com.vmware.ph.phservice.collector.core.impl.CollectorImpl;
import com.vmware.ph.phservice.common.cdf.ManifestContentProvider;
import com.vmware.ph.phservice.common.cdf.PayloadUploader;
import com.vmware.ph.phservice.provider.common.Builder;
import com.vmware.ph.phservice.provider.common.DataProvidersConnection;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClientProvider;
import java.util.Properties;

public class CollectorBuilder
implements Builder<Collector> {
    private final DataProvidersConnection _dataProvidersConnection;
    private ManifestContentProvider _manifestContentProvider;
    private PayloadUploader _payloadUploader;
    private PayloadAuditPersisterProvider _payloadAuditPersisterProvider;
    private ProxySettingsProvider _proxySettingsProvider;
    private CollectionPeriod _collectionPeriod = CollectionPeriod.WEEKLY;
    private Properties _properties = new Properties();
    private VcClientProvider _vcClientProvider;

    private CollectorBuilder(DataProvidersConnection dataProvidersConnection) {
        this._dataProvidersConnection = dataProvidersConnection;
    }

    public static CollectorBuilder forConnection(DataProvidersConnection dataProvidersConnection) {
        return new CollectorBuilder(dataProvidersConnection);
    }

    public CollectorBuilder withManifestContentProvider(ManifestContentProvider manifestContentProvider) {
        this._manifestContentProvider = manifestContentProvider;
        return this;
    }

    public CollectorBuilder withPayloadUploader(PayloadUploader payloadUploader) {
        this._payloadUploader = payloadUploader;
        return this;
    }

    public CollectorBuilder withPayloadAuditPersisterProvider(PayloadAuditPersisterProvider payloadAuditPersisterProvider) {
        this._payloadAuditPersisterProvider = payloadAuditPersisterProvider;
        return this;
    }

    public CollectorBuilder withPoxySettingsProvider(ProxySettingsProvider proxySettingsProvider) {
        this._proxySettingsProvider = proxySettingsProvider;
        return this;
    }

    public CollectorBuilder withPeriod(CollectionPeriod collectionPeriod) {
        this._collectionPeriod = collectionPeriod;
        return this;
    }

    public CollectorBuilder withProperties(Properties properties) {
        this._properties = properties;
        return this;
    }

    public CollectorBuilder withVcClientProvider(VcClientProvider vcClientProvider) {
        this._vcClientProvider = vcClientProvider;
        return this;
    }

    @Override
    public Collector build() {
        CollectorImpl collector = new CollectorImpl(this._dataProvidersConnection, this._manifestContentProvider, this._payloadUploader, this._payloadAuditPersisterProvider, this._proxySettingsProvider, this._properties, this._vcClientProvider, this._collectionPeriod);
        return collector;
    }
}

