/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.core.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.ph.client.api.commondataformat.PayloadEnvelope;
import com.vmware.ph.client.api.commondataformat.dimensions.Collector;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.AnyPrimitive;
import com.vmware.ph.client.api.commondataformat20.Payload20;
import com.vmware.ph.phservice.CollectorOutcome;
import com.vmware.ph.phservice.collector.ContainsErrorInfo;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.ContextFactory;
import com.vmware.ph.phservice.collector.cdf.CdfCollector;
import com.vmware.ph.phservice.collector.cdf.CollectedPayload;
import com.vmware.ph.phservice.collector.core.impl.CollectorAgentProvider;
import com.vmware.ph.phservice.collector.file.CollectedFile;
import com.vmware.ph.phservice.collector.file.FileCollector;
import com.vmware.ph.phservice.collector.manifest.Manifest;
import com.vmware.ph.phservice.common.cdf.ManifestContentProvider;
import com.vmware.ph.phservice.common.cdf.PayloadUploader;
import java.io.Closeable;
import java.io.File;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UsageDataCollector {
    private static final String RAN_PAYLOAD_COUNT = "payload_count";
    private static final String RAN_PAGE_SIZE = "page_size";
    private static final String RT_COLLECTION_SUMMARY = "collection_summary";
    private static final String RT_COLLECTION = "collection";
    private static final String CT_STRUCTURED_DATA = "structured_data";
    private static final String CT_FILE_BASED = "file_based";
    private static final String RAN_COLLECTION_TYPE = "collection_type";
    private static final String RAN_SUCCESSFUL_ATTEMPTS = "successful_attempts";
    private static final String RAN_UPLOAD_ATTEMPTS = "upload_attempts";
    private static final Log _log = LogFactory.getLog(UsageDataCollector.class);
    private final CdfCollector _cdfCollector;
    private final FileCollector _fileCollector;
    private final ContextFactory _contextFactory;
    private final CollectorAgentProvider _collectorAgentProvider;
    private final ManifestContentProvider _manifestProvider;
    private final PayloadUploader _payloadUploader;

    public UsageDataCollector(CdfCollector cdfCollector, FileCollector fileCollector, ContextFactory contextFactory, CollectorAgentProvider collectorAgentProvider, ManifestContentProvider localFsManifestProvider, PayloadUploader localFsPayloadUploader) {
        this._cdfCollector = cdfCollector;
        this._fileCollector = fileCollector;
        this._contextFactory = contextFactory;
        this._collectorAgentProvider = collectorAgentProvider;
        this._manifestProvider = localFsManifestProvider;
        this._payloadUploader = localFsPayloadUploader;
    }

    public String getPhClientManifest() throws ManifestContentProvider.ManifestException {
        CollectionInfo collectionInfo = this.prepareCollectionInfo();
        String manifestContent = this._manifestProvider.getManifestContent(collectionInfo.collector.getCollectorId(), collectionInfo.collector.getCollectorInstanceId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Retrieved manifest: " + StringUtils.abbreviate((String)manifestContent, (int)1000)));
        }
        return manifestContent;
    }

    public CollectorOutcome collect(QueryService queryService, Manifest manifest) {
        try {
            CollectionInfo collectionInfo = this.prepareCollectionInfo();
            if (_log.isInfoEnabled()) {
                _log.info((Object)"started collection process");
            }
            return this.collectAndUpload(collectionInfo, queryService, manifest);
        }
        catch (InterruptedException e) {
            _log.error((Object)"Upload interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
            return CollectorOutcome.LOCAL_ERROR;
        }
    }

    private CollectionInfo prepareCollectionInfo() {
        String collectorId = this._collectorAgentProvider.getCollectorId();
        String collectorInstanceId = this._collectorAgentProvider.getCollectorInstanceId();
        Collector collector = new Collector(collectorId, collectorInstanceId);
        CollectionInfo collectionInfo = new CollectionInfo(collector);
        return collectionInfo;
    }

    private CollectorOutcome collectAndUpload(CollectionInfo collectionInfo, QueryService queryService, Manifest manifest) throws InterruptedException {
        Context context = this.createMappingContext(collectionInfo);
        CollectionStatistics structuredDataStatistics = new CollectionStatistics();
        this.processStructuredDataCollectors(collectionInfo, manifest, queryService, context, structuredDataStatistics);
        this.logCollectionStatistics(structuredDataStatistics, CT_STRUCTURED_DATA);
        CollectionStatistics fileBasedStatistics = new CollectionStatistics();
        this.processFileBasedCollectors(collectionInfo, manifest, queryService, context, fileBasedStatistics);
        this.logCollectionStatistics(fileBasedStatistics, CT_FILE_BASED);
        int fatalErrorCount = structuredDataStatistics.fatalErrorCount + fileBasedStatistics.fatalErrorCount;
        return fatalErrorCount > 0 ? CollectorOutcome.LOCAL_ERROR : CollectorOutcome.PASSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStructuredDataCollectors(CollectionInfo collectionInfo, Manifest manifest, QueryService queryService, Context context, CollectionStatistics statistics) throws InterruptedException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("started processing structured data collectors, collection id %s.", collectionInfo.collectionId));
        }
        int accumulationSize = manifest.getRecommendedPageSize();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Page size: " + accumulationSize));
        }
        Iterable<CollectedPayload> payloads = this._cdfCollector.collect(manifest, queryService, context, accumulationSize);
        Payload20.Builder uploadBuilder = new Payload20.Builder();
        Iterator<CollectedPayload> collectedPayloadIter = payloads.iterator();
        CollectedPayload collectedPayload = null;
        int accumulatedResource = 0;
        try {
            while (collectedPayloadIter.hasNext()) {
                collectedPayload = collectedPayloadIter.next();
                ++statistics.payloadCount;
                this.updateErrorStatistic(statistics, collectedPayload);
                Payload20 payload = collectedPayload.getPayload();
                uploadBuilder.add(payload.getCdfs());
                if ((accumulatedResource += this.resourceCount(payload)) < accumulationSize) continue;
                this.upload(collectionInfo, statistics, uploadBuilder.build(), null);
                accumulatedResource = 0;
                uploadBuilder = new Payload20.Builder();
            }
        }
        finally {
            if (collectedPayloadIter instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Closeable)((Object)collectedPayloadIter)));
            }
        }
        if (accumulatedResource > 0) {
            this.upload(collectionInfo, statistics, uploadBuilder.build(), null);
        }
        this.sendCollectionSummaryResource(collectionInfo, statistics, CT_STRUCTURED_DATA, accumulationSize);
    }

    private void sendCollectionSummaryResource(CollectionInfo collectionInfo, CollectionStatistics statistics, String collectionType, int pageSize) throws InterruptedException {
        if (statistics.payloadCount == 0) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("There are no payloads for collection type %s, will not send summary resource.", collectionType));
            }
            return;
        }
        Resource collectionResource = this.createCollectionResource(collectionInfo);
        Resource summaryResource = this.createSummaryResource(statistics, collectionType, pageSize);
        Payload20.Builder payloadBuilder = new Payload20.Builder();
        payloadBuilder.add((CdfAble)collectionResource);
        payloadBuilder.add((CdfAble)summaryResource);
        String uploadId = this.getNextUploadId();
        PayloadEnvelope header = new PayloadEnvelope(collectionInfo.collector);
        try {
            Payload20 payload = payloadBuilder.build();
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("Initiated upload of summary resource for collection type %s.", collectionType));
            }
            Future<?> uploadTask = this._payloadUploader.uploadPayload(payload, header, uploadId);
            uploadTask.get();
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("Completed upload of summary resource for collection type {}.", collectionType));
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            _log.error((Object)"Exception occured while uploading summary resource.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFileBasedCollectors(CollectionInfo collectionInfo, Manifest manifest, QueryService queryService, Context context, CollectionStatistics statistics) throws InterruptedException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("started processing file based collectors, collection id %s.", collectionInfo.collectionId));
        }
        int recommendedPageSize = manifest.getRecommendedPageSize();
        Iterable<CollectedFile> files = this._fileCollector.collect(manifest, queryService, context, recommendedPageSize);
        for (CollectedFile file : files) {
            ++statistics.payloadCount;
            this.updateErrorStatistic(statistics, file);
            if (file.getFile() != null) {
                try {
                    this.upload(collectionInfo, statistics, null, file.getFile());
                    continue;
                }
                finally {
                    file.dispose();
                    continue;
                }
            }
            _log.warn((Object)"CollectedFile without existing file was found.");
        }
        this.sendCollectionSummaryResource(collectionInfo, statistics, CT_FILE_BASED, 0);
    }

    private void updateErrorStatistic(CollectionStatistics statistics, ContainsErrorInfo dataPackage) {
        if (dataPackage.getCollectorError() != null) {
            ++statistics.errorCount;
            statistics.fatalErrorCount = statistics.fatalErrorCount + (dataPackage.hasFatalError() ? 1 : 0);
        }
    }

    private void upload(CollectionInfo collectionInfo, CollectionStatistics statistics, Payload20 payload, File file) throws InterruptedException {
        assert (payload != null || file != null);
        String uploadId = this.getNextUploadId();
        try {
            Future<?> uploadTask;
            ++statistics.attemptedUploads;
            if (payload != null) {
                PayloadEnvelope header = new PayloadEnvelope(collectionInfo.collector);
                Payload20 payloadWithCollectionResource = this.preparePayloadWithCollectionResource(collectionInfo, payload);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)String.format("Initiated local fs payload upload (%d resources)", payloadWithCollectionResource.getResources().size()));
                }
                uploadTask = this._payloadUploader.uploadPayload(payloadWithCollectionResource, header, uploadId);
            } else {
                String collectorId = collectionInfo.collector.getCollectorId();
                String instanceId = collectionInfo.collector.getCollectorInstanceId();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Initiated upload of file: " + file.getAbsolutePath()));
                }
                uploadTask = this._payloadUploader.uploadFile(collectorId, instanceId, uploadId, file);
            }
            uploadTask.get();
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Upload completed successfully.");
            }
            ++statistics.successfulUploads;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            this.logUploadError(cause);
        }
    }

    private Payload20 preparePayloadWithCollectionResource(CollectionInfo collectionInfo, Payload20 payload) {
        Payload20.Builder payloadBuilder = new Payload20.Builder();
        payloadBuilder.add((CdfAble)this.createCollectionResource(collectionInfo));
        payloadBuilder.add(payload);
        return payloadBuilder.build();
    }

    private Resource createCollectionResource(CollectionInfo collectionInfo) {
        Resource collectionResource = new Resource(RT_COLLECTION, collectionInfo.collectionId, null, null);
        return collectionResource;
    }

    private Resource createSummaryResource(CollectionStatistics statistics, String collectionType, int pageSize) {
        Resource.KeyValue[] summaryAttributes = new Resource.KeyValue[]{new Resource.KeyValue(RAN_UPLOAD_ATTEMPTS, new AnyPrimitive(Integer.valueOf(statistics.attemptedUploads))), new Resource.KeyValue(RAN_SUCCESSFUL_ATTEMPTS, new AnyPrimitive(Integer.valueOf(statistics.attemptedUploads))), new Resource.KeyValue(RAN_PAYLOAD_COUNT, new AnyPrimitive(Integer.valueOf(statistics.payloadCount))), new Resource.KeyValue(RAN_COLLECTION_TYPE, new AnyPrimitive(collectionType)), new Resource.KeyValue(RAN_PAGE_SIZE, new AnyPrimitive(Integer.valueOf(pageSize)))};
        String id = UUID.randomUUID().toString().replace("-", "");
        return new Resource(RT_COLLECTION_SUMMARY, id, summaryAttributes, null);
    }

    private Context createMappingContext(CollectionInfo collectionInfo) {
        return this._contextFactory.createContext(collectionInfo.collector, collectionInfo.collectionId);
    }

    private String getNextUploadId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private int resourceCount(Payload20 payload) {
        return payload.getCdfs().size();
    }

    private void logUploadError(Throwable e) {
        String reason = e instanceof PayloadUploader.PayloadUploadException ? "Payload upload" : "Unexpected";
        _log.warn((Object)(reason + " exception while trying to upload: " + e.getMessage()), e);
    }

    private void logCollectionStatistics(CollectionStatistics statistics, String statisticsLabel) {
        if (_log.isInfoEnabled()) {
            StringBuilder msg = new StringBuilder("Usage data collection of type ");
            msg.append(statisticsLabel);
            msg.append(" completed ");
            if (statistics.errorCount > 0) {
                msg.append(" with ").append(statistics.errorCount).append(" error(s) (").append(statistics.fatalErrorCount).append(" fatal.)");
            } else {
                msg.append(" without errors.");
            }
            msg.append(" There were ").append(statistics.successfulUploads).append(" successful uploads of total ").append(statistics.attemptedUploads).append(" attempts. Collected payload count is ").append(statistics.payloadCount).append(".");
            _log.info((Object)msg.toString());
        }
    }

    private static final class CollectionStatistics {
        public int attemptedUploads = 0;
        public int successfulUploads = 0;
        public int errorCount = 0;
        public int fatalErrorCount = 0;
        public int payloadCount = 0;

        private CollectionStatistics() {
        }
    }

    private static final class CollectionInfo {
        public final Collector collector;
        public final String collectionId;

        public CollectionInfo(Collector collectorInfo) {
            this.collector = collectorInfo;
            this.collectionId = UUID.randomUUID().toString().replace("-", "");
        }
    }
}

