/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.core.impl;

import com.vmware.ph.phservice.collector.Aggregators;
import com.vmware.ph.phservice.collector.ContextFactory;
import com.vmware.ph.phservice.collector.cdf.CdfCollector;
import com.vmware.ph.phservice.collector.cdf.QueryServiceCdfCollector;
import com.vmware.ph.phservice.collector.core.impl.CollectorAgentProvider;
import com.vmware.ph.phservice.collector.core.impl.UsageDataCollector;
import com.vmware.ph.phservice.collector.file.FileCollector;
import com.vmware.ph.phservice.collector.file.QueryServiceFileCollector;
import com.vmware.ph.phservice.common.cdf.ManifestContentProvider;
import com.vmware.ph.phservice.common.cdf.PayloadUploader;
import java.util.Arrays;

public class UsageDataCollectorBuilder {
    private final ContextFactory _contextFactory;
    private final CollectorAgentProvider _collectorAgentProvider;
    private final ManifestContentProvider _manifestContentProvider;
    private final PayloadUploader _payloadUploader;

    public UsageDataCollectorBuilder(ContextFactory contextFactory, CollectorAgentProvider collectorAgentProvider, ManifestContentProvider manifestContentProvider, PayloadUploader payloadUploader) {
        this._contextFactory = contextFactory;
        this._collectorAgentProvider = collectorAgentProvider;
        this._manifestContentProvider = manifestContentProvider;
        this._payloadUploader = payloadUploader;
    }

    public UsageDataCollector build() {
        QueryServiceCdfCollector queryServiceCdfCollector = new QueryServiceCdfCollector();
        CdfCollector cdfCollectors = Aggregators.cdf(Arrays.asList(queryServiceCdfCollector));
        QueryServiceFileCollector queryServiceFileCollector = new QueryServiceFileCollector();
        FileCollector fileCollectors = Aggregators.file(Arrays.asList(queryServiceFileCollector));
        UsageDataCollector phUsageDataCollector = new UsageDataCollector(cdfCollectors, fileCollectors, this._contextFactory, this._collectorAgentProvider, this._manifestContentProvider, this._payloadUploader);
        return phUsageDataCollector;
    }
}

