/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.core.impl;

import com.vmware.ph.client.api.commondataformat.dimensions.Collector;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.ContextFactory;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClientProvider;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.Capability;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;

public class VcContextFactory
implements ContextFactory {
    static final String VC_ID_NAME = "global-vcId";
    static final String SERVICE_INSTANCE_CAPABILITY_NAME = "SI-Capability";
    static final String SERVICE_INSTANCE_ABOUT_INFO_NAME = "SI-About";
    private VcClientProvider _vcClientProvider;

    public VcContextFactory(VcClientProvider vcClientProvider) {
        this._vcClientProvider = vcClientProvider;
    }

    @Override
    public Context createContext(Collector collector, String collectionId) {
        VcClient vcClient = this._vcClientProvider.getVcClient();
        ServiceInstance serviceInstance = this.getServiceInstance(vcClient);
        AboutInfo aboutInfo = serviceInstance.getContent().getAbout();
        String vcGuid = aboutInfo.getInstanceUuid();
        Capability capability = serviceInstance.getCapability();
        Context context = new Context(collector, collectionId);
        context.put(VC_ID_NAME, vcGuid.toUpperCase());
        context.put(SERVICE_INSTANCE_CAPABILITY_NAME, capability);
        context.put(SERVICE_INSTANCE_ABOUT_INFO_NAME, aboutInfo);
        return context;
    }

    private ServiceInstance getServiceInstance(VcClient vcClient) {
        ManagedObjectReference serviceInstanceMoRef = new ManagedObjectReference("ServiceInstance", "ServiceInstance");
        return (ServiceInstance)vcClient.createMo(serviceInstanceMoRef);
    }
}

