/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.data;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.ph.phservice.collector.data.NamedQuery;
import com.vmware.ph.phservice.collector.data.NamedQueryResultSet;
import com.vmware.ph.phservice.collector.data.QueryPagingIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BatchQueryPagingIterator
implements Iterator<NamedQueryResultSet> {
    private static final Log _log = LogFactory.getLog(BatchQueryPagingIterator.class);
    private final QueryService _queryService;
    private final NamedQuery[] _queries;
    private final int _pageSize;
    private int _currentQueryIdx;
    private QueryPagingIterator _currentQueryPager;

    public BatchQueryPagingIterator(QueryService queryService, NamedQuery[] queries, int pageSize) {
        this._queryService = queryService;
        this._queries = queries;
        this._pageSize = pageSize;
        this._currentQueryIdx = 0;
        this._currentQueryPager = new QueryPagingIterator(queries[0], this._pageSize, this._queryService);
    }

    @Override
    public boolean hasNext() {
        return this._currentQueryIdx < this._queries.length - 1 || this._currentQueryPager.hasNext();
    }

    @Override
    public NamedQueryResultSet next() {
        long startTimeNanos = System.nanoTime();
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next item is available in the iterator.");
        }
        if (!this._currentQueryPager.hasNext()) {
            ++this._currentQueryIdx;
            NamedQuery nextQuery = this._queries[this._currentQueryIdx];
            this._currentQueryPager = new QueryPagingIterator(nextQuery, this._pageSize, this._queryService);
        }
        ResultSet nextPage = this._currentQueryPager.next();
        this.logResultForDebugging(this._currentQueryPager, nextPage);
        NamedQueryResultSet namedQueryResultSet = new NamedQueryResultSet(nextPage, this.getCurrentQueryName(), this._currentQueryPager.getCurrentObjectCounter(), this._currentQueryPager.getCurrentPageIndex(), startTimeNanos);
        return namedQueryResultSet;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private String getCurrentQueryName() {
        NamedQuery namedQuery = this._currentQueryPager.getBaseNamedQuery();
        String name = namedQuery.getName();
        Collection resourceModels = namedQuery.getQuery().getResourceModels();
        String constraint = (String)resourceModels.iterator().next();
        if (name != null) {
            return name;
        }
        return constraint;
    }

    private void logResultForDebugging(QueryPagingIterator pager, ResultSet resultSet) {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("Usage data collection result for query #%d (%s):\n%s", this._currentQueryIdx, pager.getPageInfo(), resultSet));
        }
    }
}

